/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class ViewLocalAclCommand
extends AbstractCommand {
    public static final Log log = LogFactory.getLog(ViewLocalAclCommand.class);

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        DocumentModel doc;
        String[] elements = cmdLine.getParameters();
        if (elements.length == 1) {
            Path path = new Path(elements[0]);
            try {
                doc = this.context.fetchDocument(path);
            }
            catch (Exception e) {
                log.error((Object)"Failed to retrieve the given folder", (Throwable)e);
                return;
            }
        } else {
            doc = this.context.fetchDocument();
        }
        this.viewLocalAce((CoreSession)this.context.getCoreSession(), doc);
    }

    protected void viewLocalAce(CoreSession session, DocumentModel doc) throws Exception {
        ACP acp = session.getACP(doc.getRef());
        ACL acl = acp.getACL("local");
        if (acl == null) {
            log.info((Object)"No local acl for the current document");
            return;
        }
        ACE[] aces = acl.getACEs();
        if (aces.length <= 0) {
            log.info((Object)"No local acl for the current document");
            return;
        }
        for (int i = 0; i < aces.length; ++i) {
            ACE ace = aces[i];
            log.info((Object)(i + ".\tUsername:" + ace.getUsername() + "\tPermission:" + ace.getPermission() + "\tGrant:" + ace.isGranted()));
        }
    }
}

