/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.system;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class LogCommand
extends AbstractCommand {
    private static final String CONSOLE_APPENDER_NAME = "CONSOLE";
    private static final String DEFAULT_CATEGORY = "org.nuxeo.ecm.shell";
    private static final Log log = LogFactory.getLog(LogCommand.class);
    private static boolean debug = false;
    private static final String FULL_PATTERN_LAYOUT = "%d{HH:mm:ss,SSS} %-5p [%C{1}] %m%n";
    private static final String LIGHT_PATTERN_LAYOUT = "%m%n";

    private void printHelp() {
        System.out.println("");
        System.out.println("Syntax: log filename [log level [package or class]]");
        System.out.println("        log off [package or class]");
        System.out.println("        log debug");
        System.out.println(" filename : logging file destination (writes in append mode)");
        System.out.println(" log level : (optionnal, default=INFO): available values are TRACE, DEBUG, INFO, WARN, ERROR, FATAL");
        System.out.println(" package or class (optionnal, default=\"org.nuxeo.ecm.shell\"): category logged (see Log4J doc. for more details)");
        System.out.println("");
        System.out.println("\"log off\" command stops given logger or all custom loggers if none is specified (resets configuration)");
        System.out.println("");
        System.out.println("\"log debug\" command switches DEBUG mode on/off");
    }

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String[] elements = cmdLine.getParameters();
        if (elements.length == 0) {
            log.error((Object)"SYNTAX ERROR: the log command must take at least one argument: log [filename|off|debug]");
            this.printHelp();
            return;
        }
        if ("off".equals(elements[0])) {
            this.removeLogger(elements);
        } else if ("debug".equals(elements[0])) {
            LogCommand.setDebug(!debug);
        } else {
            try {
                this.setLogger(elements);
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Couldn't create or open " + elements[0]), (Throwable)e);
            }
        }
    }

    private void removeLogger(String[] elements) {
        if (elements.length > 1) {
            Logger.getLogger((String)elements[1]).removeAllAppenders();
        } else {
            Enumeration loggers = LogManager.getCurrentLoggers();
            while (loggers.hasMoreElements()) {
                Logger logger = (Logger)loggers.nextElement();
                logger.removeAllAppenders();
            }
            Logger.getLogger((String)DEFAULT_CATEGORY).removeAllAppenders();
        }
    }

    private void setLogger(String[] elements) throws FileNotFoundException {
        Logger logger = elements.length > 2 ? Logger.getLogger((String)elements[2]) : Logger.getLogger((String)DEFAULT_CATEGORY);
        if (!elements[0].contains(File.separator)) {
            elements[0] = "log" + File.separator + elements[0];
        }
        FileOutputStream out = new FileOutputStream(elements[0]);
        WriterAppender appender = new WriterAppender((Layout)new PatternLayout(FULL_PATTERN_LAYOUT), (OutputStream)out);
        logger.addAppender((Appender)appender);
        if (elements.length > 1) {
            logger.setLevel(Level.toLevel((String)elements[1]));
        } else {
            logger.setLevel(Level.INFO);
        }
    }

    public static void setDebug(boolean debugMode) {
        debug = debugMode;
        if (debugMode) {
            Appender consoleAppender = Logger.getLogger((String)DEFAULT_CATEGORY).getAppender(CONSOLE_APPENDER_NAME);
            consoleAppender.setLayout((Layout)new PatternLayout(FULL_PATTERN_LAYOUT));
            Logger.getRootLogger().setLevel(Level.DEBUG);
            Logger.getLogger((String)DEFAULT_CATEGORY).setLevel(Level.DEBUG);
            Logger.getLogger((String)"org.nuxeo").setLevel(Level.DEBUG);
            log.info((Object)"Log level set to DEBUG");
        } else {
            Appender consoleAppender = Logger.getLogger((String)DEFAULT_CATEGORY).getAppender(CONSOLE_APPENDER_NAME);
            consoleAppender.setLayout((Layout)new PatternLayout(LIGHT_PATTERN_LAYOUT));
            Logger.getRootLogger().setLevel(Level.WARN);
            Logger.getLogger((String)DEFAULT_CATEGORY).setLevel(Level.INFO);
            Logger.getLogger((String)"org.nuxeo").setLevel(Level.INFO);
            log.info((Object)"Log level reset to WARN for log file and INFO for console");
        }
    }
}

