/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;

public class CompositeTypeImpl
extends ComplexTypeImpl
implements CompositeType {
    private static final long serialVersionUID = -6935764237520164300L;
    protected final Map<String, TypeRef<Schema>> schemas = new HashMap<String, TypeRef<Schema>>();
    protected transient Map<String, Schema> prefix2schemas;

    public CompositeTypeImpl(CompositeType superType, String schema, String name, String[] schemas) {
        this(superType == null ? null : superType.getRef(), schema, name, schemas);
    }

    public CompositeTypeImpl(TypeRef<? extends CompositeType> superType, String schema, String name, String[] schemas) {
        super((TypeRef<? extends ComplexType>)superType, schema, name);
        CompositeType stype = (CompositeType)this.superType.get();
        if (stype != null) {
            for (String sname : stype.getSchemaNames()) {
                this.addSchema(sname);
            }
        }
        if (schemas != null) {
            for (String sname : schemas) {
                this.addSchema(sname);
            }
        }
    }

    @Override
    public final boolean hasSchemas() {
        return !this.schemas.isEmpty();
    }

    @Override
    public final void addSchema(String schema) {
        this.schemas.put(schema, new TypeRef("@schemas", schema));
    }

    @Override
    public final void addSchema(Schema schema) {
        this.schemas.put(schema.getName(), schema.getRef());
    }

    @Override
    public final Schema getSchema(String name) {
        TypeRef<Schema> proxy = this.schemas.get(name);
        if (proxy != null) {
            return proxy.get();
        }
        return null;
    }

    @Override
    public final Schema getSchemaByPrefix(String prefix) {
        if (this.prefix2schemas == null) {
            this.prefix2schemas = new HashMap<String, Schema>();
            for (Schema schema : this.getSchemas()) {
                this.prefix2schemas.put(schema.getNamespace().prefix, schema);
            }
        }
        return this.prefix2schemas.get(prefix);
    }

    @Override
    public final boolean hasSchema(String name) {
        return this.schemas.containsKey(name);
    }

    @Override
    public final String[] getSchemaNames() {
        return this.schemas.keySet().toArray(new String[this.schemas.size()]);
    }

    @Override
    public final Collection<Schema> getSchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (TypeRef<Schema> proxy : this.schemas.values()) {
            schemas.add(proxy.get());
        }
        return Collections.unmodifiableCollection(schemas);
    }

    @Override
    public final Field addField(QName name, TypeRef<? extends Type> type) {
        throw new UnsupportedOperationException("Cannot add fields to a composite type since it is a composition of other complex types");
    }

    @Override
    public final Field getField(String name) {
        Field field = (Field)this.fieldsCache.get(name);
        if (field == null) {
            for (TypeRef<Schema> schema : this.schemas.values()) {
                field = schema.get().getField(name);
                if (field == null) continue;
                this.fieldsCache.put(name, field);
                break;
            }
        }
        return field;
    }

    @Override
    public final Field getField(QName name) {
        Field field;
        block1: {
            String pname;
            block2: {
                pname = name.prefixedName;
                field = (Field)this.fieldsCache.get(pname);
                if (field != null) break block1;
                String prefix = name.prefix;
                if (prefix.length() <= 0) break block2;
                Schema schema = this.getSchemaByPrefix(prefix);
                if (schema == null || (field = schema.getField(name)) == null) break block1;
                this.fieldsCache.put(pname, field);
                break block1;
            }
            for (TypeRef<Schema> schema : this.schemas.values()) {
                field = schema.get().getField(name.localName);
                if (field == null) continue;
                this.fieldsCache.put(pname, field);
                break;
            }
        }
        return field;
    }

    @Override
    public final boolean hasField(QName name) {
        if (this.fieldsCache.containsKey(name.prefixedName)) {
            return true;
        }
        return this.getField(name) != null;
    }

    @Override
    public final Collection<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (TypeRef<Schema> schema : this.schemas.values()) {
            fields.addAll(schema.get().getFields());
        }
        return fields;
    }

    @Override
    public final boolean isComplexType() {
        return false;
    }

    @Override
    public final boolean isCompositeType() {
        return true;
    }

    @Override
    public final boolean validate(Object object) {
        return true;
    }

    @Override
    public TypeRef<? extends CompositeType> getRef() {
        return new TypeRef<CompositeTypeImpl>(this.schema, this.name, this);
    }
}

