/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyComparable {
    public static RubyModule createComparable(Ruby runtime) {
        RubyModule comparableModule = runtime.defineModule("Comparable");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyComparable.class);
        comparableModule.defineFastMethod("==", callbackFactory.getFastSingletonMethod("equal", RubyKernel.IRUBY_OBJECT));
        comparableModule.defineFastMethod(">", callbackFactory.getFastSingletonMethod("op_gt", RubyKernel.IRUBY_OBJECT));
        comparableModule.defineFastMethod(">=", callbackFactory.getFastSingletonMethod("op_ge", RubyKernel.IRUBY_OBJECT));
        comparableModule.defineFastMethod("<", callbackFactory.getFastSingletonMethod("op_lt", RubyKernel.IRUBY_OBJECT));
        comparableModule.defineFastMethod("<=", callbackFactory.getFastSingletonMethod("op_le", RubyKernel.IRUBY_OBJECT));
        comparableModule.defineFastMethod("between?", callbackFactory.getFastSingletonMethod("between_p", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        return comparableModule;
    }

    public static int cmpint(IRubyObject val, IRubyObject a, IRubyObject b) {
        RubyFixnum zero;
        if (val.isNil()) {
            RubyComparable.cmperr(a, b);
        }
        if (val instanceof RubyFixnum) {
            return RubyNumeric.fix2int((RubyFixnum)val);
        }
        if (val instanceof RubyBignum) {
            if (((RubyBignum)val).getValue().signum() == -1) {
                return 1;
            }
            return -1;
        }
        Ruby runtime = val.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        if (val.callMethod(tc, 24, ">", zero = RubyFixnum.one(runtime)).isTrue()) {
            return 1;
        }
        if (val.callMethod(tc, 3, "<", zero).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static void cmperr(IRubyObject recv, IRubyObject other) {
        IRubyObject target = other.isImmediate() || !other.isNil() && !other.isTrue() && other != recv.getRuntime().getFalse() ? other.inspect() : other.getType();
        throw recv.getRuntime().newArgumentError("comparison of " + recv.getType() + " with " + target + " failed");
    }

    public static IRubyObject equal(IRubyObject recv, IRubyObject other) {
        if (recv == other) {
            return recv.getRuntime().getTrue();
        }
        Ruby runtime = recv.getRuntime();
        IRubyObject result = null;
        try {
            result = recv.callMethod(runtime.getCurrentContext(), 27, "<=>", other);
        }
        catch (RaiseException e) {
            return recv.getRuntime().getFalse();
        }
        if (result.isNil()) {
            return result;
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(result, recv, other) == 0);
    }

    public static RubyBoolean op_gt(IRubyObject recv, IRubyObject other) {
        Ruby runtime = recv.getRuntime();
        IRubyObject result = recv.callMethod(runtime.getCurrentContext(), 27, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(result, recv, other) > 0);
    }

    public static RubyBoolean op_ge(IRubyObject recv, IRubyObject other) {
        Ruby runtime = recv.getRuntime();
        IRubyObject result = recv.callMethod(runtime.getCurrentContext(), 27, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(result, recv, other) >= 0);
    }

    public static RubyBoolean op_lt(IRubyObject recv, IRubyObject other) {
        Ruby runtime = recv.getRuntime();
        IRubyObject result = recv.callMethod(runtime.getCurrentContext(), 27, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(result, recv, other) < 0);
    }

    public static RubyBoolean op_le(IRubyObject recv, IRubyObject other) {
        Ruby runtime = recv.getRuntime();
        IRubyObject result = recv.callMethod(runtime.getCurrentContext(), 27, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(result, recv, other) <= 0);
    }

    public static RubyBoolean between_p(IRubyObject recv, IRubyObject first, IRubyObject second) {
        return recv.getRuntime().newBoolean(RubyComparable.op_lt(recv, first).isFalse() && RubyComparable.op_gt(recv, second).isFalse());
    }
}

