/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.AbstractBlobHolder;

public class SimpleBlobHolder
extends AbstractBlobHolder {
    protected List<Blob> blobs;
    protected Calendar creationDate;

    public SimpleBlobHolder() {
    }

    public SimpleBlobHolder(List<Blob> blobs) {
        this.init(blobs);
    }

    public SimpleBlobHolder(Blob blob) {
        this.blobs = new ArrayList<Blob>();
        this.blobs.add(blob);
        this.init(this.blobs);
    }

    protected void init(List<Blob> blobs) {
        this.blobs = blobs;
        this.creationDate = Calendar.getInstance();
    }

    @Override
    public Blob getBlob() throws ClientException {
        if (this.blobs == null || this.blobs.size() == 0) {
            return null;
        }
        return this.blobs.get(0);
    }

    @Override
    public List<Blob> getBlobs() throws ClientException {
        return this.blobs;
    }

    @Override
    protected String getBasePath() {
        return "";
    }

    @Override
    public Calendar getModificationDate() throws ClientException {
        return this.creationDate;
    }

    @Override
    public Serializable getProperty(String name) throws ClientException {
        return null;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return null;
    }
}

