/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation.assignability;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jboss.aop.advice.annotation.assignability.ArgumentContextualizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParamTypeAssignabilityAlgorithm {
    ParamTypeAssignabilityAlgorithm() {
    }

    public static <C, T> boolean isAssignable(ParameterizedType paramType, Type fromType, EqualityChecker<C, T> checker, C caller, T checkerToken) {
        Type[] arguments;
        Class fromRaw = null;
        ParameterizedType fromParamType = null;
        Class desiredType = (Class)paramType.getRawType();
        if (fromType instanceof Class) {
            fromRaw = (Class)fromType;
            if (!desiredType.isAssignableFrom(fromRaw)) {
                return false;
            }
            if (fromRaw.getTypeParameters().length > 0) {
                return true;
            }
        } else if (fromType instanceof ParameterizedType) {
            fromParamType = (ParameterizedType)fromType;
            fromRaw = (Class)fromParamType.getRawType();
            if (fromRaw == desiredType) {
                return checker.isSame(paramType.getActualTypeArguments(), fromParamType.getActualTypeArguments(), caller, checkerToken);
            }
            if (!desiredType.isAssignableFrom(fromRaw)) {
                return false;
            }
        } else {
            return false;
        }
        if ((arguments = ArgumentContextualizer.getContextualizedArguments(fromParamType, fromRaw, desiredType)) == null) {
            return true;
        }
        return checker.isSame(paramType.getActualTypeArguments(), arguments, caller, checkerToken);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class EqualityChecker<C, T> {
        EqualityChecker() {
        }

        protected boolean isSame(Type[] arguments, Type[] fromArguments, C caller, T token) {
            for (int i = 0; i < arguments.length; ++i) {
                if (this.isSame(arguments[i], fromArguments[i], caller, token)) continue;
                return false;
            }
            return true;
        }

        abstract boolean isSame(Type var1, Type var2, C var3, T var4);
    }
}

