/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.microcontainer;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.BasicKernelDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempBasicXMLDeployer
extends BasicKernelDeployer {
    private static final Logger log = Logger.getLogger(TempBasicXMLDeployer.class);
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    private Map<String, KernelDeployment> deploymentsByName = new ConcurrentHashMap<String, KernelDeployment>();

    public TempBasicXMLDeployer(Kernel kernel) {
        this(kernel, null);
    }

    public TempBasicXMLDeployer(Kernel kernel, ControllerMode mode) {
        super(kernel, mode);
    }

    public Collection<String> getDeploymentNames() {
        return this.deploymentsByName.keySet();
    }

    public void deploy(KernelDeployment deployment) throws Throwable {
        super.deploy(deployment);
        this.deploymentsByName.put(deployment.getName(), deployment);
    }

    public void undeploy(KernelDeployment deployment) {
        this.deploymentsByName.remove(deployment.getName());
        super.undeploy(deployment);
    }

    public void undeploy(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.undeploy(url.toString());
    }

    public void undeploy(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        KernelDeployment deployment = this.deploymentsByName.remove(name);
        if (deployment == null) {
            throw new IllegalStateException("Unknown deployment " + name);
        }
        this.undeploy(deployment);
    }

    public KernelDeployment deploy(URL url) throws Throwable {
        long now;
        boolean trace = log.isTraceEnabled();
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (trace) {
            log.trace((Object)("Parsing " + url));
        }
        long start = System.currentTimeMillis();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), resolver);
        if (deployment == null) {
            throw new RuntimeException("The xml " + url + " is not well formed!");
        }
        deployment.setName(url.toString());
        if (trace) {
            now = System.currentTimeMillis();
            log.trace((Object)("Parsing " + url + " took " + (now - start) + " milliseconds"));
        }
        this.deploy(deployment);
        if (trace) {
            now = System.currentTimeMillis();
            log.trace((Object)("Deploying " + url + " took " + (now - start) + " milliseconds"));
        }
        return deployment;
    }

    public KernelDeployment deploy(String deploymentName, InputStream stream) throws Throwable {
        Unmarshaller unmarshaller;
        KernelDeployment deployment;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Parsing " + deploymentName));
        }
        if ((deployment = (KernelDeployment)(unmarshaller = factory.newUnmarshaller()).unmarshal(stream, resolver)) == null) {
            throw new RuntimeException("The deployment " + deploymentName + " is not well formed!");
        }
        deployment.setName(deploymentName);
        this.deploy(deployment);
        return deployment;
    }

    public Map<String, KernelDeployment> getDeployments() {
        return Collections.unmodifiableMap(this.deploymentsByName);
    }
}

