/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.FutureThread;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyThread
extends RubyObject {
    private ThreadLike threadImpl;
    private RubyFixnum priority;
    private Map threadLocalVariables = new HashMap();
    private boolean abortOnException;
    private IRubyObject finalResult;
    private RaiseException exitingException;
    private IRubyObject receivedException;
    private RubyThreadGroup threadGroup;
    private ThreadService threadService;
    private volatile boolean isStopped = false;
    public Object stopLock = new Object();
    private volatile boolean killed = false;
    public Object killLock = new Object();
    public final ReentrantLock lock = new ReentrantLock();
    private static boolean USE_POOLING;
    private static final boolean DEBUG = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static RubyClass createThreadClass(Ruby runtime) {
        RubyClass threadClass = runtime.defineClass("Thread", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyThread.class);
        threadClass.defineFastMethod("[]", callbackFactory.getFastMethod("aref", RubyKernel.IRUBY_OBJECT));
        threadClass.defineFastMethod("[]=", callbackFactory.getFastMethod("aset", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        threadClass.defineFastMethod("abort_on_exception", callbackFactory.getFastMethod("abort_on_exception"));
        threadClass.defineFastMethod("abort_on_exception=", callbackFactory.getFastMethod("abort_on_exception_set", RubyKernel.IRUBY_OBJECT));
        threadClass.defineFastMethod("alive?", callbackFactory.getFastMethod("is_alive"));
        threadClass.defineFastMethod("group", callbackFactory.getFastMethod("group"));
        threadClass.defineFastMethod("join", callbackFactory.getFastOptMethod("join"));
        threadClass.defineFastMethod("value", callbackFactory.getFastMethod("value"));
        threadClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        threadClass.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        threadClass.defineFastMethod("key?", callbackFactory.getFastMethod("has_key", RubyKernel.IRUBY_OBJECT));
        threadClass.defineFastMethod("keys", callbackFactory.getFastMethod("keys"));
        threadClass.defineFastMethod("priority", callbackFactory.getFastMethod("priority"));
        threadClass.defineFastMethod("priority=", callbackFactory.getFastMethod("priority_set", RubyKernel.IRUBY_OBJECT));
        threadClass.defineMethod("raise", callbackFactory.getOptMethod("raise"));
        threadClass.defineFastMethod("run", callbackFactory.getFastMethod("run"));
        threadClass.defineFastMethod("status", callbackFactory.getFastMethod("status"));
        threadClass.defineFastMethod("stop?", callbackFactory.getFastMethod("isStopped"));
        threadClass.defineFastMethod("wakeup", callbackFactory.getFastMethod("wakeup"));
        threadClass.defineFastMethod("kill", callbackFactory.getFastMethod("kill"));
        threadClass.defineFastMethod("exit", callbackFactory.getFastMethod("exit"));
        threadClass.getMetaClass().defineFastMethod("current", callbackFactory.getFastSingletonMethod("current"));
        threadClass.getMetaClass().defineMethod("fork", callbackFactory.getOptSingletonMethod("newInstance"));
        threadClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        threadClass.getMetaClass().defineFastMethod("list", callbackFactory.getFastSingletonMethod("list"));
        threadClass.getMetaClass().defineFastMethod("pass", callbackFactory.getFastSingletonMethod("pass"));
        threadClass.getMetaClass().defineMethod("start", callbackFactory.getOptSingletonMethod("start"));
        threadClass.getMetaClass().defineFastMethod("critical=", callbackFactory.getFastSingletonMethod("critical_set", RubyBoolean.class));
        threadClass.getMetaClass().defineFastMethod("critical", callbackFactory.getFastSingletonMethod("critical"));
        threadClass.getMetaClass().defineFastMethod("stop", callbackFactory.getFastSingletonMethod("stop"));
        threadClass.getMetaClass().defineMethod("kill", callbackFactory.getSingletonMethod("s_kill", RubyThread.class));
        threadClass.getMetaClass().defineMethod("exit", callbackFactory.getSingletonMethod("s_exit"));
        threadClass.getMetaClass().defineFastMethod("abort_on_exception", callbackFactory.getFastSingletonMethod("abort_on_exception"));
        threadClass.getMetaClass().defineFastMethod("abort_on_exception=", callbackFactory.getFastSingletonMethod("abort_on_exception_set", RubyKernel.IRUBY_OBJECT));
        RubyThread rubyThread = new RubyThread(runtime, threadClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        runtime.getThreadService().setMainThread(rubyThread);
        threadClass.getMetaClass().defineFastMethod("main", callbackFactory.getFastSingletonMethod("main"));
        threadClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return threadClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyThread.startThread(recv, args, true, block);
    }

    public static RubyThread start(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyThread.startThread(recv, args, false, block);
    }

    public static RubyThread adopt(IRubyObject recv, Thread t) {
        return RubyThread.adoptThread(recv, t, Block.NULL_BLOCK);
    }

    private static RubyThread adoptThread(IRubyObject recv, Thread t, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime, (RubyClass)recv);
        rubyThread.threadImpl = new NativeThread(rubyThread, t);
        runtime.getThreadService().registerNewThread(rubyThread);
        runtime.getCurrentContext().preAdoptThread();
        rubyThread.threadImpl = USE_POOLING ? new FutureThread(rubyThread, new RubyRunnable(rubyThread, IRubyObject.NULL_ARRAY, block)) : new NativeThread(rubyThread, new RubyNativeThread(rubyThread, IRubyObject.NULL_ARRAY, block));
        rubyThread.threadImpl.start();
        return rubyThread;
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (!block.isGiven()) {
            throw this.getRuntime().newThreadError("must be called with a block");
        }
        this.threadImpl = USE_POOLING ? new FutureThread(this, new RubyRunnable(this, args, block)) : new NativeThread(this, new RubyNativeThread(this, args, block));
        this.threadImpl.start();
        return this;
    }

    private static RubyThread startThread(IRubyObject recv, IRubyObject[] args, boolean callInit, Block block) {
        RubyThread rubyThread = new RubyThread(recv.getRuntime(), (RubyClass)recv);
        if (callInit) {
            rubyThread.callInit(args, block);
        } else {
            rubyThread.initialize(args, block);
        }
        return rubyThread;
    }

    private void ensureCurrent() {
        if (this != this.getRuntime().getCurrentContext().getThread()) {
            throw new RuntimeException("internal thread method called from another thread");
        }
    }

    private void ensureNotCurrent() {
        if (this == this.getRuntime().getCurrentContext().getThread()) {
            throw new RuntimeException("internal thread method called from another thread");
        }
    }

    public void cleanTerminate(IRubyObject result) {
        this.finalResult = result;
        this.isStopped = true;
    }

    public void pollThreadEvents() {
        this.threadService.waitForCritical();
        this.ensureCurrent();
        if (this.killed) {
            throw new ThreadKill();
        }
        if (this.receivedException != null) {
            IRubyObject raiseException = this.receivedException;
            this.receivedException = null;
            RubyModule kernelModule = this.getRuntime().getModule("Kernel");
            kernelModule.callMethod(this.getRuntime().getCurrentContext(), "raise", raiseException);
        }
    }

    protected RubyThread(Ruby runtime, RubyClass type) {
        super(runtime, type);
        this.threadService = runtime.getThreadService();
        RubyThreadGroup defaultThreadGroup = (RubyThreadGroup)runtime.getClass("ThreadGroup").getConstant("Default");
        defaultThreadGroup.add(this, Block.NULL_BLOCK);
        this.finalResult = runtime.getNil();
    }

    public static RubyBoolean abort_on_exception(IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        return runtime.isGlobalAbortOnExceptionEnabled() ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static IRubyObject abort_on_exception_set(IRubyObject recv, IRubyObject value) {
        recv.getRuntime().setGlobalAbortOnExceptionEnabled(value.isTrue());
        return value;
    }

    public static RubyThread current(IRubyObject recv) {
        return recv.getRuntime().getCurrentContext().getThread();
    }

    public static RubyThread main(IRubyObject recv) {
        return recv.getRuntime().getThreadService().getMainThread();
    }

    public static IRubyObject pass(IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        ThreadService ts = runtime.getThreadService();
        boolean critical = ts.getCritical();
        ts.setCritical(false);
        Thread.yield();
        ts.setCritical(critical);
        return recv.getRuntime().getNil();
    }

    public static RubyArray list(IRubyObject recv) {
        IRubyObject[] activeThreads = recv.getRuntime().getThreadService().getActiveRubyThreads();
        return recv.getRuntime().newArrayNoCopy(activeThreads);
    }

    private IRubyObject getSymbolKey(IRubyObject originalKey) {
        if (originalKey instanceof RubySymbol) {
            return originalKey;
        }
        if (originalKey instanceof RubyString) {
            return RubySymbol.newSymbol(this.getRuntime(), originalKey.asSymbol());
        }
        if (originalKey instanceof RubyFixnum) {
            this.getRuntime().getWarnings().warn("Do not use Fixnums as Symbols");
            throw this.getRuntime().newArgumentError(originalKey + " is not a symbol");
        }
        throw this.getRuntime().newArgumentError(originalKey + " is not a symbol");
    }

    public IRubyObject aref(IRubyObject key) {
        if (!this.threadLocalVariables.containsKey(key = this.getSymbolKey(key))) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.threadLocalVariables.get(key);
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        key = this.getSymbolKey(key);
        this.threadLocalVariables.put(key, value);
        return value;
    }

    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    public RubyBoolean is_alive() {
        return this.threadImpl.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyThread join(IRubyObject[] args) {
        block12: {
            long timeoutMillis = 0L;
            if (args.length > 0) {
                if (args.length > 1) {
                    throw this.getRuntime().newArgumentError(args.length, 1);
                }
                timeoutMillis = (long)(1000.0 * args[0].convertToFloat().getValue());
                if (timeoutMillis <= 0L) {
                    return null;
                }
            }
            if (this.isCurrent()) {
                throw this.getRuntime().newThreadError("thread tried to join itself");
            }
            try {
                if (this.threadService.getCritical()) {
                    this.threadImpl.interrupt();
                }
                this.threadImpl.join(timeoutMillis);
            }
            catch (InterruptedException iExcptn) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)iExcptn);
                }
            }
            catch (TimeoutException iExcptn) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)iExcptn);
                }
            }
            catch (ExecutionException iExcptn) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError((Object)iExcptn);
            }
        }
        if (this.exitingException != null) {
            throw this.exitingException;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject value() {
        this.join(new IRubyObject[0]);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    public IRubyObject inspect() {
        StringBuffer part = new StringBuffer();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":0x");
        part.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.threadImpl.isAlive()) {
            if (this.isStopped) {
                part.append(this.getRuntime().newString(" sleep"));
            } else if (this.killed) {
                part.append(this.getRuntime().newString(" aborting"));
            } else {
                part.append(this.getRuntime().newString(" run"));
            }
        } else {
            part.append(" dead");
        }
        part.append(">");
        return this.getRuntime().newString(part.toString());
    }

    public RubyBoolean has_key(IRubyObject key) {
        key = this.getSymbolKey(key);
        return this.getRuntime().newBoolean(this.threadLocalVariables.containsKey(key));
    }

    public RubyArray keys() {
        IRubyObject[] keys = new IRubyObject[this.threadLocalVariables.size()];
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.threadLocalVariables.keySet().toArray(keys));
    }

    public static IRubyObject critical_set(IRubyObject receiver, RubyBoolean value) {
        receiver.getRuntime().getThreadService().setCritical(value.isTrue());
        return value;
    }

    public static IRubyObject critical(IRubyObject receiver) {
        return receiver.getRuntime().newBoolean(receiver.getRuntime().getThreadService().getCritical());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject stop(IRubyObject receiver) {
        Object stopLock;
        RubyThread rubyThread = receiver.getRuntime().getThreadService().getCurrentContext().getThread();
        Object object = stopLock = rubyThread.stopLock;
        synchronized (object) {
            try {
                rubyThread.isStopped = true;
                receiver.getRuntime().getThreadService().setCritical(false);
                stopLock.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            rubyThread.isStopped = false;
        }
        return receiver.getRuntime().getNil();
    }

    public static IRubyObject s_kill(IRubyObject receiver, RubyThread rubyThread, Block block) {
        return rubyThread.kill();
    }

    public static IRubyObject s_exit(IRubyObject receiver, Block block) {
        RubyThread rubyThread = receiver.getRuntime().getThreadService().getCurrentContext().getThread();
        rubyThread.killed = true;
        receiver.getRuntime().getThreadService().setCritical(false);
        throw new ThreadKill();
    }

    public RubyBoolean isStopped() {
        return this.getRuntime().newBoolean(this.isStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyThread wakeup() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopLock.notifyAll();
        }
        return this;
    }

    public RubyFixnum priority() {
        return this.priority;
    }

    public IRubyObject priority_set(IRubyObject priority) {
        int iPriority = RubyNumeric.fix2int(priority);
        if (iPriority < 1) {
            iPriority = 1;
        } else if (iPriority > 10) {
            iPriority = 10;
        }
        this.priority = RubyFixnum.newFixnum(this.getRuntime(), iPriority);
        if (this.threadImpl.isAlive()) {
            this.threadImpl.setPriority(iPriority);
        }
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject raise(IRubyObject[] args, Block block) {
        this.ensureNotCurrent();
        Ruby runtime = this.getRuntime();
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        try {
            while (!currentThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!currentThread.lock.isHeldByCurrentThread()) continue;
                currentThread.lock.unlock();
            }
            currentThread.pollThreadEvents();
            this.receivedException = this.prepareRaiseException(runtime, args, block);
            this.threadImpl.interrupt();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (currentThread.lock.isHeldByCurrentThread()) {
                currentThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
            throw throwable;
        }
        if (currentThread.lock.isHeldByCurrentThread()) {
            currentThread.lock.unlock();
        }
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
        return this;
    }

    private IRubyObject prepareRaiseException(Ruby runtime, IRubyObject[] args, Block block) {
        IRubyObject exception;
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 3);
        if (args.length == 0) {
            IRubyObject lastException = runtime.getGlobalVariables().get("$!");
            if (lastException.isNil()) {
                return new RaiseException(runtime, runtime.getClass("RuntimeError"), "", false).getException();
            }
            return lastException;
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args.length == 1) {
            if (args[0] instanceof RubyString) {
                return runtime.getClass("RuntimeError").newInstance(args, block);
            }
            if (!args[0].respondsTo("exception")) {
                return runtime.newTypeError("exception class/object expected").getException();
            }
            exception = args[0].callMethod(context, "exception");
        } else {
            if (!args[0].respondsTo("exception")) {
                return runtime.newTypeError("exception class/object expected").getException();
            }
            exception = args[0].callMethod(context, "exception", args[1]);
        }
        if (!exception.isKindOf(runtime.getClass("Exception"))) {
            return runtime.newTypeError("exception object expected").getException();
        }
        if (args.length == 3) {
            ((RubyException)exception).set_backtrace(args[2]);
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject run() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.isStopped) {
                this.isStopped = false;
                this.stopLock.notifyAll();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long millis) throws InterruptedException {
        this.ensureCurrent();
        Object object = this.stopLock;
        synchronized (object) {
            try {
                this.isStopped = true;
                this.stopLock.wait(millis);
            }
            finally {
                this.isStopped = false;
                this.pollThreadEvents();
            }
        }
    }

    public IRubyObject status() {
        if (this.threadImpl.isAlive()) {
            if (this.isStopped) {
                return this.getRuntime().newString("sleep");
            }
            if (this.killed) {
                return this.getRuntime().newString("aborting");
            }
            return this.getRuntime().newString("run");
        }
        if (this.exitingException != null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject kill() {
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        try {
            while (!currentThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!currentThread.lock.isHeldByCurrentThread()) continue;
                currentThread.lock.unlock();
            }
            currentThread.pollThreadEvents();
            this.killed = true;
            this.threadImpl.interrupt();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (currentThread.lock.isHeldByCurrentThread()) {
                currentThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
            throw throwable;
        }
        if (currentThread.lock.isHeldByCurrentThread()) {
            currentThread.lock.unlock();
        }
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
        try {
            this.threadImpl.join();
        }
        catch (InterruptedException ie) {
            currentThread.pollThreadEvents();
        }
        catch (ExecutionException ie) {
            currentThread.pollThreadEvents();
        }
        return this;
    }

    public IRubyObject exit() {
        return this.kill();
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException exception) {
        if (!$assertionsDisabled && !this.isCurrent()) {
            throw new AssertionError();
        }
        RubyException rubyException = exception.getException();
        Ruby runtime = rubyException.getRuntime();
        if (rubyException.getMetaClass() == runtime.getClass("SystemExit")) {
            this.threadService.getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
        } else {
            if (this.abortOnException(runtime)) {
                RubySystemExit systemExit = RubySystemExit.newInstance(runtime, 1);
                systemExit.message = rubyException.message;
                this.threadService.getMainThread().raise(new IRubyObject[]{systemExit}, Block.NULL_BLOCK);
                return;
            }
            if (runtime.getDebug().isTrue()) {
                runtime.printError(exception.getException());
            }
        }
        this.exitingException = exception;
    }

    private boolean abortOnException(Ruby runtime) {
        return runtime.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver) {
        return receiver.getRuntime().getThreadService().getMainThread();
    }

    static {
        $assertionsDisabled = !RubyThread.class.desiredAssertionStatus();
        USE_POOLING = Ruby.isSecurityRestricted() ? false : Boolean.getBoolean("jruby.thread.pooling");
    }
}

