/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.runtime.load.Library;

public class LateLoadingLibrary
implements Library {
    private String libraryName;
    private String className;
    private ClassLoader classLoader;

    public LateLoadingLibrary(String libraryName, String className, ClassLoader classLoader) {
        this.libraryName = libraryName;
        this.className = className;
        this.classLoader = classLoader;
    }

    public void load(Ruby runtime) throws IOException {
        try {
            Class<?> libraryClass = this.classLoader.loadClass(this.className);
            Library library = (Library)libraryClass.newInstance();
            library.load(runtime);
        }
        catch (Throwable e) {
            throw runtime.newLoadError("library `" + this.libraryName + "' could not be loaded: " + e);
        }
    }
}

