/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jboss.util.collection.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringClassLoader
extends ClassLoader {
    private String[] packages;
    private String[] paths;
    private String[] urls;

    public FilteringClassLoader(ClassLoader parent, String[] packages) {
        super(parent);
        if (packages == null) {
            throw new IllegalArgumentException("Null packages");
        }
        this.packages = packages;
        this.paths = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            this.paths[i] = packages[i].replace('.', '/');
        }
        try {
            Enumeration<URL> enumeration = super.getResources("");
            ArrayList<URL> rootURLs = new ArrayList<URL>();
            while (enumeration.hasMoreElements()) {
                rootURLs.add(enumeration.nextElement());
            }
            this.urls = new String[this.paths.length * rootURLs.size()];
            int i = 0;
            for (String path : this.paths) {
                for (URL rootURL : rootURLs) {
                    this.urls[i++] = new URL(rootURL, path).toString();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error determining classloader urls", e);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String pkg : this.packages) {
            if (!name.startsWith(pkg)) continue;
            throw new ClassNotFoundException("Class not found (filtered): " + name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        for (String path : this.paths) {
            if (!name.startsWith(path)) continue;
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> unfiltered = super.getResources(name);
        ArrayList<URL> filtered = new ArrayList<URL>();
        while (unfiltered.hasMoreElements()) {
            URL next = unfiltered.nextElement();
            boolean ignore = false;
            for (String url : this.urls) {
                if (!next.toString().startsWith(url)) continue;
                ignore = true;
            }
            if (ignore) continue;
            filtered.add(next);
        }
        return Iterators.toEnumeration(filtered.iterator());
    }
}

