/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.scripting;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.nuxeo.runtime.scripting.ScriptingComponent;
import org.nuxeo.runtime.scripting.ScriptingServer;

public class ScriptingServerImpl
implements ScriptingServer {
    private final ScriptingComponent comp;

    public ScriptingServerImpl(ScriptingComponent comp) {
        this.comp = comp;
    }

    @Override
    public Object[] eval(String name, String script, Map<String, Object> context) throws Exception {
        ScriptEngine engine = this.comp.getEngineByFileName(name);
        if (engine == null) {
            throw new Exception("No suitable script engine found for " + name);
        }
        engine.put("javax.script.filename", name);
        ScriptContext ctx = engine.getContext();
        if (context != null) {
            ctx.getBindings(100).putAll((Map<? extends String, ? extends Object>)context);
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        ctx.setWriter(out);
        ctx.setErrorWriter(out);
        Object[] response = new Object[2];
        response[1] = engine.eval(script, ctx);
        out.flush();
        response[0] = writer.getBuffer().toString();
        return response;
    }

    @Override
    public Object[] invoke(String name, String script, Map<String, Object> context, String method, Object[] args) throws Exception {
        ScriptContext ctx;
        ScriptEngine engine = this.comp.getEngineByFileName(name);
        if (engine == null) {
            throw new Exception("No suitable script engine found for " + name);
        }
        engine.put("javax.script.filename", name);
        if (context != null) {
            ctx = new SimpleScriptContext();
            ctx.getBindings(100).putAll((Map<? extends String, ? extends Object>)context);
        } else {
            ctx = engine.getContext();
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        ctx.setWriter(out);
        ctx.setErrorWriter(out);
        engine.eval(script, ctx);
        Object[] response = new Object[2];
        if (!(engine instanceof Invocable)) {
            throw new Exception("The script engine does not support invoking: " + engine.getFactory().getEngineName());
        }
        response[1] = ((Invocable)((Object)engine)).invokeFunction(method, args);
        out.flush();
        response[0] = writer.getBuffer().toString();
        return response;
    }
}

