/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import junit.framework.TestCase;

public class OpenMBeanInfoSupportTestCase
extends TestCase {
    public OpenMBeanInfoSupportTestCase(String s) {
        super(s);
    }

    public void testOpenMBeanInfoSupport() throws Exception {
        OpenMBeanInfoSupport info = new OpenMBeanInfoSupport("name", "description", null, null, null, null);
        OpenMBeanInfoSupportTestCase.assertEquals((String)"name", (String)info.getClassName());
        OpenMBeanInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanInfoSupportTestCase.assertEquals((int)0, (int)info.getAttributes().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)0, (int)info.getConstructors().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)0, (int)info.getNotifications().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)0, (int)info.getOperations().length);
        info = new OpenMBeanInfoSupport("name", "description", new OpenMBeanAttributeInfoSupport[0], new OpenMBeanConstructorInfoSupport[0], new OpenMBeanOperationInfoSupport[0], new MBeanNotificationInfo[0]);
        OpenMBeanInfoSupportTestCase.assertEquals((String)"name", (String)info.getClassName());
        OpenMBeanInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanInfoSupportTestCase.assertEquals((int)0, (int)info.getAttributes().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)0, (int)info.getConstructors().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)0, (int)info.getNotifications().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)0, (int)info.getOperations().length);
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[]{new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false)};
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[]{new OpenMBeanConstructorInfoSupport("name", "description", parms)};
        OpenMBeanOperationInfo[] operations = new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        info = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertEquals((String)"name", (String)info.getClassName());
        OpenMBeanInfoSupportTestCase.assertEquals((String)"description", (String)info.getDescription());
        OpenMBeanInfoSupportTestCase.assertEquals((int)1, (int)info.getAttributes().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)1, (int)info.getConstructors().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)1, (int)info.getNotifications().length);
        OpenMBeanInfoSupportTestCase.assertEquals((int)1, (int)info.getOperations().length);
    }

    public void testEquals() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[]{new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false)};
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[]{new OpenMBeanConstructorInfoSupport("name", "description", parms)};
        OpenMBeanOperationInfo[] operations = new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        OpenMBeanInfoSupport info = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Null is not equal to any instance", (!info.equals(null) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instance is only equal another OpenMBeanInfo instance", (!info.equals(new Object()) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instance should equal itself", (boolean)info.equals(info));
        OpenMBeanInfoSupport info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with same values should be equal", (boolean)info.equals(info2));
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with same values should be equal", (boolean)info2.equals(info));
        info2 = new OpenMBeanInfoSupport("name2", "description", attributes, constructors, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different class names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different class names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanInfoSupport("name", "description2", attributes, constructors, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different descriptions are equal", (boolean)info.equals(info2));
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different descriptions are equal", (boolean)info2.equals(info));
        OpenMBeanAttributeInfo[] attributes2 = new OpenMBeanAttributeInfoSupport[]{new OpenMBeanAttributeInfoSupport("name2", "description", SimpleType.STRING, true, true, false)};
        info2 = new OpenMBeanInfoSupport("name", "description", attributes2, constructors, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different attributes are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different attributes are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        attributes2 = new OpenMBeanAttributeInfoSupport[]{new OpenMBeanAttributeInfoSupport("name2", "description", SimpleType.STRING, true, true, false), new OpenMBeanAttributeInfoSupport("name3", "description", SimpleType.STRING, true, true, false)};
        info2 = new OpenMBeanInfoSupport("name", "description", attributes2, constructors, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different numbers of attributes are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different numbers of attributes are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanInfoSupport("name", "description", null, constructors, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with and without attributes are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with and without attributes are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        OpenMBeanConstructorInfo[] constructors2 = new OpenMBeanConstructorInfoSupport[]{new OpenMBeanConstructorInfoSupport("name2", "description", parms)};
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors2, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different constructors are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different constructors are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        constructors2 = new OpenMBeanConstructorInfoSupport[]{new OpenMBeanConstructorInfoSupport("name2", "description", parms), new OpenMBeanConstructorInfoSupport("name3", "description", parms)};
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors2, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different numbers of constructors are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different numbers of constructors are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, null, operations, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with and without constructors are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with and without constructors are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        OpenMBeanOperationInfo[] operations2 = new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("name2", "description", parms, SimpleType.STRING, 2)};
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations2, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different operations are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different operations are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        operations2 = new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("name2", "description", parms, SimpleType.STRING, 2), new OpenMBeanOperationInfoSupport("name3", "description", parms, SimpleType.STRING, 2)};
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations2, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different numbers of operations are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different numbers of operations are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors, null, notifications);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with and without operations are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with and without operations are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        MBeanNotificationInfo[] notifications2 = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type", "type"}, "name2", "description")};
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations, notifications2);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different notifications are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different notifications are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        notifications2 = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type", "type"}, "name2", "description"), new MBeanNotificationInfo(new String[]{"type", "type"}, "name3", "description")};
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations, notifications2);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different numbers of notifications are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with different numbers of notifications are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations, null);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with and without notifications are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"Instances with and without notifications are not equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[]{new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false)};
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[]{new OpenMBeanConstructorInfoSupport("name", "description", parms)};
        OpenMBeanOperationInfo[] operations = new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        OpenMBeanInfoSupport info = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations, notifications);
        int myHash = "name".hashCode() + new HashSet<OpenMBeanAttributeInfo>(Arrays.asList(attributes)).hashCode() + new HashSet<OpenMBeanConstructorInfo>(Arrays.asList(constructors)).hashCode() + new HashSet<OpenMBeanOperationInfo>(Arrays.asList(operations)).hashCode() + new HashSet<MBeanNotificationInfo>(Arrays.asList(notifications)).hashCode();
        OpenMBeanInfoSupportTestCase.assertEquals((int)myHash, (int)info.hashCode());
    }

    public void testToString() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[]{new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false)};
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[]{new OpenMBeanConstructorInfoSupport("name", "description", parms)};
        OpenMBeanOperationInfo[] operations = new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        OpenMBeanInfoSupport info = new OpenMBeanInfoSupport("NAME", "DESCRIPTION", attributes, constructors, operations, notifications);
        String toString = info.toString();
        OpenMBeanInfoSupportTestCase.assertTrue((String)"info.toString() should contain the name", (toString.indexOf("NAME") != -1 ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"info.toString() should contain the attributes", (toString.indexOf(Arrays.asList(attributes).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"info.toString() should contain the constructors", (toString.indexOf(Arrays.asList(constructors).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"info.toString() should contain the operations", (toString.indexOf(Arrays.asList(operations).toString()) != -1 ? 1 : 0) != 0);
        OpenMBeanInfoSupportTestCase.assertTrue((String)"info.toString() should contain the notifications", (toString.indexOf(Arrays.asList(notifications).toString()) != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        OpenMBeanParameterInfo[] parms = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("name", "description", SimpleType.STRING)};
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[]{new OpenMBeanAttributeInfoSupport("name", "description", SimpleType.STRING, true, true, false)};
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[]{new OpenMBeanConstructorInfoSupport("name", "description", parms)};
        OpenMBeanOperationInfo[] operations = new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("name", "description", parms, SimpleType.STRING, 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        OpenMBeanInfoSupport info = new OpenMBeanInfoSupport("name", "description", attributes, constructors, operations, notifications);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        OpenMBeanInfoSupport result = (OpenMBeanInfoSupport)ois.readObject();
        OpenMBeanInfoSupportTestCase.assertEquals((String)info.getClassName(), (String)result.getClassName());
        OpenMBeanInfoSupportTestCase.assertEquals(Arrays.asList(info.getAttributes()), Arrays.asList(result.getAttributes()));
        OpenMBeanInfoSupportTestCase.assertEquals(Arrays.asList(info.getConstructors()), Arrays.asList(result.getConstructors()));
        OpenMBeanInfoSupportTestCase.assertEquals(Arrays.asList(info.getOperations()), Arrays.asList(result.getOperations()));
        MBeanNotificationInfo origNotification = info.getNotifications()[0];
        MBeanNotificationInfo resultNotification = result.getNotifications()[0];
        OpenMBeanInfoSupportTestCase.assertEquals((String)origNotification.getName(), (String)resultNotification.getName());
        OpenMBeanInfoSupportTestCase.assertEquals((String)origNotification.getDescription(), (String)resultNotification.getDescription());
        OpenMBeanInfoSupportTestCase.assertEquals(Arrays.asList(origNotification.getNotifTypes()), Arrays.asList(resultNotification.getNotifTypes()));
    }

    public void testErrors() throws Exception {
        Object[] infos;
        boolean caught = false;
        try {
            infos = new MyOpenMBeanAttributeInfoSupport[]{new MyOpenMBeanAttributeInfoSupport()};
            new OpenMBeanInfoSupport("className", "description", (OpenMBeanAttributeInfo[])infos, null, null, null);
        }
        catch (ArrayStoreException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanInfoSupportTestCase.fail((String)"Expected ArrayStoreException for attributes not MBeanAttributeInfo");
        }
        caught = false;
        try {
            infos = new MyOpenMBeanConstructorInfoSupport[]{new MyOpenMBeanConstructorInfoSupport()};
            new OpenMBeanInfoSupport("className", "description", null, (OpenMBeanConstructorInfo[])infos, null, null);
        }
        catch (ArrayStoreException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanInfoSupportTestCase.fail((String)"Expected ArrayStoreException for attributes not MBeanConstructorInfo");
        }
        caught = false;
        try {
            infos = new MyOpenMBeanOperationInfoSupport[]{new MyOpenMBeanOperationInfoSupport()};
            new OpenMBeanInfoSupport("className", "description", null, null, (OpenMBeanOperationInfo[])infos, null);
        }
        catch (ArrayStoreException e) {
            caught = true;
        }
        if (!caught) {
            OpenMBeanInfoSupportTestCase.fail((String)"Expected ArrayStoreException for attributes not MBeanOperationInfo");
        }
    }

    public static class MyOpenMBeanOperationInfoSupport
    implements OpenMBeanOperationInfo {
        public boolean equals(Object o) {
            return false;
        }

        public String getDescription() {
            return null;
        }

        public int getImpact() {
            return 0;
        }

        public String getName() {
            return null;
        }

        public OpenType getReturnOpenType() {
            return null;
        }

        public String getReturnType() {
            return null;
        }

        public MBeanParameterInfo[] getSignature() {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return null;
        }
    }

    public static class MyOpenMBeanConstructorInfoSupport
    implements OpenMBeanConstructorInfo {
        public boolean equals(Object o) {
            return false;
        }

        public String getDescription() {
            return null;
        }

        public String getName() {
            return null;
        }

        public MBeanParameterInfo[] getSignature() {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return null;
        }
    }

    public static class MyOpenMBeanAttributeInfoSupport
    extends MyOpenMBeanParameterInfo
    implements OpenMBeanAttributeInfo {
        public boolean isIs() {
            return false;
        }

        public boolean isReadable() {
            return false;
        }

        public boolean isWritable() {
            return false;
        }
    }

    public static class MyOpenMBeanParameterInfo
    implements OpenMBeanParameterInfo {
        public boolean equals(Object o) {
            return false;
        }

        public Object getDefaultValue() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public Set getLegalValues() {
            return null;
        }

        public Comparable getMaxValue() {
            return null;
        }

        public Comparable getMinValue() {
            return null;
        }

        public String getName() {
            return null;
        }

        public OpenType getOpenType() {
            return null;
        }

        public boolean hasDefaultValue() {
            return false;
        }

        public boolean hasLegalValues() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean hasMaxValue() {
            return false;
        }

        public boolean hasMinValue() {
            return false;
        }

        public boolean isValue(Object o) {
            return false;
        }

        public String toString() {
            return null;
        }
    }
}

