/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.scanner.DeploymentScanner;
import org.jboss.deployment.scanner.DeploymentScannerMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanProxyInstance;
import org.jboss.system.MissingAttributeException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.NullArgumentException;

public abstract class AbstractDeploymentScanner
extends ServiceMBeanSupport
implements DeploymentScanner,
DeploymentScannerMBean {
    protected long scanPeriod = 5000L;
    protected boolean scanEnabled = true;
    protected long stopTimeOut = 60000L;
    protected Deployer deployer;
    protected MainDeployerMBean mainDeployer;
    protected ScannerThread scannerThread;
    private Thread shutdownHook;

    public void setDeployer(ObjectName deployerName) {
        if (deployerName == null) {
            throw new NullArgumentException("deployerName");
        }
        this.deployer = (Deployer)MBeanProxyExt.create(Deployer.class, (ObjectName)deployerName, (MBeanServer)this.server);
    }

    public ObjectName getDeployer() {
        return ((MBeanProxyInstance)this.deployer).getMBeanProxyObjectName();
    }

    public void setScanPeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("ScanPeriod must be >= 0; have: " + period);
        }
        this.scanPeriod = period;
    }

    public long getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanEnabled(boolean flag) {
        this.scanEnabled = flag;
    }

    public boolean isScanEnabled() {
        return this.scanEnabled;
    }

    public long getStopTimeOut() {
        return this.stopTimeOut;
    }

    public void setStopTimeOut(long stopTimeOut) {
        this.stopTimeOut = stopTimeOut;
    }

    public abstract void scan() throws Exception;

    protected void createService() throws Exception {
        if (this.deployer == null) {
            throw new MissingAttributeException("Deployer");
        }
        this.mainDeployer = (MainDeployerMBean)MBeanProxyExt.create(MainDeployerMBean.class, (ObjectName)MainDeployerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.scannerThread = new ScannerThread(false);
        this.scannerThread.setDaemon(true);
        this.scannerThread.start();
        this.log.debug((Object)"Scanner thread started");
        final ScannerThread _scannerThread = this.scannerThread;
        this.shutdownHook = new Thread("DeploymentScanner Shutdown Hook"){
            ScannerThread thread;
            {
                super(x0);
                this.thread = _scannerThread;
            }

            public void run() {
                this.thread.shutdown();
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to add shutdown hook", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        ScannerThread scannerThread = this.scannerThread;
        synchronized (scannerThread) {
            this.scannerThread.doScan();
            this.scannerThread.setEnabled(this.scanEnabled);
        }
    }

    protected void stopService() throws Exception {
        if (this.scannerThread != null) {
            this.scannerThread.setEnabled(false);
            this.scannerThread.waitForInactive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyService() throws Exception {
        this.deployer = null;
        if (this.scannerThread != null) {
            ScannerThread scannerThread = this.scannerThread;
            synchronized (scannerThread) {
                this.scannerThread.shutdown();
            }
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shutdownHook = null;
        this.scannerThread = null;
    }

    public class ScannerThread
    extends Thread {
        protected Logger scannerLog;
        protected SynchronizedBoolean enabled;
        protected SynchronizedBoolean shuttingDown;
        protected Object lock;
        protected SynchronizedBoolean active;

        public ScannerThread(boolean enabled) {
            super("ScannerThread");
            this.scannerLog = Logger.getLogger(ScannerThread.class);
            this.enabled = new SynchronizedBoolean(false);
            this.shuttingDown = new SynchronizedBoolean(false);
            this.lock = new Object();
            this.active = new SynchronizedBoolean(false);
            this.enabled.set(enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            this.enabled.set(enabled);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.scannerLog.debug((Object)("Notified that enabled: " + enabled));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.enabled.set(false);
            this.shuttingDown.set(true);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.scannerLog.debug((Object)"Notified to shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            this.scannerLog.debug((Object)"Running");
            this.active.set(true);
            try {
                while (!this.shuttingDown.get()) {
                    if (!this.enabled.get()) {
                        object = this.active;
                        synchronized (object) {
                            this.active.set(false);
                            this.active.notifyAll();
                        }
                        try {
                            this.scannerLog.debug((Object)"Disabled, waiting for notification");
                            object = this.lock;
                            synchronized (object) {
                                this.lock.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.active.set(true);
                    }
                    this.loop();
                }
            }
            finally {
                object = this.active;
                synchronized (object) {
                    this.active.set(false);
                    this.active.notifyAll();
                }
            }
            this.scannerLog.debug((Object)"Shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitForInactive() {
            boolean interrupted = false;
            SynchronizedBoolean synchronizedBoolean = this.active;
            synchronized (synchronizedBoolean) {
                try {
                    if (this.active.get() && AbstractDeploymentScanner.this.stopTimeOut > 0L) {
                        this.active.wait(AbstractDeploymentScanner.this.stopTimeOut);
                    }
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        public void doScan() {
            try {
                AbstractDeploymentScanner.this.scan();
            }
            catch (Exception e) {
                this.scannerLog.error((Object)"Scanning failed; continuing", (Throwable)e);
            }
        }

        protected void loop() {
            while (this.enabled.get() && !this.shuttingDown.get()) {
                this.doScan();
                try {
                    this.scannerLog.trace((Object)"Sleeping...");
                    Thread.sleep(AbstractDeploymentScanner.this.scanPeriod);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

