/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.osm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.model.PropertyAccessException;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.osm.ObjectAdapter;
import org.nuxeo.ecm.core.api.model.impl.osm.ObjectAdapterManager;
import org.nuxeo.ecm.core.api.model.impl.osm.util.AccessException;
import org.nuxeo.ecm.core.api.model.impl.osm.util.MemberAccessor;
import org.nuxeo.ecm.core.api.model.impl.osm.util.ObjectAccessorHelper;

public abstract class DynamicObjectAdapter
implements ObjectAdapter {
    private static final long serialVersionUID = 7739233932736918918L;
    protected final Map<String, MemberAccessor> fields;
    protected final Class<?> type;

    protected DynamicObjectAdapter(Class<?> type) {
        this.type = type;
        this.fields = new HashMap<String, MemberAccessor>();
    }

    public void addField(String name, String property) throws PropertyException {
        this.addField(name, property, false);
    }

    public void addField(String name, String property, boolean isReadOnly) throws PropertyException {
        try {
            MemberAccessor accessor = ObjectAccessorHelper.getMemberAccessor(this.type, property, isReadOnly);
            this.fields.put(name, accessor);
        }
        catch (Exception e) {
            throw new PropertyException("Mapping property " + property + " to field " + name + " from type " + this.type + " failed", e);
        }
    }

    @Override
    public Map<String, Object> getMap(Object object) throws PropertyException {
        if (object == null) {
            throw new PropertyAccessException("Trying to access a member of a null object");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, MemberAccessor> entry : this.fields.entrySet()) {
            MemberAccessor accessor = entry.getValue();
            ObjectAdapter adapter = (ObjectAdapter)ObjectAdapterManager.getInstance().get(accessor.getType());
            try {
                if (adapter == null) {
                    map.put(entry.getKey(), accessor.get(object));
                    continue;
                }
                map.put(entry.getKey(), adapter.getMap(accessor.get(object)));
            }
            catch (AccessException e) {
                throw new PropertyAccessException(entry.getKey(), e);
            }
        }
        return map;
    }

    @Override
    public void setMap(Object object, Map<String, Object> value) throws PropertyException {
        if (object == null) {
            throw new PropertyAccessException("Trying to access a member of a null object");
        }
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String key = entry.getKey();
            MemberAccessor accessor = this.fields.get(key);
            if (accessor == null) {
                throw new PropertyNotFoundException(key);
            }
            ObjectAdapter adapter = (ObjectAdapter)ObjectAdapterManager.getInstance().get(accessor.getType());
            try {
                if (adapter == null) {
                    accessor.set(object, entry.getValue());
                    continue;
                }
                adapter.setMap(object, (Map)entry.getValue());
            }
            catch (AccessException e) {
                throw new PropertyAccessException(entry.getKey(), e);
            }
        }
    }

    @Override
    public Object getValue(Object object, String name) throws PropertyException {
        if (object == null) {
            throw new PropertyAccessException("Trying to access a member of a null object: " + name);
        }
        MemberAccessor accessor = this.fields.get(name);
        if (accessor == null) {
            throw new PropertyNotFoundException(name);
        }
        try {
            return accessor.get(object);
        }
        catch (AccessException e) {
            throw new PropertyAccessException(name, e);
        }
    }

    @Override
    public void setValue(Object object, String name, Object value) throws PropertyException {
        if (object == null) {
            throw new PropertyAccessException("Trying to access a member of a null object: " + name);
        }
        MemberAccessor accessor = this.fields.get(name);
        if (accessor == null) {
            throw new PropertyNotFoundException(name);
        }
        try {
            accessor.set(object, value);
        }
        catch (AccessException e) {
            throw new PropertyAccessException(name, e);
        }
    }

    @Override
    public ObjectAdapter getAdapter(String name) throws PropertyNotFoundException {
        MemberAccessor accessor = this.fields.get(name);
        if (accessor == null) {
            throw new PropertyNotFoundException(name);
        }
        return (ObjectAdapter)ObjectAdapterManager.getInstance().get(accessor.getType());
    }

    @Override
    public Serializable getDefaultValue() {
        return null;
    }
}

