/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.nuxeo.common.utils.FileTreeIterator;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentReader;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class XMLDirectoryReader
extends AbstractDocumentReader {
    private File source;
    private FileTreeIterator iterator;

    public XMLDirectoryReader(String sourcePath) {
        this(new File(sourcePath));
    }

    public XMLDirectoryReader(File source) {
        this.source = source;
        this.iterator = new FileTreeIterator(source);
        this.iterator.setFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    @Override
    public void close() {
        this.source = null;
        this.iterator = null;
    }

    @Override
    public ExportedDocument read() throws IOException {
        if (this.iterator.hasNext()) {
            File dir = this.iterator.next();
            if (dir == null) {
                return null;
            }
            ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
            for (File file : dir.listFiles()) {
                if (!file.isFile()) continue;
                String name = file.getName();
                if ("document.xml".equals(name)) {
                    Document doc = XMLDirectoryReader.loadXML(file);
                    xdoc.setDocument(doc);
                    xdoc.setPath(this.computeRelativePath(dir));
                    continue;
                }
                if (name.endsWith(".xml")) {
                    xdoc.putDocument(FileUtils.getFileNameNoExt((String)file.getName()), XMLDirectoryReader.loadXML(file));
                    continue;
                }
                xdoc.putBlob(file.getName(), (Blob)new StreamingBlob((StreamSource)new FileSource(file)));
            }
            return xdoc;
        }
        return null;
    }

    private Path computeRelativePath(File file) {
        String subPathS = file.getAbsolutePath().substring(this.source.getAbsolutePath().length());
        subPathS = subPathS.replace(File.separatorChar, '/');
        return new Path(subPathS);
    }

    private static Document loadXML(File file) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            Document document = new SAXReader().read((InputStream)in);
            return document;
        }
        catch (DocumentException e) {
            IOException ioe = new IOException("Failed to read file document " + file + ": " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

