/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.server;

import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.server.support.BuilderTest;
import org.jboss.test.jmx.compliance.server.support.DelegateListener;
import org.jboss.test.jmx.compliance.server.support.MBeanServerReplaced;
import org.jboss.test.jmx.compliance.server.support.MBeanServerWrapper;
import org.jboss.test.jmx.compliance.server.support.TestMBeanServerBuilder;
import org.jboss.test.jmx.compliance.server.support.TestMBeanServerDelegate;

public class MBeanServerBuilderTestCase
extends TestCase {
    private ObjectName name;
    private ObjectName delegateName;
    private String defaultBuilder;
    private static final String DEFAULT_DOMAIN = "default";
    private static final String BUILDER_PROPERTY = "javax.management.builder.initial";

    public MBeanServerBuilderTestCase(String s) {
        super(s);
        try {
            this.name = new ObjectName("server:test=MBeanServerBuilder");
            this.delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
        this.defaultBuilder = System.getProperty(BUILDER_PROPERTY, "javax.management.MBeanServerBuilder");
    }

    public void testNewMBeanServerDelegate() throws Exception {
        MBeanServerBuilder builder = new MBeanServerBuilder();
        MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
        MBeanServerBuilderTestCase.assertNotNull((Object)delegate);
    }

    public void testNewMBeanServer() throws Exception {
        MBeanServerBuilder builder = new MBeanServerBuilder();
        MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
        MBeanServer server = builder.newMBeanServer(DEFAULT_DOMAIN, null, delegate);
        MBeanServerBuilderTestCase.assertTrue((boolean)server.getDefaultDomain().equals(DEFAULT_DOMAIN));
    }

    public void testNewMBeanServerViaMBeanServerFactory() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer(DEFAULT_DOMAIN);
        MBeanServerBuilderTestCase.assertTrue((boolean)server.getDefaultDomain().equals(DEFAULT_DOMAIN));
    }

    public void testPreRegisterGetsTheOriginalMBeanServer() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer(DEFAULT_DOMAIN);
        BuilderTest test = new BuilderTest();
        server.registerMBean(test, this.name);
        MBeanServerBuilderTestCase.assertTrue((String)"Registered", (boolean)server.isRegistered(this.name));
        MBeanServerBuilderTestCase.assertTrue((String)"Got the correct MBeanServer", (boolean)test.server.equals(server));
    }

    public void testPreRegisterGetsTheOuterMBeanServer() throws Exception {
        MBeanServer server;
        MBeanServerBuilder builder = new MBeanServerBuilder();
        MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
        MBeanServer wrapper = MBeanServerWrapper.getWrapper();
        MBeanServerWrapper.getHandler((MBeanServer)wrapper).server = server = builder.newMBeanServer(DEFAULT_DOMAIN, wrapper, delegate);
        BuilderTest test = new BuilderTest();
        wrapper.registerMBean(test, this.name);
        MBeanServerBuilderTestCase.assertTrue((String)"Registered", (boolean)server.isRegistered(this.name));
        MBeanServerBuilderTestCase.assertTrue((String)"Got the correct MBeanServer", (boolean)test.server.equals(wrapper));
        MBeanServerBuilderTestCase.assertTrue((String)"Wrapper invoked", (boolean)MBeanServerWrapper.getHandler((MBeanServer)wrapper).invoked);
    }

    public void testMBeanServerDelegateReplaced() throws Exception {
        MBeanServerBuilder builder = new MBeanServerBuilder();
        TestMBeanServerDelegate delegate = new TestMBeanServerDelegate();
        MBeanServer server = builder.newMBeanServer(DEFAULT_DOMAIN, null, delegate);
        server.getAttribute(this.delegateName, "MBeanServerId");
        MBeanServerBuilderTestCase.assertTrue((String)"Delegate replaced", (boolean)delegate.invoked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplaceMBeanServerBuilderMBeanServerDelegate() throws Exception {
        System.setProperty(BUILDER_PROPERTY, TestMBeanServerBuilder.class.getName());
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            DelegateListener listener = new DelegateListener();
            server.addNotificationListener(this.delegateName, listener, null, null);
            BuilderTest test = new BuilderTest();
            server.registerMBean(test, this.name);
            MBeanServerBuilderTestCase.assertTrue((String)"Delegate replaced", (boolean)listener.userData.equals("replaced"));
        }
        finally {
            System.setProperty(BUILDER_PROPERTY, this.defaultBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplaceMBeanServerBuilderMBeanServer() throws Exception {
        System.setProperty(BUILDER_PROPERTY, TestMBeanServerBuilder.class.getName());
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            boolean caught = false;
            try {
                server.queryMBeans(null, null);
            }
            catch (MBeanServerReplaced e) {
                caught = true;
            }
            MBeanServerBuilderTestCase.assertTrue((String)"MBeanServer replaced", (boolean)caught);
        }
        finally {
            System.setProperty(BUILDER_PROPERTY, this.defaultBuilder);
        }
    }
}

