/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.io.File;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.FileDocumentBasePage;
import org.nuxeo.functionaltests.pages.forms.FileCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.WorkspaceFormPage;

public class ITFileUpload
extends AbstractTest {
    @Test
    public void testFileUpload() throws Exception {
        DocumentBasePage documentBasePage = this.login().getContentTab().goToDocument("Workspaces");
        WorkspaceFormPage workspaceCreationFormPage = documentBasePage.getWorkspaceContentTab().getWorkspaceCreatePage();
        DocumentBasePage workspacePage = workspaceCreationFormPage.createNewWorkspace("workspace1", "a workspace description");
        FileCreationFormPage fileFormPage = (FileCreationFormPage)workspacePage.getContentTab().getDocumentCreatePage("File", FileCreationFormPage.class);
        String fileToUpload = this.getFileFromResource("filetoupload.txt");
        String fileName = fileToUpload.substring(fileToUpload.lastIndexOf(File.separator) + 1);
        FileDocumentBasePage fileDocumentBasePage = fileFormPage.createFileDocument("file title", "file description", fileToUpload);
        String uploadedFileName = fileDocumentBasePage.getFileSummaryTab().getMainContentFileText();
        Assert.assertTrue((String)("The uploaded file name " + uploadedFileName + " didn't match the updated file name"), (boolean)uploadedFileName.contains(fileName));
    }

    protected String getFileFromResource(String filePath) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL fileUrl = cl.getResource(filePath);
        Assert.assertEquals((Object)"file", (Object)fileUrl.getProtocol());
        return fileUrl.getPath();
    }
}

