/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import junit.framework.Assert;
import org.junit.Test;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.LoginPage;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.nuxeo.functionaltests.pages.admincenter.ConnectHomePage;
import org.nuxeo.functionaltests.pages.admincenter.PackageInstallationScreen;
import org.nuxeo.functionaltests.pages.admincenter.PackageListingPage;
import org.nuxeo.functionaltests.pages.admincenter.SystemHomePage;
import org.nuxeo.functionaltests.pages.admincenter.UpdateCenterPage;
import org.nuxeo.functionaltests.pages.wizard.ConnectWizardPage;
import org.nuxeo.functionaltests.pages.wizard.SummaryWizardPage;
import org.nuxeo.functionaltests.pages.wizard.WizardPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ITWizardAndUpdateCenter
extends AbstractTest {
    private static final String MARKETPLACE_PACKAGE_ID = "audit-web-access-1.0.2";
    private static final String SMTP_SERVER_HOST = "someSMTPServer.com";
    private static final String SMTP_SERVER_PORT = "27";
    protected static final String NX_LOGIN = "Administrator";
    protected static final String NX_PASSWORD = "Administrator";
    protected static final String CONNECT_LOGIN = "junit4tester";
    protected static final String CONNECT_PROJECT_SELECTOR = "junit4tester";
    public static final String CONNECT_FORM_TITLE = "Enable Nuxeo Connect & Nuxeo Studio for your installation";

    protected String getTestPassword() {
        return "XXX";
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    public void runWizardAndRestart() throws Exception {
        WizardPage welcomePage = (WizardPage)ITWizardAndUpdateCenter.get((String)"http://localhost:8080/nuxeo", WizardPage.class);
        Assert.assertTrue((boolean)welcomePage.getTitle().contains("Welcome to "));
        WizardPage settingsPage = welcomePage.next();
        Assert.assertNotNull((Object)settingsPage);
        Assert.assertEquals((String)"General settings", (String)settingsPage.getTitle());
        welcomePage = settingsPage.previous();
        Assert.assertNotNull((Object)welcomePage);
        Assert.assertFalse((boolean)welcomePage.hasError());
        Assert.assertTrue((boolean)welcomePage.getTitle().contains("Welcome to "));
        WizardPage proxyPage = welcomePage.next().next();
        Assert.assertNotNull((Object)proxyPage);
        Assert.assertFalse((boolean)proxyPage.hasError());
        Assert.assertEquals((String)"HTTP proxy settings", (String)proxyPage.getTitle());
        Assert.assertTrue((boolean)proxyPage.selectOption("nuxeo.http.proxy.type", "anonymous"));
        proxyPage.clearInput("nuxeo.http.proxy.host");
        proxyPage.clearInput("nuxeo.http.proxy.port");
        proxyPage = proxyPage.next();
        Assert.assertTrue((boolean)proxyPage.hasError());
        proxyPage.fillInput("nuxeo.http.proxy.host", "myproxy");
        proxyPage.fillInput("nuxeo.http.proxy.port", "AAAA");
        proxyPage = proxyPage.next();
        Assert.assertTrue((boolean)proxyPage.hasError());
        proxyPage.fillInput("nuxeo.http.proxy.port", "8080");
        WizardPage somePage = proxyPage.next();
        Assert.assertFalse((boolean)somePage.hasError());
        proxyPage = somePage.previous();
        Assert.assertTrue((boolean)proxyPage.selectOption("nuxeo.http.proxy.type", "authenticated"));
        proxyPage.clearInput("nuxeo.http.proxy.login");
        proxyPage.clearInput("nuxeo.http.proxy.password");
        proxyPage = proxyPage.next();
        Assert.assertTrue((boolean)proxyPage.hasError());
        Assert.assertTrue((boolean)proxyPage.selectOption("nuxeo.http.proxy.type", "none"));
        WizardPage dbPage = proxyPage.next();
        Assert.assertNotNull((Object)dbPage);
        Assert.assertFalse((boolean)dbPage.hasError());
        Assert.assertEquals((String)"Database settings", (String)dbPage.getTitle());
        WizardPage smtpPage = dbPage.next();
        Assert.assertNotNull((Object)smtpPage);
        Assert.assertEquals((String)"SMTP Settings", (String)smtpPage.getTitle());
        Assert.assertTrue((boolean)smtpPage.selectOption("mail.smtp.auth", "false"));
        smtpPage.fillInput("mail.smtp.host", SMTP_SERVER_HOST);
        smtpPage.fillInput("mail.smtp.port", "AAA");
        smtpPage = (WizardPage)smtpPage.next(WizardPage.class);
        Assert.assertTrue((boolean)smtpPage.hasError());
        smtpPage.fillInput("mail.smtp.port", SMTP_SERVER_PORT);
        Assert.assertTrue((boolean)smtpPage.selectOption("mail.smtp.auth", "true"));
        smtpPage.clearInput("mail.smtp.username");
        smtpPage.clearInput("mail.smtp.password");
        smtpPage = (WizardPage)smtpPage.next(WizardPage.class);
        Assert.assertTrue((boolean)smtpPage.hasError());
        Assert.assertTrue((boolean)smtpPage.selectOption("mail.smtp.auth", "false"));
        WizardPage connectWizardPage = (WizardPage)smtpPage.next(WizardPage.class);
        Assert.assertNotNull((Object)connectWizardPage);
        Assert.assertFalse((boolean)connectWizardPage.hasError());
        System.out.println(driver.getCurrentUrl());
        ConnectWizardPage connectPage1 = connectWizardPage.getConnectPage();
        System.out.println(driver.getCurrentUrl());
        Assert.assertNotNull((Object)connectPage1);
        Assert.assertEquals((String)CONNECT_FORM_TITLE, (String)connectPage1.getTitle());
        ConnectWizardPage connectPage2 = (ConnectWizardPage)connectPage1.next(ConnectWizardPage.class);
        Assert.assertNotNull((Object)connectPage2);
        Assert.assertEquals((String)"There were some errors in your form: You must define a login", (String)connectPage2.getErrorMessage());
        ConnectWizardPage connectSkip = (ConnectWizardPage)connectPage1.navByLink(ConnectWizardPage.class, "Or skip and don't register");
        Assert.assertNotNull((Object)connectSkip);
        Assert.assertEquals((String)"You have not registered your instance on Nuxeo Connect.", (String)connectSkip.getTitle2());
        connectWizardPage = (WizardPage)connectSkip.navById(WizardPage.class, "btnRetry");
        connectPage1 = connectWizardPage.getConnectPage();
        Assert.assertNotNull((Object)connectPage1);
        System.out.println(driver.getCurrentUrl());
        ConnectWizardPage connectSignIn = connectPage1.getLink("click here");
        System.out.println(driver.getCurrentUrl());
        Assert.assertEquals((String)"Pre-Register your new Nuxeo instance", (String)connectSignIn.getTitle());
        System.out.println(driver.getCurrentUrl());
        connectSignIn.fillInput("clogin", "junit4tester");
        connectSignIn.fillInput("cpassword", this.getTestPassword());
        ConnectWizardPage connectProjectPage = (ConnectWizardPage)connectSignIn.nav(ConnectWizardPage.class, "Continue");
        Assert.assertNotNull((Object)connectProjectPage);
        connectProjectPage.fillInput("project", "junit4tester");
        ConnectWizardPage connectFinish = (ConnectWizardPage)connectProjectPage.nav(ConnectWizardPage.class, "Continue");
        Assert.assertNotNull((Object)connectFinish);
        Assert.assertEquals((String)"Your pre-registration has been done!", (String)connectFinish.getTitle());
        SummaryWizardPage summary = (SummaryWizardPage)connectFinish.nav(SummaryWizardPage.class, "Continue");
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((String)"Summary", (String)summary.getTitle());
        Assert.assertNotNull((Object)summary.getRegistration());
        LoginPage loginPage = summary.restart();
    }

    public void loopOnIframe() throws Exception {
        WizardPage welcomePage = (WizardPage)ITWizardAndUpdateCenter.get((String)"http://localhost:8080/nuxeo", WizardPage.class);
        Assert.assertTrue((boolean)welcomePage.getTitle().contains("Welcome to "));
        WizardPage settingsPage = welcomePage.next();
        Assert.assertNotNull((Object)settingsPage);
        Assert.assertEquals((String)"General settings", (String)settingsPage.getTitle());
        WizardPage proxyPage = settingsPage.next();
        Assert.assertNotNull((Object)proxyPage);
        Assert.assertFalse((boolean)proxyPage.hasError());
        Assert.assertEquals((String)"HTTP proxy settings", (String)proxyPage.getTitle());
        Assert.assertTrue((boolean)proxyPage.selectOption("nuxeo.http.proxy.type", "none"));
        WizardPage dbPage = proxyPage.next();
        Assert.assertNotNull((Object)dbPage);
        Assert.assertFalse((boolean)dbPage.hasError());
        Assert.assertEquals((String)"Database settings", (String)dbPage.getTitle());
        WizardPage smtpPage = dbPage.next();
        Assert.assertNotNull((Object)smtpPage);
        Assert.assertEquals((String)"SMTP Settings", (String)smtpPage.getTitle());
        Assert.assertTrue((boolean)smtpPage.selectOption("mail.smtp.auth", "false"));
        WizardPage connectWizardPage = (WizardPage)smtpPage.next(WizardPage.class);
        for (int i = 1; i < 20; ++i) {
            Assert.assertNotNull((Object)connectWizardPage);
            Assert.assertFalse((boolean)connectWizardPage.hasError());
            System.out.println(driver.getCurrentUrl());
            ConnectWizardPage connectPage1 = connectWizardPage.getConnectPage();
            System.out.println(driver.getCurrentUrl());
            Assert.assertNotNull((Object)connectPage1);
            Assert.assertEquals((String)CONNECT_FORM_TITLE, (String)connectPage1.getTitle());
            ConnectWizardPage connectPage2 = (ConnectWizardPage)connectPage1.next(ConnectWizardPage.class);
            Assert.assertNotNull((Object)connectPage2);
            Assert.assertEquals((String)"There were some errors in your form: You must define a login", (String)connectPage2.getErrorMessage());
            ConnectWizardPage connectSkip = (ConnectWizardPage)connectPage1.nav(ConnectWizardPage.class, "Skip");
            Assert.assertNotNull((Object)connectSkip);
            Assert.assertEquals((String)"You have not registered your instance on Nuxeo Connect.", (String)connectSkip.getTitle2());
            connectWizardPage = (WizardPage)connectSkip.navById(WizardPage.class, "btnRetry");
        }
    }

    public void installPackageAndRestart() throws Exception {
        DocumentBasePage home = this.login("Administrator", "Administrator");
        AdminCenterBasePage adminHome = home.getAdminCenter();
        Assert.assertNotNull((Object)adminHome);
        ConnectHomePage connectHome = adminHome.getConnectHomePage();
        Assert.assertNotNull((Object)connectHome);
        Assert.assertEquals((String)"Connect registration OK", (String)connectHome.getConnectStatus());
        SystemHomePage systemPage = connectHome.getSystemHomePage();
        String smtpHost = systemPage.getConfig("mail.smtp.host");
        Assert.assertEquals((String)SMTP_SERVER_HOST, (String)smtpHost);
        UpdateCenterPage updateCenterHome = systemPage.getUpdateCenterHomePage();
        updateCenterHome = (UpdateCenterPage)updateCenterHome.nav(UpdateCenterPage.class, "Packages from Nuxeo Marketplace");
        PackageListingPage packageListing = updateCenterHome.getPackageListingPage();
        WebElement link = packageListing.download(MARKETPLACE_PACKAGE_ID);
        Assert.assertNotNull((Object)link);
        PackageInstallationScreen installScreen = packageListing.getInstallationScreen(MARKETPLACE_PACKAGE_ID);
        Assert.assertNotNull((Object)installScreen);
        packageListing = installScreen.start();
        Assert.assertNotNull((Object)packageListing);
        WebElement packageLink = packageListing.getPackageLink(MARKETPLACE_PACKAGE_ID);
        Assert.assertNotNull((Object)packageLink);
        if (ITWizardAndUpdateCenter.isWindows()) {
            Assert.assertTrue((boolean)packageLink.getText().trim().toLowerCase().startsWith("restart"));
        } else {
            Assert.assertTrue((boolean)packageLink.getText().trim().toLowerCase().startsWith("uninstall"));
        }
        updateCenterHome = packageListing.exit();
        Assert.assertNotNull((Object)updateCenterHome);
        SystemHomePage systemHome = updateCenterHome.getSystemHomePage();
        Assert.assertNotNull((Object)systemHome);
        LoginPage loginPage = systemHome.restart();
    }

    public void verifyPackageInstallation() throws Exception {
        DocumentBasePage home = this.login("Administrator", "Administrator");
        AdminCenterBasePage adminHome = home.getAdminCenter();
        Assert.assertNotNull((Object)adminHome);
        SystemHomePage systemHomePage = adminHome.getSystemHomePage();
        AdminCenterBasePage distributions = systemHomePage.selectSubTab("Nuxeo distribution");
        WebElement bundle = ITWizardAndUpdateCenter.findElementWithTimeout((By)By.xpath((String)"//td[text()='org.nuxeo.ecm.platform.audit.web.access']"));
        Assert.assertNotNull((Object)bundle);
    }

    public void studioPackageInstallAndUninstall() throws Exception {
    }

    @Test
    public void testAll() throws Exception {
        this.runWizardAndRestart();
        this.installPackageAndRestart();
        this.verifyPackageInstallation();
    }
}

