/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.query;

import java.util.ArrayList;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.server.support.query.CalendarHelper;
import org.apache.chemistry.opencmis.server.support.query.PredicateWalker;

public abstract class AbstractPredicateWalker
implements PredicateWalker {
    public Boolean walkPredicate(Tree node) {
        switch (node.getType()) {
            case 34: {
                return this.walkNot(node, node.getChild(0));
            }
            case 32: {
                return this.walkAnd(node, node.getChild(0), node.getChild(1));
            }
            case 33: {
                return this.walkOr(node, node.getChild(0), node.getChild(1));
            }
            case 48: {
                return this.walkEquals(node, node.getChild(0), node.getChild(1));
            }
            case 49: {
                return this.walkNotEquals(node, node.getChild(0), node.getChild(1));
            }
            case 51: {
                return this.walkGreaterThan(node, node.getChild(0), node.getChild(1));
            }
            case 53: {
                return this.walkGreaterOrEquals(node, node.getChild(0), node.getChild(1));
            }
            case 50: {
                return this.walkLessThan(node, node.getChild(0), node.getChild(1));
            }
            case 52: {
                return this.walkLessOrEquals(node, node.getChild(0), node.getChild(1));
            }
            case 35: {
                return this.walkIn(node, node.getChild(0), node.getChild(1));
            }
            case 11: {
                return this.walkNotIn(node, node.getChild(0), node.getChild(1));
            }
            case 8: {
                return this.walkInAny(node, node.getChild(0), node.getChild(1));
            }
            case 9: {
                return this.walkNotInAny(node, node.getChild(0), node.getChild(1));
            }
            case 10: {
                return this.walkEqAny(node, node.getChild(0), node.getChild(1));
            }
            case 13: {
                return this.walkIsNull(node, node.getChild(0));
            }
            case 14: {
                return this.walkIsNotNull(node, node.getChild(0));
            }
            case 36: {
                return this.walkLike(node, node.getChild(0), node.getChild(1));
            }
            case 12: {
                return this.walkNotLike(node, node.getChild(0), node.getChild(1));
            }
            case 38: {
                if (node.getChildCount() == 1) {
                    return this.walkContains(node, null, node.getChild(0));
                }
                return this.walkContains(node, node.getChild(0), node.getChild(1));
            }
            case 40: {
                if (node.getChildCount() == 1) {
                    return this.walkInFolder(node, null, node.getChild(0));
                }
                return this.walkInFolder(node, node.getChild(0), node.getChild(1));
            }
            case 41: {
                if (node.getChildCount() == 1) {
                    return this.walkInTree(node, null, node.getChild(0));
                }
                return this.walkInTree(node, node.getChild(0), node.getChild(1));
            }
        }
        return this.walkOtherPredicate(node);
    }

    protected Boolean walkOtherPredicate(Tree node) {
        throw new CmisRuntimeException("Unknown node type: " + node.getType() + " (" + node.getText() + ")");
    }

    public Boolean walkNot(Tree opNode, Tree node) {
        this.walkPredicate(node);
        return false;
    }

    public Boolean walkAnd(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkPredicate(leftNode);
        this.walkPredicate(rightNode);
        return false;
    }

    public Boolean walkOr(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkPredicate(leftNode);
        this.walkPredicate(rightNode);
        return false;
    }

    public Object walkExpr(Tree node) {
        switch (node.getType()) {
            case 54: {
                return this.walkBoolean(node);
            }
            case 59: {
                return this.walkNumber(node);
            }
            case 60: {
                return this.walkString(node);
            }
            case 62: {
                return this.walkTimestamp(node);
            }
            case 7: {
                return this.walkList(node);
            }
            case 5: {
                return this.walkCol(node);
            }
            case 63: {
                return this.walkId(node);
            }
        }
        return this.walkOtherExpr(node);
    }

    protected Object walkOtherExpr(Tree node) {
        throw new CmisRuntimeException("Unknown node type: " + node.getType() + " (" + node.getText() + ")");
    }

    public Boolean walkEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkNotEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkGreaterThan(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkGreaterOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkLessThan(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkLessOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkIn(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    public Boolean walkNotIn(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    public Boolean walkInAny(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    public Boolean walkNotInAny(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    public Boolean walkEqAny(Tree opNode, Tree literalNode, Tree colNode) {
        this.walkExpr(literalNode);
        this.walkExpr(colNode);
        return false;
    }

    public Boolean walkIsNull(Tree opNode, Tree colNode) {
        this.walkExpr(colNode);
        return false;
    }

    public Boolean walkIsNotNull(Tree opNode, Tree colNode) {
        this.walkExpr(colNode);
        return false;
    }

    public Boolean walkLike(Tree opNode, Tree colNode, Tree stringNode) {
        this.walkExpr(colNode);
        this.walkExpr(stringNode);
        return false;
    }

    public Boolean walkNotLike(Tree opNode, Tree colNode, Tree stringNode) {
        this.walkExpr(colNode);
        this.walkExpr(stringNode);
        return false;
    }

    public Boolean walkContains(Tree opNode, Tree qualNode, Tree queryNode) {
        if (qualNode != null) {
            this.walkExpr(qualNode);
        }
        this.walkExpr(queryNode);
        return false;
    }

    public Boolean walkInFolder(Tree opNode, Tree qualNode, Tree paramNode) {
        if (qualNode != null) {
            this.walkExpr(qualNode);
        }
        this.walkExpr(paramNode);
        return false;
    }

    public Boolean walkInTree(Tree opNode, Tree qualNode, Tree paramNode) {
        if (qualNode != null) {
            this.walkExpr(qualNode);
        }
        this.walkExpr(paramNode);
        return false;
    }

    public Object walkList(Tree node) {
        int n = node.getChildCount();
        ArrayList<Object> res = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            res.add(this.walkExpr(node.getChild(i)));
        }
        return res;
    }

    public Object walkBoolean(Tree node) {
        String s = node.getText();
        return Boolean.valueOf(s);
    }

    public Object walkNumber(Tree node) {
        String s = node.getText();
        if (s.contains(".") || s.contains("e") || s.contains("E")) {
            return Double.valueOf(s);
        }
        return Long.valueOf(s);
    }

    public Object walkString(Tree node) {
        String s = node.getText();
        s = s.substring(1, s.length() - 1);
        s = s.replace("''", "'");
        return s;
    }

    public Object walkTimestamp(Tree node) {
        String s = node.getText();
        s = s.substring(s.indexOf(39) + 1, s.length() - 1);
        return CalendarHelper.fromString(s);
    }

    public Object walkCol(Tree node) {
        return null;
    }

    public Object walkId(Tree node) {
        return null;
    }
}

