/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.install.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;
import org.nuxeo.common.utils.PathFilterSet;
import org.nuxeo.runtime.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.DeleteCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.MoveCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.commands.UnzipCommand;
import org.nuxeo.runtime.deployment.preprocessor.install.filters.IncludeFilter;

public class SeamHotDeployCommand
implements Command {
    protected static final Log log = LogFactory.getLog(SeamHotDeployCommand.class);
    public static boolean enabled = false;
    public static PathFilterSet globalFilters = new PathFilterSet();
    private static final String BACKUP_JAR = "~seamhotdeploy";
    private static final String JAR = ".jar";
    private static final String HOTDEPLOY_JAR = "-seamhotdeploy.jar";
    protected final PathFilterSet filters;

    public SeamHotDeployCommand(PathFilterSet fragmentFilters) {
        this.filters = fragmentFilters;
        this.filters.addAll((Collection)globalFilters);
    }

    @Override
    public void exec(CommandContext ctx) throws IOException {
        String originalFilename = ctx.expandVars("${bundle.fileName}");
        if (originalFilename.endsWith(HOTDEPLOY_JAR)) {
            originalFilename = originalFilename.replace(HOTDEPLOY_JAR, JAR);
        }
        Path originalJarPath = new Path(originalFilename);
        Path backupJarPath = new Path(originalFilename.concat(BACKUP_JAR));
        Path seamDevPath = new Path("${war}/WEB-INF/dev");
        File backupJar = new File(ctx.getBaseDir(), backupJarPath.toString());
        if (backupJar.exists()) {
            new DeleteCommand(originalJarPath).exec(ctx);
            new MoveCommand(backupJarPath, originalJarPath).exec(ctx);
        }
        if (!enabled) {
            return;
        }
        this.loadFilters(new File(ctx.getBaseDir(), originalJarPath.toString()));
        new MoveCommand(originalJarPath, backupJarPath).exec(ctx);
        new UnzipCommand(backupJarPath, seamDevPath, (PathFilter)this.filters).exec(ctx);
        new UnzipCommand(backupJarPath, originalJarPath, new ColdFilter((PathFilter)this.filters)).exec(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFilters(File file) throws IOException {
        JarFile jf = new JarFile(file);
        ZipEntry ze = jf.getEntry("seam.properties");
        if (ze == null) {
            return;
        }
        InputStream is = jf.getInputStream(ze);
        try {
            SeamHotDeployCommand.loadFilters(this.filters, is);
        }
        finally {
            is.close();
        }
    }

    public static void loadFilters(InputStream is) throws IOException {
        SeamHotDeployCommand.loadFilters(globalFilters, is);
    }

    protected static void loadFilters(PathFilterSet filters, InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String enabled = (String)e.getValue();
            if (!Boolean.parseBoolean(enabled)) continue;
            String classname = (String)e.getKey();
            String pattern = classname.replace(".", "/").concat(".class");
            filters.add((Object)new IncludeFilter(pattern));
        }
    }

    @Override
    public String toString(CommandContext ctx) {
        return "seam hot deploy " + (String)ctx.get("bundle.fileName");
    }

    protected static class ColdFilter
    implements PathFilter {
        protected PathFilter filter;

        public ColdFilter(PathFilter filter) {
            this.filter = filter;
        }

        public boolean accept(Path path) {
            return !this.filter.accept(path);
        }

        public boolean isExclusive() {
            return this.filter.isExclusive();
        }
    }
}

