/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.json.JSONConverter;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class DiscoveryService {
    private DiscoveryService() {
    }

    public static void query(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger skipCount;
        BigInteger maxItems;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        Boolean searchAllVersions;
        String statement = HttpUtils.getStringParameter(request, "q");
        ObjectList results = service.query(repositoryId, statement, searchAllVersions = HttpUtils.getBooleanParameter(request, "searchAllVersions"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = null, maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount"), null);
        if (results == null) {
            throw new CmisRuntimeException("Results are null!");
        }
        JSONObject jsonResults = JSONConverter.convert(results);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonResults, request, response);
    }
}

