/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import java.io.Serializable;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryInfoCache;
import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.impl.SessionImpl;
import org.apache.chemistry.opencmis.client.bindings.impl.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisBindingImpl
implements CmisBinding,
Serializable {
    private static final long serialVersionUID = 1L;
    private Session session;
    private final BindingsObjectFactory objectFactory;
    private final RepositoryService repositoryServiceWrapper;

    public CmisBindingImpl(Map<String, String> sessionParameters) {
        if (sessionParameters == null) {
            throw new IllegalArgumentException("Session parameters must be set!");
        }
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.spi.classname")) {
            throw new IllegalArgumentException("Session parameters do not contain a SPI class name!");
        }
        this.session = new SessionImpl();
        for (Map.Entry<String, String> entry : sessionParameters.entrySet()) {
            this.session.put(entry.getKey(), (Serializable)((Object)entry.getValue()));
        }
        String authProvider = sessionParameters.get("org.apache.chemistry.opencmis.binding.auth.classname");
        if (authProvider != null) {
            Object authProviderObj = null;
            try {
                authProviderObj = Class.forName(authProvider).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not load authentication provider: " + e, e);
            }
            if (!(authProviderObj instanceof AbstractAuthenticationProvider)) {
                throw new IllegalArgumentException("Authentication provider does not extend AbstractAuthenticationProvider!");
            }
            this.session.put("org.apache.chemistry.opencmis.bindings.auth.object", authProviderObj);
            ((AbstractAuthenticationProvider)authProviderObj).setSession(this.session);
        }
        this.clearAllCaches();
        CmisBindingsHelper.getSPI(this.session);
        this.objectFactory = new BindingsObjectFactoryImpl();
        this.repositoryServiceWrapper = new RepositoryServiceImpl(this.session);
    }

    public RepositoryService getRepositoryService() {
        this.checkSession();
        return this.repositoryServiceWrapper;
    }

    public NavigationService getNavigationService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getNavigationService();
    }

    public ObjectService getObjectService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getObjectService();
    }

    public DiscoveryService getDiscoveryService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getDiscoveryService();
    }

    public RelationshipService getRelationshipService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getRelationshipService();
    }

    public VersioningService getVersioningService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getVersioningService();
    }

    public AclService getAclService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getAclService();
    }

    public MultiFilingService getMultiFilingService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getMultiFilingService();
    }

    public PolicyService getPolicyService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getPolicyService();
    }

    public BindingsObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCaches() {
        this.checkSession();
        this.session.writeLock();
        try {
            this.session.put("org.apache.chemistry.opencmis.bindings.repositoryInfoCache", new RepositoryInfoCache(this.session));
            this.session.put("org.apache.chemistry.opencmis.bindings.typeDefintionCache", new TypeDefinitionCache(this.session));
            CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
            spi.clearAllCaches();
        }
        finally {
            this.session.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRepositoryCache(String repositoryId) {
        this.checkSession();
        if (repositoryId == null) {
            return;
        }
        this.session.writeLock();
        try {
            RepositoryInfoCache repInfoCache = (RepositoryInfoCache)this.session.get("org.apache.chemistry.opencmis.bindings.repositoryInfoCache");
            repInfoCache.remove(repositoryId);
            TypeDefinitionCache typeDefCache = (TypeDefinitionCache)this.session.get("org.apache.chemistry.opencmis.bindings.typeDefintionCache");
            typeDefCache.remove(repositoryId);
            CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
            spi.clearRepositoryCache(repositoryId);
        }
        finally {
            this.session.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.checkSession();
        this.session.writeLock();
        try {
            CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
            spi.close();
        }
        finally {
            this.session.writeUnlock();
            this.session = null;
        }
    }

    private void checkSession() {
        if (this.session == null) {
            throw new IllegalStateException("Already closed.");
        }
    }
}

