/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.ejb;

import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.ejb.interfaces.local.FileManagerLocal;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Local(value={FileManagerLocal.class})
@Remote(value={FileManager.class})
public class FileManagerBean
implements FileManagerLocal {
    private static final Log log = LogFactory.getLog(FileManagerBean.class);
    private FileManager service;
    private CoreSession userSession;
    private String userSessionId;

    private FileManager getFileManagerService() throws ClientException {
        if (this.service == null) {
            this.service = (FileManager)Framework.getLocalService(FileManager.class);
        }
        if (this.service == null) {
            log.error((Object)"Unable to get local FileManager runtime service");
            throw new ClientException("Unable to get local FileManager runtime service");
        }
        return this.service;
    }

    private CoreSession validateSession(CoreSession dm) throws Exception {
        String sid = dm.getSessionId();
        if (CoreInstance.getInstance().isSessionStarted(sid)) {
            return dm;
        }
        if (sid.equals(this.userSessionId) && this.userSession != null) {
            return this.userSession;
        }
        String repositoryName = dm.getRepositoryName();
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("principal", (Serializable)((Object)dm.getPrincipal()));
        RepositoryManager repositoryMgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repository = repositoryMgr.getRepository(repositoryName);
        this.userSession = repository.open(context);
        if (this.userSession == null) {
            throw new ClientException("Unable to connect to Core repository");
        }
        this.userSessionId = sid;
        return this.userSession;
    }

    public DocumentModel createDocumentFromBlob(CoreSession documentManager, Blob input, String path, boolean overwrite, String fullName) throws ClientException {
        try {
            return this.getFileManagerService().createDocumentFromBlob(this.validateSession(documentManager), input, path, overwrite, fullName);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    public DocumentModel updateDocumentFromBlob(CoreSession documentManager, Blob input, String path, String fullName) throws ClientException {
        try {
            return this.getFileManagerService().updateDocumentFromBlob(this.validateSession(documentManager), input, path, fullName);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    public DocumentModel createFolder(CoreSession documentManager, String fullname, String path) throws ClientException {
        try {
            return this.getFileManagerService().createFolder(this.validateSession(documentManager), fullname, path);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    public String computeDigest(Blob blob) throws ClientException, NoSuchAlgorithmException, IOException {
        return this.getFileManagerService().computeDigest(blob);
    }

    public List<String> getFields() throws ClientException {
        return this.getFileManagerService().getFields();
    }

    public boolean isUnicityEnabled() throws ClientException {
        return this.getFileManagerService().isUnicityEnabled();
    }

    public List<DocumentLocation> findExistingDocumentWithFile(CoreSession documentManager, String path, String digest, Principal principal) throws ClientException {
        return this.getFileManagerService().findExistingDocumentWithFile(documentManager, path, digest, principal);
    }

    public DocumentModelList getCreationContainers(Principal principal, String docType) throws Exception {
        return this.getFileManagerService().getCreationContainers(principal, docType);
    }

    public DocumentModelList getCreationContainers(CoreSession documentManager, String docType) throws Exception {
        return this.getFileManagerService().getCreationContainers(documentManager, docType);
    }

    public String getDigestAlgorithm() {
        try {
            return this.getFileManagerService().getDigestAlgorithm();
        }
        catch (ClientException e) {
            return null;
        }
    }

    public boolean isDigestComputingEnabled() {
        try {
            return this.getFileManagerService().isDigestComputingEnabled();
        }
        catch (ClientException e) {
            return false;
        }
    }
}

