/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.core.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDefinitionImpl
extends ItemDefinitionImpl
implements NodeDefinition {
    private static Logger log = LoggerFactory.getLogger((Class)NodeDefinitionImpl.class);

    NodeDefinitionImpl(NodeDef nodeDef, NodeTypeManagerImpl ntMgr, NamePathResolver resolver) {
        super(nodeDef, ntMgr, resolver);
    }

    public NodeDef unwrap() {
        return (NodeDef)this.itemDef;
    }

    public NodeType getDefaultPrimaryType() {
        Name ntName = ((NodeDef)this.itemDef).getDefaultPrimaryType();
        if (ntName == null) {
            return null;
        }
        try {
            return this.ntMgr.getNodeType(ntName);
        }
        catch (NoSuchNodeTypeException e) {
            log.error("invalid default node type " + ntName, (Throwable)e);
            return null;
        }
    }

    public NodeType[] getRequiredPrimaryTypes() {
        Name[] ntNames = ((NodeDef)this.itemDef).getRequiredPrimaryTypes();
        try {
            if (ntNames == null || ntNames.length == 0) {
                return new NodeType[]{this.ntMgr.getNodeType(NameConstants.NT_BASE)};
            }
            NodeType[] nodeTypes = new NodeType[ntNames.length];
            for (int i = 0; i < ntNames.length; ++i) {
                nodeTypes[i] = this.ntMgr.getNodeType(ntNames[i]);
            }
            return nodeTypes;
        }
        catch (NoSuchNodeTypeException e) {
            log.error("required node type does not exist", (Throwable)e);
            return new NodeType[0];
        }
    }

    public boolean allowsSameNameSiblings() {
        return ((NodeDef)this.itemDef).allowsSameNameSiblings();
    }

    public String[] getRequiredPrimaryTypeNames() {
        Name[] ntNames = ((NodeDef)this.itemDef).getRequiredPrimaryTypes();
        try {
            if (ntNames == null || ntNames.length == 0) {
                return new String[]{this.resolver.getJCRName(NameConstants.NT_BASE)};
            }
            String[] names = new String[ntNames.length];
            for (int i = 0; i < ntNames.length; ++i) {
                names[i] = this.resolver.getJCRName(ntNames[i]);
            }
            return names;
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in node type name", (Throwable)e);
            return new String[0];
        }
    }

    public String getDefaultPrimaryTypeName() {
        Name ntName = ((NodeDef)this.itemDef).getDefaultPrimaryType();
        if (ntName == null) {
            return null;
        }
        try {
            return this.resolver.getJCRName(ntName);
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in node type name", (Throwable)e);
            return ntName.toString();
        }
    }
}

