/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.util.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.util.repository.MultiThreadedObjectGenerator;
import org.apache.chemistry.opencmis.util.repository.ObjectGenerator;
import org.apache.chemistry.opencmis.util.repository.TimeLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjGenApp {
    public static final String DEFAULT_USER = "";
    public static final String DEFAULT_PWD = "";
    public static final String PROP_ATOMPUB_URL = "opencmis.test.atompub.url";
    public static final String PROP_URL = "url";
    public static final String PROP_WS_URL = "opencmis.test.webservices.url";
    public static final String DEFAULT_ATOMPUB_URL = "http://localhost:8080/opencmis/atom";
    public static final String DEFAULT_WS_URL = "http://localhost:8080/cmis/services/";
    private static final String CMD = "Command";
    private static final String REPOSITORY_ID = "RepositoryId";
    private static final String FILLER_DOCUMENT_TYPE_ID = "DocumentTypeId";
    private static final String FILLER_FOLDER_TYPE_ID = "FolderTypeId";
    private static final String FILLER_DOCS_PER_FOLDER = "DocsPerFolder";
    private static final String FILLER_FOLDERS_PER_FOLDER = "FoldersPerFolder";
    private static final String FILLER_DEPTH = "Depth";
    private static final String FILLER_CONTENT_SIZE = "ContentSizeInKB";
    private static final String COUNT = "Count";
    private static final String BINDING = "Binding";
    private static final String CLEANUP = "Cleanup";
    private static final String ROOTFOLDER = "RootFolder";
    private static final String THREADS = "Threads";
    private static final String BINDING_ATOM = "AtomPub";
    private static final String BINDING_WS = "WebService";
    private CmisBinding binding;
    private boolean fUsingAtom;
    private String fUrlStr;
    OptionSpec<String> fCmd;
    OptionSpec<Integer> fDepth;
    OptionSpec<Integer> fContentSize;
    OptionSpec<Integer> fFolderPerFolder;
    OptionSpec<Integer> fDocsPerFolder;
    OptionSpec<String> fFolderType;
    OptionSpec<String> fDocType;
    OptionSpec<String> fRepoId;
    OptionSpec<Integer> fCount;
    OptionSpec<String> fBinding;
    OptionSpec<Boolean> fCleanup;
    OptionSpec<String> fRootFolder;
    OptionSpec<Integer> fThreads;

    public static void main(String[] args) {
        ObjGenApp app = new ObjGenApp();
        try {
            app.processCmdLine(args);
        }
        catch (CmisBaseException ce) {
            System.out.println("Error: Could not process command. " + (Object)((Object)ce));
            System.out.println("Extended error: " + ce.getErrorContent());
            ce.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Could not fill repository " + e);
            e.printStackTrace();
        }
    }

    private void processCmdLine(String[] args) {
        OptionParser parser = new OptionParser();
        this.fCmd = parser.accepts(CMD).withRequiredArg().describedAs("Command to perform (see below)");
        this.fRepoId = parser.accepts(REPOSITORY_ID).withOptionalArg().describedAs("Repository used");
        this.fDocType = parser.accepts(FILLER_DOCUMENT_TYPE_ID).withOptionalArg().defaultsTo((Object)BaseTypeId.CMIS_DOCUMENT.value(), (Object[])new String[0]).describedAs("Document type created");
        this.fFolderType = parser.accepts(FILLER_FOLDER_TYPE_ID).withOptionalArg().defaultsTo((Object)BaseTypeId.CMIS_FOLDER.value(), (Object[])new String[0]).describedAs("Folder type created");
        this.fDocsPerFolder = parser.accepts(FILLER_DOCS_PER_FOLDER).withOptionalArg().ofType(Integer.class).describedAs("Documents on each level").defaultsTo((Object)1, (Object[])new Integer[0]);
        this.fFolderPerFolder = parser.accepts(FILLER_FOLDERS_PER_FOLDER).withOptionalArg().ofType(Integer.class).describedAs(" Folders on each level").defaultsTo((Object)0, (Object[])new Integer[0]);
        this.fDepth = parser.accepts(FILLER_DEPTH).withOptionalArg().ofType(Integer.class).describedAs("Levels of folders").defaultsTo((Object)1, (Object[])new Integer[0]);
        this.fContentSize = parser.accepts(FILLER_CONTENT_SIZE).withOptionalArg().ofType(Integer.class).describedAs("Content size of each doc").defaultsTo((Object)0, (Object[])new Integer[0]);
        this.fCount = parser.accepts(COUNT).withOptionalArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Repeat a command n times (partially implemented)");
        this.fBinding = parser.accepts(BINDING).withOptionalArg().ofType(String.class).defaultsTo((Object)BINDING_ATOM, (Object[])new String[0]).describedAs("Protocol Binding: AtomPub or WebService");
        this.fCleanup = parser.accepts(CLEANUP).withOptionalArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]).describedAs("Clean all created objects at the end");
        this.fRootFolder = parser.accepts(ROOTFOLDER).withOptionalArg().ofType(String.class).describedAs("folder id used as root to create objects (default repository root folder)");
        this.fThreads = parser.accepts(THREADS).withOptionalArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Number of threads to start in parallel");
        OptionSet options = parser.parse(args);
        if (options.valueOf(this.fCmd) == null || options.has("?")) {
            ObjGenApp.usage(parser);
        }
        if (((String)options.valueOf(this.fBinding)).equals(BINDING_WS)) {
            this.fUsingAtom = false;
        } else if (((String)options.valueOf(this.fBinding)).equals(BINDING_ATOM)) {
            this.fUsingAtom = true;
        } else {
            System.out.println("Unknown option <Binding>: " + (String)options.valueOf(this.fBinding) + " allowed values: " + BINDING_WS + " or " + BINDING_ATOM);
            return;
        }
        if (((String)options.valueOf(this.fCmd)).equals("FillRepository")) {
            this.fillRepository(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("CreateDocument")) {
            this.createSingleDocument(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("CreateFolder")) {
            this.createFolders(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("RepositoryInfo")) {
            this.repositoryInfo(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("GetUrl")) {
            ObjGenApp.getUrl(this.getConfiguredUrl());
        } else {
            System.out.println("Unknown cmd: " + (String)options.valueOf(this.fCmd));
            ObjGenApp.usage(parser);
        }
    }

    private static void usage(OptionParser parser) {
        try {
            System.out.println();
            System.out.println("ObjGenApp is a command line tool for testing a CMIS repository.");
            System.out.println("Usage:");
            parser.printHelpOn((OutputStream)System.out);
            System.out.println();
            System.out.println("Command is one of [CreateDocument, CreateFolder, FillRepository, RepositoryInfo]");
            System.out.println("JVM system properties: opencmis.test.atompub.url, opencmis.test.webservices.url");
            System.out.println();
            System.out.println("Example: ");
            System.out.println("java -Dopencmis.test.atompub.url=http://localhost:8080/opencmis/atom -cp ... org.apache.chemistry.opencmis.util.repository.ObjGenApp --Binding=AtomPub --Command=CreateDocument --RepositoryId=A1 --ContentSizeInKB=25");
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void fillRepository(String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String rootFolderId, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateTree(this.getBinding(), repoId, docsPerFolder, foldersPerFolders, depth, documentType, folderType, contentSizeInKB, rootFolderId, doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        runner.doCreateTree();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Filling repository succeeded.");
        System.out.println("Folder used as root for creation (null=rootFolderId): " + rootFolderId);
        System.out.println("Number of documents created: " + gen.getDocumentsInTotal());
        System.out.println("Number of folders created: " + gen.getFoldersInTotal());
        gen.printTimings();
    }

    private void fillRepositoryMT(int noThreads, String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String rootFolderId, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateFolder(this.getBinding(), repoId, folderType, rootFolderId, noThreads, doCleanup);
        String[] folderIds = runner.doCreateFolder();
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateTreeMT(this.getBinding(), repoId, docsPerFolder, foldersPerFolders, depth, documentType, folderType, contentSizeInKB, folderIds, doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded(runners);
        System.out.println("Filling repository succeeded.");
    }

    private void printParameters(OptionSet options) {
        if (this.fUsingAtom) {
            System.out.println("Using AtomPub, connecting to  " + ObjGenApp.getAtomPubUrl());
        } else {
            System.out.println("Using WebService, connecting to  " + ObjGenApp.getWsUrl());
        }
        System.out.println("Repository id is: " + (String)options.valueOf(this.fRepoId));
        System.out.println("Content size: " + options.valueOf(this.fContentSize));
        System.out.println("Document Type: " + (String)options.valueOf(this.fDocType));
        System.out.println("Folder id used as root: " + (String)options.valueOf(this.fRootFolder));
        System.out.println("Delete all objects after creation: " + options.valueOf(this.fCleanup));
        System.out.println("Number of actions to perform: " + options.valueOf(this.fCount));
        System.out.println("Number of threads to start: " + options.valueOf(this.fThreads));
    }

    private void createSingleDocument(OptionSet options) {
        System.out.println();
        System.out.println("Creating document with parameters:");
        this.printParameters(options);
        int noThreads = (Integer)options.valueOf(this.fThreads);
        if (noThreads <= 1) {
            this.createSingleDocument((String)options.valueOf(this.fRepoId), (String)options.valueOf(this.fDocType), (Integer)options.valueOf(this.fContentSize), (String)options.valueOf(this.fRootFolder), (Integer)options.valueOf(this.fCount), (Boolean)options.valueOf(this.fCleanup));
        } else {
            this.createSingleDocumentMT(noThreads, (String)options.valueOf(this.fRepoId), (String)options.valueOf(this.fDocType), (Integer)options.valueOf(this.fContentSize), (String)options.valueOf(this.fRootFolder), (Integer)options.valueOf(this.fCount), (Boolean)options.valueOf(this.fCleanup));
        }
    }

    private void fillRepository(OptionSet options) {
        System.out.println();
        this.printParameters(options);
        System.out.println("Creating object tree with folowing parameters: ");
        System.out.println("Documents per folder: " + options.valueOf(this.fDocsPerFolder));
        System.out.println("Folder per folder: " + options.valueOf(this.fFolderPerFolder));
        System.out.println("Depth: " + options.valueOf(this.fDepth));
        System.out.println("Folder Type: " + (String)options.valueOf(this.fFolderType));
        int noThreads = (Integer)options.valueOf(this.fThreads);
        if (noThreads <= 1) {
            this.fillRepository((String)options.valueOf(this.fRepoId), (Integer)options.valueOf(this.fDocsPerFolder), (Integer)options.valueOf(this.fFolderPerFolder), (Integer)options.valueOf(this.fDepth), (String)options.valueOf(this.fDocType), (String)options.valueOf(this.fFolderType), (Integer)options.valueOf(this.fContentSize), (String)options.valueOf(this.fRootFolder), (Boolean)options.valueOf(this.fCleanup));
        } else {
            this.fillRepositoryMT(noThreads, (String)options.valueOf(this.fRepoId), (Integer)options.valueOf(this.fDocsPerFolder), (Integer)options.valueOf(this.fFolderPerFolder), (Integer)options.valueOf(this.fDepth), (String)options.valueOf(this.fDocType), (String)options.valueOf(this.fFolderType), (Integer)options.valueOf(this.fContentSize), (String)options.valueOf(this.fRootFolder), (Boolean)options.valueOf(this.fCleanup));
        }
    }

    private void createFolders(OptionSet options) {
        System.out.println();
        System.out.println("Creating folder with parameters:");
        this.printParameters(options);
        System.out.println("Folder Type: " + (String)options.valueOf(this.fFolderType));
        int noThreads = (Integer)options.valueOf(this.fThreads);
        if (noThreads <= 1) {
            this.createFolders((String)options.valueOf(this.fRepoId), (String)options.valueOf(this.fFolderType), (String)options.valueOf(this.fRootFolder), (Integer)options.valueOf(this.fCount), (Boolean)options.valueOf(this.fCleanup));
        } else {
            this.createFoldersMT(noThreads, (String)options.valueOf(this.fRepoId), (String)options.valueOf(this.fFolderType), (String)options.valueOf(this.fRootFolder), (Integer)options.valueOf(this.fCount), (Boolean)options.valueOf(this.fCleanup));
        }
    }

    private void createSingleDocument(String repoId, String documentType, int contentSizeInKB, String rootFolderId, int docCount, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateDocument(this.getBinding(), repoId, documentType, contentSizeInKB, rootFolderId, docCount, doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        String[] ids = runner.doCreateDocument();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Document creation succeeded.");
        System.out.println("Folder used as root for creation: " + rootFolderId);
        System.out.println("Ids of created documents: ");
        if (null == ids) {
            System.out.println("<none>");
        } else {
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(ids[i]);
            }
        }
        gen.printTimings();
        gen.resetCounters();
    }

    private void createSingleDocumentMT(int noThreads, String repoId, String documentType, int contentSizeInKB, String rootFolderId, int docCount, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateDocumentMT(noThreads, this.getBinding(), repoId, documentType, contentSizeInKB, rootFolderId, docCount, doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded(runners);
        System.out.println("Document creation succeeded. All threads terminated.");
    }

    private void createFolders(String repoId, String folderType, String rootFolderId, int noFolders, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateFolder(this.getBinding(), repoId, folderType, rootFolderId, noFolders, doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        String[] ids = runner.doCreateFolder();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Folder creation succeeded.");
        System.out.println("Ids of created folders: ");
        if (null == ids) {
            System.out.println("<none>");
        } else {
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(ids[i]);
            }
        }
        gen.printTimings();
        gen.resetCounters();
    }

    private void createFoldersMT(int noThreads, String repoId, String folderType, String rootFolderId, int noFolders, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateFolderMT(noThreads, this.getBinding(), repoId, folderType, rootFolderId, noFolders, doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded(runners);
        System.out.println("Folder creation succeeded.");
    }

    private void callRepoInfo(String repositoryId, int count) {
        RepositoryService repSvc = this.getBinding().getRepositoryService();
        TimeLogger timeLogger = new TimeLogger("RepoInfoTest");
        RepositoryInfo repoInfo = null;
        for (int i = 0; i < count; ++i) {
            this.binding.clearRepositoryCache(repositoryId);
            timeLogger.start();
            repoInfo = repSvc.getRepositoryInfo(repositoryId, null);
            timeLogger.stop();
        }
        System.out.println("Root Folder id is: " + (repoInfo == null ? "<unknown>" : repoInfo.getRootFolderId()));
        timeLogger.printTimes();
    }

    private void repositoryInfo(OptionSet options) {
        this.callRepoInfo((String)options.valueOf(this.fRepoId), (Integer)options.valueOf(this.fCount));
    }

    private CmisBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.fUsingAtom ? ObjGenApp.createAtomBinding(ObjGenApp.getAtomPubUrl(), "", "") : ObjGenApp.createWsBinding(ObjGenApp.getWsUrl(), "", "");
        }
        return this.binding;
    }

    private static void filLoginParams(Map<String, String> parameters, String user, String password) {
        if (user != null && user.length() > 0) {
            parameters.put("org.apache.chemistry.opencmis.user", user);
        }
        if (user != null && user.length() > 0) {
            parameters.put("org.apache.chemistry.opencmis.password", password);
        }
    }

    private static CmisBinding createAtomBinding(String url, String user, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ObjGenApp.filLoginParams(parameters, user, password);
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
        CmisBinding binding = factory.createCmisAtomPubBinding(parameters);
        return binding;
    }

    private static CmisBinding createWsBinding(String url, String username, String password) {
        boolean isPrefix = true;
        String urlLower = url.toLowerCase();
        if (urlLower.endsWith("?wsdl")) {
            isPrefix = false;
        } else if (urlLower.endsWith(".wsdl")) {
            isPrefix = false;
        } else if (urlLower.endsWith(".xml")) {
            isPrefix = false;
        }
        return ObjGenApp.createBinding(url, isPrefix, username, password);
    }

    public static CmisBinding createBinding(String url, boolean isPrefix, String username, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", username);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        if (!isPrefix) {
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url);
        } else {
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url + "RepositoryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url + "NavigationService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url + "ObjectService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url + "VersioningService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url + "DiscoveryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url + "RelationshipService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url + "MultiFilingService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url + "PolicyService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url + "ACLService?wsdl");
        }
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisWebServicesBinding(parameters);
        return binding;
    }

    private static String getAtomPubUrl() {
        return System.getProperty(PROP_ATOMPUB_URL, DEFAULT_ATOMPUB_URL);
    }

    private static String getWsUrl() {
        return System.getProperty(PROP_WS_URL, DEFAULT_WS_URL);
    }

    private String getConfiguredUrl() {
        return System.getProperty(PROP_URL, this.fUrlStr);
    }

    private static void getUrl(String urlStr) {
        try {
            String str;
            System.out.println("Reading URL: " + urlStr);
            URL url = new URL(urlStr);
            InputStream is = url.openStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader r = new BufferedReader(isr);
            do {
                if ((str = r.readLine()) == null) continue;
                System.out.println(str);
            } while (str != null);
        }
        catch (MalformedURLException e) {
            System.out.println("Must enter a valid URL" + e);
        }
        catch (IOException e) {
            System.out.println("Can not connect" + e);
        }
    }
}

