/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.io.File;
import java.util.Map;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.AbstractCommand;
import org.nuxeo.connect.update.impl.task.Command;
import org.nuxeo.connect.update.impl.task.UninstallTask;
import org.nuxeo.connect.update.impl.task.commands.Delete;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.FileRef;
import org.nuxeo.connect.update.util.IOUtils;
import org.w3c.dom.Element;

public class Copy
extends AbstractCommand {
    public static final String ID = "copy";
    protected File file;
    protected File tofile;
    protected boolean overwrite;
    protected String md5;

    protected Copy(String id) {
        super(id);
    }

    public Copy() {
        super(ID);
    }

    public Copy(File file, File tofile, String md5, boolean overwrite) {
        this(ID, file, tofile, md5, overwrite);
    }

    protected Copy(String id, File file, File tofile, String md5, boolean overwrite) {
        super(id);
        this.file = file;
        this.tofile = tofile;
        this.md5 = md5;
        this.overwrite = overwrite;
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        String md5 = null;
        File bak = null;
        File dst = null;
        try {
            if (this.tofile.isFile()) {
                if (!this.overwrite) {
                    throw new PackageException("Copy command has override flag on false but destination file exists: " + this.tofile);
                }
                if (!(task instanceof UninstallTask)) {
                    bak = IOUtils.backup(task.getPackage(), this.tofile);
                }
                dst = this.tofile;
            } else if (this.tofile.isDirectory()) {
                dst = new File(this.tofile, this.file.getName());
                if (dst.isFile()) {
                    bak = IOUtils.backup(task.getPackage(), dst);
                }
            } else {
                this.tofile.getParentFile().mkdirs();
                dst = this.tofile;
            }
            String content = this.getContentToCopy(prefs);
            if (content != null) {
                FileUtils.writeFile((File)dst, (String)content);
            } else {
                File tmp = new File(dst.getPath() + "tmp");
                FileUtils.copy((File)this.file, (File)tmp);
                tmp.renameTo(dst);
            }
            md5 = IOUtils.createMd5(dst);
        }
        catch (Exception e) {
            throw new PackageException("Failed to copy " + dst, (Throwable)e);
        }
        if (bak == null) {
            return new Delete(dst, md5);
        }
        return new Copy(bak, dst, md5, true);
    }

    protected String getContentToCopy(Map<String, String> prefs) throws PackageException {
        return null;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.file == null || this.tofile == null) {
            status.addError("Cannot execute command in installer. No file or tofile specified.");
        }
        if (this.tofile.isFile() && !this.overwrite) {
            status.addError("Cannot overwite existing file: " + this.tofile.getName());
        }
        if (this.md5 != null) {
            try {
                if (this.tofile.isFile() && !this.md5.equals(IOUtils.createMd5(this.tofile))) {
                    status.addError("Cannot copy file to: " + this.tofile.getName() + ". The md5 check failed");
                }
            }
            catch (Exception e) {
                throw new PackageException((Throwable)e);
            }
        }
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("file");
        if (v.length() <= 0) {
            throw new PackageException("Invalid copy syntax: file was not specified");
        }
        this.file = new File(v);
        v = element.getAttribute("todir");
        if (v.length() > 0) {
            this.tofile = new File(v, this.file.getName());
            this.guardVars.put("tofile", this.tofile);
        } else {
            v = element.getAttribute("tofile");
            if (v.length() > 0) {
                FileRef ref = FileRef.newFileRef(v);
                this.tofile = ref.getFile();
                this.guardVars.put("tofile", this.tofile);
                ref.fillPatternVariables(this.guardVars);
            }
        }
        v = element.getAttribute("md5");
        if (v.length() > 0) {
            this.md5 = v;
        }
        if ((v = element.getAttribute("overwrite")).length() > 0) {
            this.overwrite = Boolean.parseBoolean(v);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        if (this.tofile != null) {
            writer.attr("tofile", this.tofile.getAbsolutePath());
        }
        writer.attr("overwrite", String.valueOf(this.overwrite));
        if (this.md5 != null) {
            writer.attr("md5", this.md5);
        }
        writer.end();
    }
}

