/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import com.sun.star.uno.RuntimeException;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.document.DefaultDocumentFormatRegistry;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.artofsolving.jodconverter.document.DocumentFormatRegistry;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.ecm.platform.convert.ooomanager.OOoManagerService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;

public class JODBasedConverter
implements ExternalConverter {
    protected static final String TMP_PATH_PARAMETER = "TmpDirectory";
    private static final Log log = LogFactory.getLog(JODBasedConverter.class);
    private static final DocumentFormatRegistry formatRegistry = new DefaultDocumentFormatRegistry();
    protected ConverterDescriptor descriptor;

    protected String getDestinationMimeType() {
        return this.descriptor.getDestinationMimeType();
    }

    private DocumentFormat getDestinationFormat() {
        return formatRegistry.getFormatByMediaType(this.getDestinationMimeType());
    }

    private static DocumentFormat getSourceFormat(File file) throws Exception {
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetypeStr = mimetypeRegistry.getMimetypeFromFile(file);
        DocumentFormat format = formatRegistry.getFormatByMediaType(mimetypeStr);
        return format;
    }

    private static DocumentFormat getSourceFormat(String mimetype) {
        return formatRegistry.getFormatByMediaType(mimetype);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private static boolean adaptFilterNameForHTML2PDF(DocumentFormat sourceFormat, DocumentFormat destinationFormat) {
        if ("text/html".equals(sourceFormat.getMediaType()) && "application/pdf".equals(destinationFormat.getMediaType())) {
            DocumentFamily family = sourceFormat.getInputFamily();
            HashMap<String, String> storeProperties = new HashMap<String, String>();
            storeProperties.put("FilterName", "writer_web_pdf_Export");
            destinationFormat.setStoreProperties(family, storeProperties);
            return true;
        }
        return false;
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        OfficeDocumentConverter documentConverter;
        Blob inputBlob;
        try {
            inputBlob = blobHolder.getBlob();
            OOoManagerService oooManagerService = (OOoManagerService)Framework.getService(OOoManagerService.class);
            documentConverter = oooManagerService.getDocumentConverter();
        }
        catch (Exception e) {
            throw new ConversionException("Error while getting Blob", e);
        }
        if (inputBlob == null) {
            return null;
        }
        String sourceMimetype = inputBlob.getMimeType();
        if (documentConverter != null) {
            File sourceFile = null;
            File outFile = null;
            File[] files = null;
            try {
                String ext = inputBlob.getFilename();
                int dotPosition = ext.lastIndexOf(46);
                ext = dotPosition == -1 ? ".bin" : ext.substring(dotPosition);
                sourceFile = File.createTempFile("NXJOOoConverterDocumentIn", ext);
                InputStream stream = inputBlob.getStream();
                FileUtils.copyToFile((InputStream)stream, (File)sourceFile);
                DocumentFormat sourceFormat = null;
                if (sourceMimetype != null) {
                    sourceFormat = JODBasedConverter.getSourceFormat(sourceMimetype);
                }
                if (sourceFormat == null) {
                    sourceFormat = JODBasedConverter.getSourceFormat(sourceFile);
                }
                DocumentFormat destinationFormat = this.getDestinationFormat();
                ArrayList<StreamingBlob> blobs = new ArrayList<StreamingBlob>();
                if (this.descriptor.getDestinationMimeType().equals("text/html")) {
                    String tmpDirPath = this.getTmpDirectory();
                    File myTmpDir = new File(tmpDirPath + "/JODConv_" + System.currentTimeMillis());
                    boolean created = myTmpDir.mkdir();
                    if (!created) {
                        throw new ConversionException("Unable to create temp dir");
                    }
                    outFile = new File(myTmpDir.getAbsolutePath() + "/" + "NXJOOoConverterDocumentOut." + destinationFormat.getExtension());
                    created = outFile.createNewFile();
                    if (!created) {
                        throw new ConversionException("Unable to create temp file");
                    }
                    log.debug((Object)"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
                    log.debug((Object)("Input File = " + outFile.getAbsolutePath()));
                    documentConverter.convert(sourceFile, outFile, destinationFormat);
                    for (File file : files = myTmpDir.listFiles()) {
                        StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])new FileSource(file).getBytes());
                        if (file.getName().equals(outFile.getName())) {
                            blob.setFilename("index.html");
                            blobs.add(0, blob);
                            continue;
                        }
                        blob.setFilename(file.getName());
                        blobs.add(blob);
                    }
                } else {
                    JODBasedConverter.adaptFilterNameForHTML2PDF(sourceFormat, destinationFormat);
                    outFile = File.createTempFile("NXJOOoConverterDocumentOut", '.' + destinationFormat.getExtension());
                    documentConverter.convert(sourceFile, outFile, destinationFormat);
                    StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])new FileSource(outFile).getBytes(), (String)this.getDestinationMimeType());
                    blobs.add(blob);
                }
                SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder(blobs);
                return simpleCachableBlobHolder;
            }
            catch (Exception e) {
                log.error((Object)String.format("An error occurred trying to convert a file to from %s to %s: %s", sourceMimetype, this.getDestinationMimeType(), e.getMessage()), (Throwable)e);
                throw new ConversionException("Error in JODConverter", e);
            }
            finally {
                if (sourceFile != null) {
                    sourceFile.delete();
                }
                if (outFile != null) {
                    outFile.delete();
                }
                if (files != null) {
                    for (void var27_31 : files) {
                        if (!var27_31.exists()) continue;
                        var27_31.delete();
                    }
                }
            }
        }
        throw new ConversionException("Could not connect to the remote OpenOffice server");
    }

    public void init(ConverterDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ConverterCheckResult isConverterAvailable() {
        ConverterCheckResult result = new ConverterCheckResult();
        try {
            OOoManagerService oooManagerService = (OOoManagerService)Framework.getService(OOoManagerService.class);
            if (!oooManagerService.isOOoManagerStarted()) {
                result.setAvailable(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get OOoManagerService");
        }
        return result;
    }

    protected String getTmpDirectory() {
        String tmp = null;
        Map parameters = this.descriptor.getParameters();
        if (parameters != null && parameters.containsKey(TMP_PATH_PARAMETER)) {
            tmp = (String)parameters.get(TMP_PATH_PARAMETER);
        }
        if (tmp == null) {
            tmp = System.getProperty("java.io.tmpdir");
        }
        return tmp;
    }
}

