/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.InvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;

public class CachingRowMapper
implements RowMapper {
    private static final String ABSENT = "__ABSENT__\u0000\u0000\u0000";
    private final Map<RowId, Row> cache;
    private final RowMapper rowMapper;
    private final Invalidations localInvalidations;
    private final InvalidationsQueue cacheQueue;
    private final InvalidationsPropagator cachePropagator;
    private InvalidationsQueue eventQueue;
    private final InvalidationsPropagator eventPropagator;
    private SessionImpl session;
    protected boolean forRemoteClient;

    public CachingRowMapper(RowMapper rowMapper, InvalidationsPropagator cachePropagator, InvalidationsPropagator eventPropagator, InvalidationsQueue repositoryEventQueue) {
        this.rowMapper = rowMapper;
        this.cache = new ReferenceMap(0, 1);
        this.localInvalidations = new Invalidations();
        this.cacheQueue = new InvalidationsQueue("mapper-" + this);
        this.cachePropagator = cachePropagator;
        cachePropagator.addQueue(this.cacheQueue);
        this.eventQueue = repositoryEventQueue;
        this.eventPropagator = eventPropagator;
        eventPropagator.addQueue(repositoryEventQueue);
        this.forRemoteClient = false;
    }

    public void close() throws StorageException {
        this.cachePropagator.removeQueue(this.cacheQueue);
        this.eventPropagator.removeQueue(this.eventQueue);
    }

    protected static boolean isAbsent(Row row) {
        return row.tableName == ABSENT;
    }

    protected void cachePut(Row row) {
        if ((row = row.clone()).isCollection() && row.values.length > 0 && row.values[0] instanceof ACLRow) {
            row.values = this.sortACLRows((ACLRow[])row.values);
        }
        this.cache.put(new RowId(row), row);
    }

    protected ACLRow[] sortACLRows(ACLRow[] acls) {
        ArrayList<ACLRow> list = new ArrayList<ACLRow>(Arrays.asList(acls));
        Collections.sort(list, ACLRow.ACLRowPositionComparator.INSTANCE);
        ACLRow[] res = new ACLRow[acls.length];
        return list.toArray(res);
    }

    protected void cachePutAbsent(RowId rowId) {
        this.cache.put(new RowId(rowId), new Row(ABSENT, (Serializable)null));
    }

    protected void cachePutAbsentIfNull(RowId rowId, Row row) {
        if (row != null) {
            this.cachePut(row);
        } else {
            this.cachePutAbsent(rowId);
        }
    }

    protected void cachePutAbsentIfRowId(RowId rowId) {
        if (rowId instanceof Row) {
            this.cachePut((Row)rowId);
        } else {
            this.cachePutAbsent(rowId);
        }
    }

    protected Row cacheGet(RowId rowId) {
        Row row = this.cache.get(rowId);
        if (row != null && !CachingRowMapper.isAbsent(row)) {
            row = row.clone();
        }
        return row;
    }

    protected void cacheRemove(RowId rowId) {
        this.cache.remove(rowId);
    }

    @Override
    public Invalidations.InvalidationsPair receiveInvalidations() throws StorageException {
        Invalidations.InvalidationsPair invals = this.rowMapper.receiveInvalidations();
        Invalidations invalidations = this.cacheQueue.getInvalidations();
        if (invals != null) {
            invalidations.add(invals.cacheInvalidations);
        }
        Invalidations events = this.eventQueue.getInvalidations();
        if (invals != null) {
            events.add(invals.eventInvalidations);
        }
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                this.cacheRemove(rowId);
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                this.cachePutAbsent(rowId);
            }
        }
        if (invalidations.isEmpty() && events.isEmpty()) {
            return null;
        }
        return new Invalidations.InvalidationsPair(invalidations.isEmpty() ? null : invalidations, events.isEmpty() ? null : events);
    }

    @Override
    public void sendInvalidations(Invalidations invalidations) throws StorageException {
        if (!this.localInvalidations.isEmpty()) {
            if (invalidations == null) {
                invalidations = new Invalidations();
            }
            invalidations.add(this.localInvalidations);
            this.localInvalidations.clear();
        }
        if (invalidations != null && !invalidations.isEmpty()) {
            this.rowMapper.sendInvalidations(invalidations);
            this.cachePropagator.propagateInvalidations(invalidations, this.cacheQueue);
            this.eventPropagator.propagateInvalidations(invalidations, this.eventQueue);
            if (!this.forRemoteClient) {
                this.session.sendInvalidationEvent(invalidations, true);
            }
        }
    }

    public void setEventQueue(InvalidationsQueue eventQueue) {
        this.eventQueue = eventQueue;
        this.eventPropagator.addQueue(eventQueue);
        this.forRemoteClient = true;
    }

    protected void setSession(SessionImpl session) {
        this.session = session;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
        this.localInvalidations.clear();
        this.rowMapper.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.rowMapper.rollback(xid);
        }
        finally {
            this.cache.clear();
            this.localInvalidations.clear();
        }
    }

    @Override
    public List<? extends RowId> read(Collection<RowId> rowIds) throws StorageException {
        ArrayList<? extends RowId> res = new ArrayList<RowId>(rowIds.size());
        LinkedList<RowId> todo = new LinkedList<RowId>();
        for (RowId rowId : rowIds) {
            Row row = this.cacheGet(rowId);
            if (row == null) {
                todo.add(rowId);
                continue;
            }
            if (CachingRowMapper.isAbsent(row)) {
                res.add(new RowId(rowId));
                continue;
            }
            res.add(row);
        }
        List<? extends RowId> fetched = this.rowMapper.read(todo);
        for (RowId rowId : fetched) {
            this.cachePutAbsentIfRowId(rowId);
        }
        res.addAll(fetched);
        return res;
    }

    @Override
    public void write(RowMapper.RowBatch batch) throws StorageException {
        for (Row row : batch.creates) {
            this.cachePut(row);
            if ("fulltext".equals(row.tableName)) continue;
            this.localInvalidations.addModified(new RowId(row));
        }
        for (RowMapper.RowUpdate rowu : batch.updates) {
            this.cachePut(rowu.row);
            if ("fulltext".equals(rowu.row.tableName)) continue;
            this.localInvalidations.addModified(new RowId(rowu.row));
        }
        for (RowId rowId : batch.deletes) {
            if (rowId instanceof Row) {
                throw new AssertionError();
            }
            this.cachePutAbsent(rowId);
            if ("fulltext".equals(rowId.tableName)) continue;
            this.localInvalidations.addDeleted(rowId);
        }
        this.rowMapper.write(batch);
    }

    @Override
    public Row readSimpleRow(RowId rowId) throws StorageException {
        Row row = this.cacheGet(rowId);
        if (row == null) {
            row = this.rowMapper.readSimpleRow(rowId);
            this.cachePutAbsentIfNull(rowId, row);
            return row;
        }
        if (CachingRowMapper.isAbsent(row)) {
            return null;
        }
        return row;
    }

    @Override
    public Serializable[] readCollectionRowArray(RowId rowId) throws StorageException {
        Row row = this.cacheGet(rowId);
        if (row == null) {
            Serializable[] array = this.rowMapper.readCollectionRowArray(rowId);
            assert (array != null);
            row = new Row(rowId.tableName, rowId.id, array);
            this.cachePut(row);
            return row.values;
        }
        if (CachingRowMapper.isAbsent(row)) {
            return null;
        }
        return row.values;
    }

    @Override
    public Row readChildHierRow(Serializable parentId, String childName, boolean complexProp) throws StorageException {
        Row row = this.rowMapper.readChildHierRow(parentId, childName, complexProp);
        if (row != null) {
            this.cachePut(row);
        }
        return row;
    }

    @Override
    public List<Row> readChildHierRows(Serializable parentId, boolean complexProp) throws StorageException {
        List<Row> rows = this.rowMapper.readChildHierRows(parentId, complexProp);
        for (Row row : rows) {
            this.cachePut(row);
        }
        return rows;
    }

    @Override
    public List<Row> getVersionRows(Serializable versionableId) throws StorageException {
        List<Row> rows = this.rowMapper.getVersionRows(versionableId);
        for (Row row : rows) {
            this.cachePut(row);
        }
        return rows;
    }

    @Override
    public List<Row> getProxyRows(Serializable searchId, boolean byTarget, Serializable parentId) throws StorageException {
        List<Row> rows = this.rowMapper.getProxyRows(searchId, byTarget, parentId);
        for (Row row : rows) {
            this.cachePut(row);
        }
        return rows;
    }

    @Override
    public RowMapper.CopyHierarchyResult copyHierarchy(RowMapper.IdWithTypes source, Serializable destParentId, String destName, Row overwriteRow) throws StorageException {
        RowMapper.CopyHierarchyResult result = this.rowMapper.copyHierarchy(source, destParentId, destName, overwriteRow);
        Invalidations invalidations = result.invalidations;
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                this.cacheRemove(rowId);
                this.localInvalidations.addModified(new RowId(rowId));
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                this.cacheRemove(rowId);
                this.localInvalidations.addDeleted(rowId);
            }
        }
        return result;
    }
}

