/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseDelegateLoader;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassLoadingTask {
    protected static Logger log = Logger.getLogger((String)"org.jboss.detailed.classloader.ClassLoadingTask");
    private String className;
    private Thread requestingThread;
    private ClassLoader classLoader;
    private Class<?> loadedClass;
    private Throwable loadException;
    private int threadTaskCount;
    private TaskState state;
    private boolean trace = log.isTraceEnabled();
    private int numCCE;

    ClassLoadingTask(String className, ClassLoader classLoader, Thread requestingThread) {
        this.className = className;
        this.requestingThread = requestingThread;
        this.classLoader = classLoader;
    }

    String getClassName() {
        return this.className;
    }

    synchronized Class<?> getLoadedClass() {
        return this.loadedClass;
    }

    synchronized Throwable getLoadException() {
        return this.loadException;
    }

    synchronized int incrementNumCCE() {
        return this.numCCE;
    }

    Thread getRequestingThread() {
        return this.requestingThread;
    }

    synchronized TaskState getState() {
        return this.state;
    }

    synchronized void finish(Class<?> loadedClass) {
        this.loadedClass = loadedClass;
        this.state = TaskState.FINISHED;
    }

    synchronized void foundClassLoader() {
        this.state = TaskState.FOUND_CLASS_LOADER;
    }

    synchronized void finish() {
        this.state = TaskState.FINISHED;
    }

    synchronized void waitOnEvent() {
        this.state = TaskState.WAIT_EVENT;
    }

    synchronized void nextEvent() {
        this.state = TaskState.NEXT_EVENT;
    }

    synchronized int getThreadTaskCount() {
        return this.threadTaskCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        builder.append('{');
        builder.append("className=").append(this.className);
        builder.append(" requestingThread=").append(this.requestingThread);
        builder.append(" requestingClassLoader: ").append(this.classLoader);
        if (this.loadedClass != null) {
            builder.append(" loadedClass=");
            ClassLoaderUtils.classToString(this.loadedClass, builder);
        }
        if (this.loadException != null) {
            builder.append(" loadException: ").append(this.loadException);
        }
        builder.append(" threadTaskCount: ").append(this.threadTaskCount);
        builder.append(" state: ").append((Object)this.state);
        if (this.numCCE > 0) {
            builder.append(", #CCE: ").append(this.numCCE);
        }
        builder.append('}');
        if (this.trace && this.loadException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.loadException.printStackTrace(pw);
            builder.append("loadException details:\n");
            builder.append(sw.toString());
        }
        return builder.toString();
    }

    synchronized ThreadTask newThreadTask(Loader loader, Thread thread, boolean reschedule, boolean releaseInNextTask) {
        if (!reschedule) {
            ++this.threadTaskCount;
        }
        return new ThreadTask(loader, thread, releaseInNextTask);
    }

    synchronized void setLoadError(Throwable t) {
        --this.threadTaskCount;
        if (this.trace) {
            log.trace((Object)("setLoadedError, error=" + t));
        }
        this.loadException = t;
    }

    private synchronized void setLoadedClass(Class<?> theClass) {
        --this.threadTaskCount;
        if (this.trace) {
            log.trace((Object)("setLoadedClass, theClass=" + theClass));
        }
        if (this.loadedClass != null && theClass != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Duplicate class found: ").append(this.className).append('\n');
            ProtectionDomain pd = ClassLoadingTask.getProtectionDomain(this.loadedClass);
            CodeSource cs = pd != null ? pd.getCodeSource() : null;
            builder.append("Current CS: ").append(cs).append('\n');
            pd = ClassLoadingTask.getProtectionDomain(theClass);
            cs = pd != null ? pd.getCodeSource() : null;
            builder.append("Duplicate CS: ").append(cs);
            log.warn((Object)builder.toString());
        }
        if (theClass != null && this.loadedClass == null) {
            this.loadedClass = theClass;
        }
    }

    private static final ProtectionDomain getProtectionDomain(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getProtectionDomain();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ThreadTask {
        private Loader loader;
        private Thread thread;
        private boolean releaseInNextTask;

        ThreadTask(Loader loader, Thread thread, boolean releaseInNextTask) {
            this.loader = loader;
            this.thread = thread;
            this.releaseInNextTask = releaseInNextTask;
        }

        String getClassName() {
            return ClassLoadingTask.this.className;
        }

        Class<?> getLoadedClass() {
            return ClassLoadingTask.this.loadedClass;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{thread=").append(this.thread);
            builder.append(" loader=").append(this.loader);
            builder.append(" requestingThread=").append(ClassLoadingTask.this.requestingThread);
            builder.append(" releaseInNextTask=").append(this.releaseInNextTask);
            builder.append("}");
            return builder.toString();
        }

        ClassLoadingTask getLoadTask() {
            return ClassLoadingTask.this;
        }

        Loader getLoader() {
            return this.loader;
        }

        BaseClassLoader getClassLoader() {
            if (this.loader instanceof BaseDelegateLoader) {
                BaseDelegateLoader delegateLoader = (BaseDelegateLoader)this.loader;
                BaseClassLoaderPolicy policy = delegateLoader.getPolicy();
                if (policy == null) {
                    throw new IllegalStateException("Null classloader policy for " + this.loader);
                }
                return policy.getClassLoader();
            }
            return null;
        }

        synchronized Thread getThread() {
            return this.thread;
        }

        synchronized void setThread(Thread thread) {
            this.thread = thread;
        }

        boolean isReleaseInNextTask() {
            return this.releaseInNextTask;
        }

        void run() throws ClassNotFoundException {
            if (ClassLoadingTask.this.loadedClass == null) {
                Class<?> theClass = this.loader.loadClass(ClassLoadingTask.this.className);
                ClassLoadingTask.this.setLoadedClass(theClass);
            } else if (ClassLoadingTask.this.trace) {
                log.trace((Object)("Already found class(" + ClassLoadingTask.this.loadedClass + "), skipping load class"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TaskState {
        FOUND_CLASS_LOADER,
        NEXT_EVENT,
        WAIT_EVENT,
        FINISHED;

    }
}

