/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.ejb.Remove;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.cache.ThreadSafeCacheHolder;
import org.nuxeo.ecm.webapp.action.ConversionAction;
import org.nuxeo.runtime.api.Framework;

@Name(value="conversionActions")
@Scope(value=ScopeType.EVENT)
public class ConversionActionBean
implements ConversionAction {
    private static final Log log = LogFactory.getLog(ConversionActionBean.class);
    protected static ConverterCheckResult any2PDFAvailability;
    protected static final String PDF_PREVIEW_CONVERTER = "any2pdf";
    @In(create=true, required=false)
    CoreSession documentManager;
    @In(create=true)
    NavigationContext navigationContext;
    @RequestParameter
    private String docRef;
    @RequestParameter
    private String fileFieldFullName;
    @RequestParameter
    private String filename;
    protected static final ThreadSafeCacheHolder<Boolean> exportableToPDFCache;

    @Remove
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    public String display() {
        return "view_file";
    }

    private DocumentModel getDocument() throws ClientException {
        if (this.docRef == null) {
            return this.navigationContext.getCurrentDocument();
        }
        return this.documentManager.getDocument((DocumentRef)new IdRef(this.docRef));
    }

    private String getMimetypeFromDocument(String propertyName) throws ClientException {
        Blob blob = (Blob)this.getDocument().getPropertyValue(propertyName);
        return blob.getMimeType();
    }

    @Override
    public void reCheckConverterAvailability() {
        any2PDFAvailability = null;
    }

    @Override
    public ConverterCheckResult getPdfConverterAvailability() throws Exception {
        if (any2PDFAvailability == null) {
            ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
            any2PDFAvailability = cs.isConverterAvailable(PDF_PREVIEW_CONVERTER, true);
        }
        return any2PDFAvailability;
    }

    public boolean isExportableToPDF(BlobHolder bh) throws ClientException {
        if (bh == null) {
            return false;
        }
        Blob blob = bh.getBlob();
        if (blob == null) {
            return false;
        }
        return this.isExportableToPDF(blob);
    }

    @Override
    public boolean isExportableToPDF(Blob blob) {
        if (blob == null) {
            return false;
        }
        String mimetype = blob.getMimeType();
        return this.isMimeTypeExportableToPDF(mimetype);
    }

    protected boolean isMimeTypeExportableToPDF(String mimetype) {
        if (mimetype == null) {
            return false;
        }
        try {
            ConverterCheckResult availability = this.getPdfConverterAvailability();
            if (!availability.isAvailable()) {
                return false;
            }
            return availability.getSupportedInputMimeTypes().contains(mimetype);
        }
        catch (Exception e) {
            log.error((Object)"Error while testing PDF converter availability", (Throwable)e);
            return false;
        }
    }

    @Override
    @WebRemote
    public boolean isFileExportableToPDF(String fieldName) {
        try {
            boolean isSupported;
            DocumentModel doc = this.getDocument();
            Boolean cacheResult = (Boolean)exportableToPDFCache.getFromCache(doc, fieldName);
            if (cacheResult == null) {
                String mimetype = this.getMimetypeFromDocument(fieldName);
                isSupported = this.isMimeTypeExportableToPDF(mimetype);
                exportableToPDFCache.addToCache(doc, fieldName, (Serializable)Boolean.valueOf(isSupported));
            } else {
                isSupported = cacheResult;
            }
            return isSupported;
        }
        catch (Exception e) {
            log.error((Object)"Error while trying to check PDF conversion against a filename", (Throwable)e);
            return false;
        }
    }

    public String generatePdfFileFromBlobHolder(BlobHolder bh) {
        try {
            int n;
            ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
            BlobHolder result = cs.convert(PDF_PREVIEW_CONVERTER, bh, null);
            String fname = new Path(bh.getFilePath()).lastSegment();
            String name = fname == null || fname.length() == 0 ? "file" : fname;
            int pos = name.lastIndexOf(46);
            if (pos <= 0) {
                name = name + ".pdf";
            } else {
                String sub = name.substring(pos + 1);
                name = name.replace(sub, "pdf");
            }
            if (result == null) {
                log.error((Object)"Transform service didn't return any resulting documents which is not normal.");
                return "pdf_generation_error";
            }
            InputStream inputStream = result.getBlob().getStream();
            int length = inputStream.available();
            byte[] array = new byte[length];
            int offset = 0;
            while ((n = inputStream.read(array, offset, length - offset)) != -1) {
            }
            String headerContent = "attachment; filename=\"" + name + "\";";
            ConversionActionBean.writeResponse("Content-Disposition", headerContent, "application/pdf", array);
            return null;
        }
        catch (Exception e) {
            log.error((Object)("PDF generation error for file " + this.filename), (Throwable)e);
            return "pdf_generation_error";
        }
    }

    @Override
    @WebRemote
    public String generatePdfFile() {
        try {
            DocumentBlobHolder bh = new DocumentBlobHolder(this.getDocument(), this.fileFieldFullName);
            return this.generatePdfFileFromBlobHolder((BlobHolder)bh);
        }
        catch (Exception e) {
            log.error((Object)("PDF generation error for file " + this.filename), (Throwable)e);
            return "pdf_generation_error";
        }
    }

    private static void writeResponse(String header, String headerContent, String contentType, byte[] value) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setHeader(header, headerContent);
        response.setContentType(contentType);
        response.getOutputStream().write(value);
        context.responseComplete();
    }

    public void initialize() {
    }

    static {
        exportableToPDFCache = new ThreadSafeCacheHolder(20);
    }
}

