/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.editor.Editor;
import org.nuxeo.theme.editor.FieldProperty;
import org.nuxeo.theme.editor.PaddingInfo;
import org.nuxeo.theme.editor.PageInfo;
import org.nuxeo.theme.editor.SessionManager;
import org.nuxeo.theme.editor.StyleFieldProperty;
import org.nuxeo.theme.editor.StyleLayer;
import org.nuxeo.theme.editor.ThemeEditorException;
import org.nuxeo.theme.editor.ThemeInfo;
import org.nuxeo.theme.editor.UndoBuffer;
import org.nuxeo.theme.editor.Utils;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.PageElement;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.formats.layouts.Layout;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.formats.widgets.Widget;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentType;
import org.nuxeo.theme.html.CSSUtils;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.presets.PresetManager;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.resources.ImageInfo;
import org.nuxeo.theme.resources.ResourceBank;
import org.nuxeo.theme.resources.SkinInfo;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeIOException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.themes.ThemeSerializer;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.views.ViewType;

@Path(value="/nxthemes-editor")
@WebObject(type="nxthemes-editor", administrator=Access.GRANT)
@Produces(value={"text/html"})
public class Main
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(Main.class);

    @GET
    @Path(value="perspectiveSelector")
    public Object renderPerspectiveSelector(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("perspectiveSelector.ftl").arg("perspectives", Main.getPerspectives());
    }

    @GET
    @Path(value="themeSelector")
    public Object renderThemeSelector(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("themeSelector.ftl").arg("current_theme_name", (Object)Main.getCurrentThemeName(path, name)).arg("themes", Main.getWorkspaceThemes(path, name));
    }

    @GET
    @Path(value="pageSelector")
    public Object renderPageSelector(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("pageSelector.ftl").arg("current_theme_name", (Object)Main.getCurrentThemeName(path, name)).arg("pages", Main.getPages(path, name));
    }

    @GET
    @Path(value="canvasModeSelector")
    public Object renderCanvasModeSelector(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("canvasModeSelector.ftl");
    }

    @GET
    @Path(value="themeOptions")
    public Object renderThemeOptions(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDef = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        return this.getTemplate("themeOptions.ftl").arg("current_theme", (Object)currentThemeDef);
    }

    @GET
    @Path(value="presetManager")
    public Object renderPresetManager(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("presetManager.ftl").arg("current_theme_name", (Object)Main.getCurrentThemeName(path, name)).arg("preset_manager_mode", (Object)Main.getPresetManagerMode()).arg("selected_preset_category", (Object)Main.getSelectedPresetCategory()).arg("preset_groups", Main.getPresetGroupsForSelectedCategory()).arg("selected_preset_group", (Object)Main.getSelectedPresetGroup());
    }

    @GET
    @Path(value="styleManager")
    public Object renderStyleManager(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        Style selectedStyle;
        ResourceBank resourceBank;
        String currentThemeName = Main.getCurrentThemeName(path, name);
        List<Style> styles = Editor.getNamedStyles(currentThemeName, resourceBank = this.getCurrentThemeBank(currentThemeName));
        if (!styles.contains(selectedStyle = Main.getSelectedNamedStyle()) && !styles.isEmpty()) {
            selectedStyle = styles.get(0);
        }
        ArrayList<Style> rootStyles = new ArrayList<Style>();
        for (Style style : styles) {
            if (ThemeManager.getAncestorFormatOf((Format)style) != null) continue;
            rootStyles.add(style);
        }
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDef = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        return this.getTemplate("styleManager.ftl").arg("current_theme", (Object)currentThemeDef).arg("named_styles", styles).arg("style_manager_mode", (Object)Main.getStyleManagerMode()).arg("selected_named_style", (Object)selectedStyle).arg("selected_named_style_css", (Object)Main.getRenderedPropertiesForNamedStyle(selectedStyle)).arg("current_theme_name", (Object)currentThemeName).arg("page_styles", Editor.getPageStyles(currentThemeName)).arg("root_styles", rootStyles);
    }

    @GET
    @Path(value="themeActions")
    public Object renderThemeActions(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String templateEngine = Main.getTemplateEngine(path);
        String currentPagePath = Main.getCurrentPagePath(path, name);
        String currentpageName = ThemeManager.getPageNameFromPagePath((String)currentPagePath);
        ThemeDescriptor currentThemeDef = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        return this.getTemplate("themeActions.ftl").arg("theme", (Object)currentThemeDef).arg("current_page_path", (Object)currentPagePath).arg("current_page_name", (Object)currentpageName);
    }

    @GET
    @Path(value="dashboardActions")
    public Object renderDashboardActions(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDef = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        return this.getTemplate("dashboardActions.ftl").arg("theme", (Object)currentThemeDef);
    }

    @GET
    @Path(value="editorActions")
    public Object renderEditorActions(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("editorActions.ftl");
    }

    @GET
    @Path(value="cssEditor")
    public Object renderCssEditor(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        ResourceBank currentThemeBank = this.getCurrentThemeBank(currentThemeName);
        List<Style> styles = Editor.getNamedStyles(currentThemeName, currentThemeBank);
        Style themeSkin = Editor.getThemeSkin(currentThemeName);
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDef = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        return this.getTemplate("cssEditor.ftl").arg("theme", (Object)currentThemeDef).arg("named_styles", styles).arg("style_manager_mode", (Object)Main.getStyleManagerMode()).arg("theme_skin", (Object)themeSkin).arg("theme_skin_css", (Object)Main.getRenderedPropertiesForNamedStyle(themeSkin)).arg("current_theme_name", (Object)currentThemeName).arg("current_bank", (Object)currentThemeBank).arg("current_theme", (Object)currentThemeDef);
    }

    @GET
    @Path(value="themeBrowser")
    public Object renderThemeBrowser(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        LinkedHashSet<ThemeDescriptor> availableThemes = new LinkedHashSet<ThemeDescriptor>();
        Set<ThemeInfo> workspaceThemes = Main.getWorkspaceThemes(path, name);
        Set<String> workspaceThemeNames = SessionManager.getWorkspaceThemeNames();
        String templateEngine = Main.getTemplateEngine(path);
        for (ThemeDescriptor themeDef : ThemeManager.getThemeDescriptors()) {
            List templateEngines;
            if (themeDef.isCustomized() || (templateEngines = themeDef.getTemplateEngines()) != null && !templateEngines.contains(templateEngine) || workspaceThemeNames.contains(themeDef.getName())) continue;
            availableThemes.add(themeDef);
        }
        return this.getTemplate("themeBrowser.ftl").arg("current_theme_name", (Object)currentThemeName).arg("available_themes", availableThemes).arg("workspace_themes", workspaceThemes);
    }

    @GET
    @Path(value="viewModes")
    public Object renderViewModes(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("viewModes.ftl");
    }

    @GET
    @Path(value="undoActions")
    public Object renderUndoActions(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String themeName = Main.getCurrentThemeName(path, name);
        UndoBuffer undoBuffer = SessionManager.getUndoBuffer(themeName);
        return this.getTemplate("undoActions.ftl").arg("current_theme_name", (Object)themeName).arg("undo_buffer", (Object)undoBuffer);
    }

    @GET
    @Path(value="fragmentFactory")
    public Object renderFragmentFactory(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String fragmentType = Main.getSelectedFragmentType();
        String fragmentView = Main.getSelectedFragmentView();
        String fragmentStyle = Main.getSelectedFragmentStyle();
        String templateEngine = Main.getTemplateEngine(path);
        ResourceBank resourceBank = this.getCurrentThemeBank(currentThemeName);
        return this.getTemplate("fragmentFactory.ftl").arg("current_theme_name", (Object)Main.getCurrentThemeName(path, name)).arg("selected_fragment_type", (Object)fragmentType).arg("selected_fragment_view", (Object)fragmentView).arg("selected_fragment_style", (Object)fragmentStyle).arg("fragments", Editor.getFragments(templateEngine)).arg("styles", Editor.getNamedStyles(currentThemeName, resourceBank)).arg("views", Editor.getViews(fragmentType, templateEngine)).arg("selected_element_id", (Object)Main.getSelectedElementId());
    }

    @GET
    @Path(value="elementEditor")
    public Object renderElementEditor(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("elementEditor.ftl").arg("selected_element", (Object)Main.getSelectedElement());
    }

    @GET
    @Path(value="elementDescription")
    public Object renderElementDescription(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("elementDescription.ftl").arg("selected_element", (Object)Main.getSelectedElement());
    }

    @GET
    @Path(value="elementPadding")
    public Object renderElementPadding(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("elementPadding.ftl").arg("selected_element", (Object)Main.getSelectedElement()).arg("padding_of_selected_element", (Object)Main.getPaddingOfSelectedElement());
    }

    @GET
    @Path(value="elementProperties")
    public Object renderElementProperties(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("elementProperties.ftl").arg("selected_element", (Object)Main.getSelectedElement()).arg("element_properties", Main.getSelectedElementProperties());
    }

    @GET
    @Path(value="elementStyle")
    public Object renderElementStyle(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        ResourceBank resourceBank = this.getCurrentThemeBank(currentThemeName);
        return this.getTemplate("elementStyle.ftl").arg("selected_element", (Object)Main.getSelectedElement()).arg("style_of_selected_element", (Object)Main.getStyleOfSelectedElement()).arg("current_theme_name", (Object)Main.getCurrentThemeName(path, name)).arg("style_layers_of_selected_element", Main.getStyleLayersOfSelectedElement()).arg("inherited_style_name_of_selected_element", (Object)Main.getInheritedStyleNameOfSelectedElement()).arg("named_styles", Editor.getNamedStyles(currentThemeName, resourceBank));
    }

    @GET
    @Path(value="elementWidget")
    public Object renderElementWidget(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("elementWidget.ftl").arg("selected_element", (Object)Main.getSelectedElement()).arg("selected_view_name", (Object)Main.getViewNameOfSelectedElement()).arg("view_names_for_selected_element", Main.getViewNamesForSelectedElement(path));
    }

    @GET
    @Path(value="elementVisibility")
    public Object renderElementVisibility(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("elementVisibility.ftl").arg("selected_element", (Object)Main.getSelectedElement()).arg("perspectives_of_selected_element", Main.getPerspectivesOfSelectedElement()).arg("is_selected_element_always_visible", (Object)Main.isSelectedElementAlwaysVisible()).arg("perspectives", Main.getPerspectives());
    }

    @GET
    @Path(value="stylePicker")
    public Object renderStylePicker(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        ResourceBank resourceBank = this.getCurrentThemeBank(currentThemeName);
        return this.getTemplate("stylePicker.ftl").arg("resource_bank", (Object)resourceBank).arg("style_category", (Object)Main.getSelectedStyleCategory()).arg("current_theme_name", (Object)Main.getCurrentThemeName(path, name)).arg("selected_preset_group", (Object)Main.getSelectedPresetGroup()).arg("preset_groups", Main.getPresetGroupsForSelectedCategory()).arg("presets_for_selected_group", this.getPresetsForSelectedGroup(path, name));
    }

    @GET
    @Path(value="areaStyleChooser")
    public Object renderAreaStyleChooser(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        ResourceBank resourceBank = this.getCurrentThemeBank(currentThemeName);
        return this.getTemplate("areaStyleChooser.ftl").arg("resource_bank", (Object)resourceBank).arg("style_category", (Object)Main.getSelectedStyleCategory()).arg("current_theme_name", (Object)Main.getCurrentThemeName(path, name)).arg("preset_groups", Main.getPresetGroupsForSelectedCategory()).arg("presets_for_selected_group", this.getPresetsForSelectedGroup(path, name)).arg("selected_preset_group", (Object)Main.getSelectedPresetGroup());
    }

    @GET
    @Path(value="styleProperties")
    public Object renderStyleProperties(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("styleProperties.ftl").arg("selected_element", (Object)Main.getSelectedElement()).arg("style_edit_mode", (Object)Main.getStyleEditMode()).arg("style_selectors", Main.getStyleSelectorsForSelectedElement()).arg("rendered_style_properties", (Object)Main.getRenderedStylePropertiesForSelectedElement()).arg("selected_style_selector", (Object)Main.getSelectedStyleSelector()).arg("element_style_properties", Main.getStylePropertiesForSelectedElement()).arg("all_style_properties", Main.getAvailableStylePropertiesForSelectedElement()).arg("selected_view_name", (Object)Main.getViewNameOfSelectedElement()).arg("selected_css_categories", Main.getSelectedCssCategories());
    }

    @GET
    @Path(value="render_css_preview")
    public String renderCssPreview(@QueryParam(value="basePath") String basePath) {
        Style selectedStyleLayer = Main.getSelectedStyleLayer();
        String selectedViewName = Main.getViewNameOfSelectedElement();
        Element selectedElement = Main.getSelectedElement();
        return Editor.renderCssPreview(selectedElement, selectedStyleLayer, selectedViewName, basePath);
    }

    @GET
    @Path(value="dashboard")
    public Object renderDashboard(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDef = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        return this.getTemplate("dashboard.ftl").arg("current_theme", (Object)currentThemeDef);
    }

    @GET
    @Path(value="controlPanel")
    public Object renderControlPanel(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String currentSkinName = Editor.getCurrentTopSkinName(currentThemeName);
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        ResourceBank currentThemeBank = this.getCurrentThemeBank(currentThemeName);
        return this.getTemplate("controlPanel.ftl").arg("current_theme", (Object)currentThemeDescriptor).arg("current_skin_name", (Object)currentSkinName).arg("current_bank", (Object)currentThemeBank);
    }

    @GET
    @Path(value="dashboardPreview")
    public Object renderDashboardPreview(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String templateEngine = Main.getTemplateEngine(path);
        String currentPagePath = Main.getCurrentPagePath(path, name);
        String currentpageName = ThemeManager.getPageNameFromPagePath((String)currentPagePath);
        ThemeDescriptor currentThemeDef = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        return this.getTemplate("dashboardPreview.ftl").arg("theme", (Object)currentThemeDef).arg("current_page_path", (Object)currentPagePath).arg("current_page_name", (Object)currentpageName);
    }

    @GET
    @Path(value="skinManager")
    public Object renderSkinManager(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String currentSkinName = Editor.getCurrentTopSkinName(currentThemeName);
        String currentBaseSkinName = Editor.getCurrentBaseSkinName(currentThemeName);
        ResourceBank currentThemeBank = this.getCurrentThemeBank(currentThemeName);
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        ArrayList<SkinInfo> skins = new ArrayList<SkinInfo>();
        ArrayList<SkinInfo> baseSkins = new ArrayList<SkinInfo>();
        List<Object> collections = new ArrayList();
        if (currentThemeBank != null) {
            String bankName = currentThemeBank.getName();
            for (SkinInfo skin : Editor.getBankSkins(bankName)) {
                if (skin.isBase()) {
                    baseSkins.add(skin);
                    continue;
                }
                skins.add(skin);
            }
            collections = Editor.getBankCollections(bankName);
        }
        return this.getTemplate("skinManager.ftl").arg("current_skin_name", (Object)currentSkinName).arg("current_base_skin_name", (Object)currentBaseSkinName).arg("current_theme", (Object)currentThemeDescriptor).arg("current_bank", (Object)currentThemeBank).arg("skins", skins).arg("base_skins", baseSkins).arg("collections", collections);
    }

    @GET
    @Path(value="bankManager")
    public Object renderBankManager(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        ResourceBank currentThemeBank = this.getCurrentThemeBank(currentThemeName);
        List banks = ThemeManager.getResourceBanks();
        List<Object> collections = new ArrayList();
        ResourceBank selectedResourceBank = null;
        if (currentThemeBank != null) {
            selectedResourceBank = currentThemeBank;
            collections = Editor.getBankCollections(currentThemeBank.getName());
        } else {
            String selectedResourceBankName = Main.getSelectedResourceBank();
            if (selectedResourceBankName == null) {
                if (!banks.isEmpty()) {
                    selectedResourceBank = (ResourceBank)banks.get(0);
                }
                collections = Editor.getBankCollections(selectedResourceBankName);
            } else {
                try {
                    selectedResourceBank = ThemeManager.getResourceBank((String)selectedResourceBankName);
                }
                catch (ThemeException e) {
                    e.printStackTrace();
                }
            }
        }
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        String selectedBankCollection = Main.getSelectedBankCollection();
        return this.getTemplate("bankManager.ftl").arg("current_theme", (Object)currentThemeDescriptor).arg("current_bank", (Object)currentThemeBank).arg("banks", (Object)banks).arg("selected_bank", (Object)selectedResourceBank).arg("collections", collections).arg("selected_bank_collection", (Object)selectedBankCollection);
    }

    private ResourceBank getCurrentThemeBank(String themeName) {
        String currentThemeBankName;
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        if (themeDescriptor != null && (currentThemeBankName = themeDescriptor.getResourceBankName()) != null) {
            try {
                return ThemeManager.getResourceBank((String)currentThemeBankName);
            }
            catch (ThemeException e) {
                return null;
            }
        }
        return null;
    }

    @POST
    @Path(value="use_resource_bank")
    public void useResourceBank(@FormParam(value="theme_src") String themeSrc, @FormParam(value="bank") String bankName) {
        try {
            if ("".equals(bankName)) {
                Editor.useNoResourceBank(themeSrc);
            } else {
                Editor.useResourceBank(themeSrc, bankName);
            }
        }
        catch (Exception e) {
            throw new ThemeEditorException("Cannot connect to bank: " + bankName, e);
        }
    }

    @POST
    @Path(value="activate_skin")
    public void activateSkin(@FormParam(value="theme") String themeName, @FormParam(value="bank") String bankName, @FormParam(value="collection") String collectionName, @FormParam(value="resource") String resourceName, @FormParam(value="base") boolean baseSkin) {
        try {
            Editor.activateSkin(themeName, bankName, collectionName, resourceName, baseSkin);
        }
        catch (Exception e) {
            throw new ThemeEditorException("Could not activate skin: " + e.getMessage(), e);
        }
    }

    @POST
    @Path(value="deactivate_skin")
    public void activateSkin(@FormParam(value="theme") String themeName) {
        try {
            Editor.deactivateSkin(themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException("Could not deactivate skin: " + e.getMessage(), e);
        }
    }

    @GET
    @Path(value="imageManager")
    public Object renderImageManager(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        ResourceBank currentThemeBank = this.getCurrentThemeBank(currentThemeName);
        String selectedBankCollection = Main.getSelectedBankCollection();
        List<Object> collections = new ArrayList();
        List<Object> images = new ArrayList();
        if (currentThemeBank != null) {
            String bankName = currentThemeBank.getName();
            collections = Editor.getBankCollections(bankName);
            images = Editor.getBankImages(bankName);
        }
        String templateEngine = Main.getTemplateEngine(path);
        ThemeDescriptor currentThemeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)templateEngine, (String)currentThemeName);
        return this.getTemplate("imageManager.ftl").arg("current_theme", (Object)currentThemeDescriptor).arg("current_edit_field", (Object)Main.getSelectedEditField()).arg("current_bank", (Object)currentThemeBank).arg("images", images).arg("collections", collections).arg("selected_bank_collection", (Object)selectedBankCollection);
    }

    @GET
    @Path(value="imageUploaded")
    public Object renderImageUploaded(@QueryParam(value="org.nuxeo.theme.application.path") String path, @QueryParam(value="org.nuxeo.theme.application.name") String name) {
        return this.getTemplate("imageUploaded.ftl");
    }

    public ResourceBank getResourceBank(String bankName) throws ThemeException {
        return ThemeManager.getResourceBank((String)bankName);
    }

    @GET
    @Path(value="xml_export")
    public Response xmlExport(@QueryParam(value="src") String src, @QueryParam(value="download") Integer download, @QueryParam(value="indent") Integer indent) {
        String xml;
        ThemeDescriptor themeDef;
        if (src == null) {
            return null;
        }
        Manager.getThemeManager();
        try {
            themeDef = ThemeManager.getThemeDescriptor((String)src);
        }
        catch (ThemeException e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
        ThemeSerializer serializer = new ThemeSerializer();
        if (indent == null) {
            indent = 0;
        }
        try {
            xml = serializer.serializeToXml(src, indent.intValue());
        }
        catch (ThemeIOException e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
        Response.ResponseBuilder builder = Response.ok((Object)xml);
        if (download != null) {
            builder.header("Content-disposition", (Object)String.format("attachment; filename=theme-%s.xml", themeDef.getName()));
        }
        builder.type("text/xml");
        return builder.build();
    }

    @POST
    @Path(value="clear_selections")
    public void clearSelections() {
        SessionManager.setElementId(null);
        SessionManager.setStyleEditMode(null);
        SessionManager.setStyleLayerId(null);
        SessionManager.setStyleSelector(null);
        SessionManager.setNamedStyleId(null);
        SessionManager.setStyleCategory(null);
        SessionManager.setPresetGroup(null);
        SessionManager.setPresetCategory(null);
        SessionManager.setClipboardElementId(null);
        SessionManager.setFragmentType(null);
        SessionManager.setFragmentView(null);
        SessionManager.setFragmentStyle(null);
    }

    @POST
    @Path(value="select_element")
    public void selectElement(@FormParam(value="id") String id) {
        SessionManager.setElementId(id);
        SessionManager.setStyleEditMode(null);
        SessionManager.setStyleLayerId(null);
        SessionManager.setNamedStyleId(null);
        SessionManager.setStyleSelector(null);
        SessionManager.setStyleCategory(null);
        SessionManager.setPresetGroup(null);
        SessionManager.setPresetCategory(null);
        SessionManager.setFragmentType(null);
        SessionManager.setFragmentView(null);
        SessionManager.setFragmentStyle(null);
    }

    @POST
    @Path(value="add_page")
    public String addPage(@FormParam(value="path") String pagePath) {
        try {
            return Editor.addPage(pagePath);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="add_theme")
    public String addTheme(@FormParam(value="name") String name) {
        try {
            return Editor.addTheme(name);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="uncustomize_theme")
    public String uncustomizeTheme(@FormParam(value="src") String src) {
        try {
            return Editor.uncustomizeTheme(src);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="align_element")
    public void alignElement(@FormParam(value="id") String id, @FormParam(value="position") String position) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.alignElement(element, position);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="assign_style_property")
    public void assignStyleProperty(@FormParam(value="element_id") String id, @FormParam(value="property") String propertyName, @FormParam(value="value") String value) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.assignStyleProperty(element, propertyName, value);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="copy_element")
    public void copyElement(@FormParam(value="id") String id) {
        SessionManager.setClipboardElementId(id);
    }

    @POST
    @Path(value="set_preset_category")
    public void setPresetCategory(@FormParam(value="theme_name") String themeName, @FormParam(value="preset_name") String presetName, @FormParam(value="category") String category) {
        try {
            Editor.setPresetCategory(themeName, presetName, category);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="copy_preset")
    public void copyPreset(@FormParam(value="id") String id) {
        SessionManager.setClipboardPresetId(id);
    }

    @POST
    @Path(value="paste_preset")
    public void pastePreset(@FormParam(value="theme_name") String themeName, @FormParam(value="preset_name") String newPresetName) {
        String presetName = Main.getClipboardPreset();
        if (presetName == null) {
            throw new ThemeEditorException("Nothing to paste");
        }
        PresetType preset = PresetManager.getPresetByName((String)presetName);
        if (preset == null) {
            throw new ThemeEditorException("Preset not found: " + presetName);
        }
        try {
            Editor.addPreset(themeName, newPresetName, preset.getCategory(), preset.getValue());
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="create_named_style")
    public void createNamedStyle(@FormParam(value="id") String id, @FormParam(value="theme_name") String themeName, @FormParam(value="style_name") String styleName) {
        Element element = null;
        if (id == null) {
            element = ThemeManager.getElementById((String)id);
        }
        try {
            Editor.createNamedStyle(element, styleName, themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="create_style")
    public void createStyle() {
        Element element = Main.getSelectedElement();
        try {
            Editor.createStyle(element);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="delete_element")
    public void deleteElement(@FormParam(value="id") String id) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.deleteElement(element);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="delete_named_style")
    public void deleteNamedStyle(@FormParam(value="id") String id, @FormParam(value="theme_name") String themeName, @FormParam(value="style_name") String styleName) {
        Element element = id == null ? null : ThemeManager.getElementById((String)id);
        try {
            Editor.deleteNamedStyle(element, styleName, themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="duplicate_element")
    public String duplicateElement(@FormParam(value="id") String id) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Integer res = Editor.duplicateElement(element);
            return String.valueOf(res);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="insert_fragment")
    public void insertFragment(@FormParam(value="dest_id") String destId, @FormParam(value="type_name") String typeName, @FormParam(value="style_name") String styleName) {
        Element destElement = ThemeManager.getElementById((String)destId);
        try {
            Editor.insertFragment(destElement, typeName, styleName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="insert_section_after")
    public void insertSectionAfter(@FormParam(value="id") String id) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.insertSectionAfter(element);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="select_preset_manager_mode")
    public void selectPresetManagerMode(@FormParam(value="mode") String mode) {
        SessionManager.setPresetManagerMode(mode);
    }

    @POST
    @Path(value="select_fragment_type")
    public void selectFragmentType(@FormParam(value="type") String type) {
        SessionManager.setFragmentType(type);
        SessionManager.setFragmentView(null);
        SessionManager.setFragmentStyle(null);
    }

    @POST
    @Path(value="select_fragment_view")
    public void selectFragmentView(@FormParam(value="view") String view) {
        SessionManager.setFragmentView(view);
        SessionManager.setFragmentStyle(null);
    }

    @POST
    @Path(value="select_fragment_style")
    public void selectFragmentStyle(@FormParam(value="style") String style) {
        SessionManager.setFragmentStyle(style);
    }

    @POST
    @Path(value="select_resource_bank")
    public void selectResourceBank(@FormParam(value="bank") String bankName) {
        SessionManager.setSelectedResourceBank(bankName);
    }

    public static String getSelectedResourceBank() {
        return SessionManager.getSelectedResourceBank();
    }

    @POST
    @Path(value="add_preset")
    public String addPreset(@FormParam(value="theme_name") String themeName, @FormParam(value="preset_name") String presetName, @FormParam(value="category") String category, @FormParam(value="value") String value) {
        if (value == null) {
            value = "";
        }
        try {
            return Editor.addPreset(themeName, presetName, category, value);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="convert_to_preset")
    public void convertValueToPreset(@FormParam(value="theme_name") String themeName, @FormParam(value="preset_name") String presetName, @FormParam(value="category") String category, @FormParam(value="value") String value) {
        if (value == null) {
            throw new ThemeEditorException("Preset value cannot be null");
        }
        try {
            Editor.convertCssValueToPreset(themeName, category, presetName, value);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="edit_preset")
    public void editPreset(@FormParam(value="theme_name") String themeName, @FormParam(value="preset_name") String presetName, @FormParam(value="value") String value) {
        try {
            Editor.editPreset(themeName, presetName, value);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_presets")
    public void updatePresets(@FormParam(value="theme_name") String themeName, @FormParam(value="property_map") String property_map) {
        JSONObject propertyMap = JSONObject.fromObject((Object)property_map);
        try {
            for (Map.Entry preset : propertyMap.entrySet()) {
                Editor.editPreset(themeName, (String)preset.getKey(), (String)preset.getValue());
            }
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="rename_preset")
    public void renamePreset(@FormParam(value="theme_name") String themeName, @FormParam(value="old_name") String oldName, @FormParam(value="new_name") String newName) {
        try {
            Editor.renamePreset(themeName, oldName, newName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="delete_preset")
    public void deletePreset(@FormParam(value="theme_name") String themeName, @FormParam(value="preset_name") String presetName) {
        try {
            Editor.deletePreset(themeName, presetName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="make_element_use_named_style")
    public void makeElementUseNamedStyle(@FormParam(value="id") String id, @FormParam(value="style_name") String styleName, @FormParam(value="theme_name") String themeName) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.makeElementUseNamedStyle(element, styleName, themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="set_style_inheritance")
    public void makeStyleInherit(@FormParam(value="style_name") String styleName, @FormParam(value="ancestor_name") String ancestorName, @FormParam(value="theme_name") String themeName) {
        try {
            Editor.setStyleInheritance(styleName, ancestorName, themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="remove_style_inheritance")
    public void removeStyleInheritance(@FormParam(value="style_name") String styleName, @FormParam(value="theme_name") String themeName) {
        try {
            Editor.removeStyleInheritance(styleName, themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="move_element")
    public void moveElement(@FormParam(value="src_id") String srcId, @FormParam(value="dest_id") String destId, @FormParam(value="order") Integer order) {
        Element srcElement = ThemeManager.getElementById((String)srcId);
        Element destElement = ThemeManager.getElementById((String)destId);
        try {
            Editor.moveElement(srcElement, destElement, order);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="paste_element")
    public void pasteElement(@FormParam(value="dest_id") String destId) {
        String id = Main.getClipboardElement();
        if (id == null) {
            throw new ThemeEditorException("Nothing to paste");
        }
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.pasteElement(element, destId);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="repair_theme")
    public void repairTheme(@FormParam(value="src") String src) {
        try {
            Editor.repairTheme(src);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="save_theme")
    public void saveTheme(@FormParam(value="src") String src) {
        try {
            Editor.saveTheme(src);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="load_theme")
    public void loadTheme(@FormParam(value="src") String src) {
        try {
            Editor.loadTheme(src);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="delete_theme")
    public void deleteTheme(@FormParam(value="src") String src) {
        try {
            Editor.deleteTheme(src);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="delete_page")
    public void deletePage(@FormParam(value="page_path") String pagePath) {
        try {
            Editor.deletePage(pagePath);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="select_preset_group")
    public void selectPresetGroup(@FormParam(value="group") String group) {
        SessionManager.setPresetGroup(group);
    }

    @POST
    @Path(value="select_preset_category")
    public void selectPresetCategory(@FormParam(value="category") String category) {
        SessionManager.setPresetCategory(category);
    }

    @POST
    @Path(value="select_bank_collection")
    public void selectBankCollection(@FormParam(value="collection") String collection) {
        SessionManager.setSelectedBankCollection(collection);
    }

    @POST
    @Path(value="set_page_styles")
    public void setPageStyles(@FormParam(value="theme_name") String themeName, @FormParam(value="property_map") String property_map) {
        JSONObject propertyMap = JSONObject.fromObject((Object)property_map);
        try {
            Editor.setPageStyles(themeName, (Map<String, String>)propertyMap);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="select_style_category")
    public void selectStyleCategory(@FormParam(value="category") String category) {
        SessionManager.setStyleCategory(category);
    }

    @POST
    @Path(value="select_style_edit_mode")
    public void selectStyleEditMode(@FormParam(value="mode") String mode) {
        SessionManager.setStyleEditMode(mode);
    }

    @POST
    @Path(value="toggle_css_category")
    public void toggleCssCategory(@FormParam(value="name") String name) {
        SessionManager.toggleCssCategory(name);
    }

    @POST
    @Path(value="collapse_css_categories")
    public void collapseCssCategories() {
        SessionManager.setSelectedCssCategories(new ArrayList<String>());
    }

    @POST
    @Path(value="expand_css_categories")
    public void expandCssCategories() {
        Properties cssStyleCategories = Utils.getCssStyleCategories();
        ArrayList<String> allCssCategories = Collections.list(cssStyleCategories.propertyNames());
        SessionManager.setSelectedCssCategories(allCssCategories);
    }

    @POST
    @Path(value="select_style_layer")
    public void selectStyleLayer(@FormParam(value="uid") String uid) {
        Style layer = (Style)ThemeManager.getFormatById((String)uid);
        if (layer != null) {
            SessionManager.setStyleLayerId(uid);
        }
    }

    @POST
    @Path(value="select_named_style")
    public void selectNamedStyle(@FormParam(value="uid") String uid) {
        Style style = (Style)ThemeManager.getFormatById((String)uid);
        if (style != null) {
            SessionManager.setNamedStyleId(uid);
        }
    }

    @POST
    @Path(value="select_style_selector")
    public void selectStyleSelector(@FormParam(value="selector") String selector) {
        SessionManager.setStyleSelector(selector);
    }

    @POST
    @Path(value="select_style_manager_mode")
    public void selectStyleManagerMode(@FormParam(value="mode") String mode) {
        SessionManager.setStyleManagerMode(mode);
    }

    @POST
    @Path(value="update_element_description")
    public void updateElementDescription(@FormParam(value="id") String id, @FormParam(value="description") String description) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.updateElementDescription(element, description);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_element_properties")
    public void updateElementProperties(@FormParam(value="id") String id, @FormParam(value="property_map") String properties) {
        JSONObject propertyMap = JSONObject.fromObject((Object)properties);
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.updateElementProperties(element, (Map<String, String>)propertyMap);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_element_width")
    public void updateElementWidth(@FormParam(value="id") String id, @FormParam(value="width") String width) {
        Format layout = ThemeManager.getFormatById((String)id);
        try {
            Editor.updateElementWidth(layout, width);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_element_style_css")
    public void updateElementStyleCss(@FormParam(value="id") String id, @FormParam(value="view_name") String viewName, @FormParam(value="css_source") String cssSource) {
        Element element = ThemeManager.getElementById((String)id);
        Style selectedStyleLayer = Main.getSelectedStyleLayer();
        try {
            Editor.updateElementStyleCss(element, selectedStyleLayer, viewName, cssSource);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_named_style_css")
    public void updateNamedStyleCss(@FormParam(value="style_uid") String style_uid, @FormParam(value="css_source") String cssSource, @FormParam(value="theme_name") String themeName) {
        Style style = (Style)ThemeManager.getFormatById((String)style_uid);
        try {
            Editor.updateNamedStyleCss(style, cssSource, themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="restore_named_style")
    public void restoreNamedStyle(@FormParam(value="style_uid") String style_uid, @FormParam(value="theme_name") String themeName) {
        Style style = (Style)ThemeManager.getFormatById((String)style_uid);
        try {
            Editor.restoreNamedStyle(style, themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="split_element")
    public void splitElement(@FormParam(value="id") String id) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.splitElement(element);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_element_style")
    public void updateElementStyle(@FormParam(value="id") String id, @FormParam(value="path") String path, @FormParam(value="view_name") String viewName, @FormParam(value="property_map") String property_map) {
        JSONObject propertyMap = JSONObject.fromObject((Object)property_map);
        Element element = ThemeManager.getElementById((String)id);
        Style currentStyleLayer = Main.getSelectedStyleLayer();
        try {
            Editor.updateElementStyle(element, currentStyleLayer, path, viewName, (Map<String, String>)propertyMap);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_element_visibility")
    public void updateElementVisibility(@FormParam(value="id") String id, @FormParam(value="perspectives") List<String> perspectives, @FormParam(value="always_visible") Boolean alwaysVisible) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.updateElementVisibility(element, perspectives, alwaysVisible);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_element_layout")
    public void updateElementPadding(@FormParam(value="property_map") String property_map) {
        JSONObject propertyMap = JSONObject.fromObject((Object)property_map);
        Element element = Main.getSelectedElement();
        try {
            Editor.updateElementLayout(element, (Map<String, String>)propertyMap);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="update_element_widget")
    public void updateElementWidget(@FormParam(value="id") String id, @FormParam(value="view_name") String viewName) {
        Element element = ThemeManager.getElementById((String)id);
        try {
            Editor.updateElementWidget(element, viewName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="delete_style_view")
    public void deleteStyleView(@FormParam(value="style_uid") String styleUid, @FormParam(value="view_name") String viewName) {
        Style style = (Style)ThemeManager.getFormatById((String)styleUid);
        try {
            Editor.deleteStyleView(style, viewName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="add_theme_to_workspace")
    public void addThemeToWorkspace(@FormParam(value="name") String name) {
        Set<String> themes = SessionManager.getWorkspaceThemeNames();
        if (!themes.contains(name)) {
            themes.add(name);
        }
        SessionManager.setWorkspaceThemeNames(themes);
    }

    @POST
    @Path(value="remove_theme_from_workspace")
    public void removeThemeFromWorkspace(@FormParam(value="name") String name) {
        Set<String> themes = SessionManager.getWorkspaceThemeNames();
        if (themes == null) {
            themes = new HashSet<String>();
        }
        if (themes.contains(name)) {
            themes.remove(name);
        }
        SessionManager.setWorkspaceThemeNames(themes);
    }

    @POST
    @Path(value="undo")
    public String undo(@FormParam(value="theme_name") String themeName) {
        try {
            return Editor.undo(themeName);
        }
        catch (Exception e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    public static ThemeDescriptor getThemeDescriptor(String themeName) {
        try {
            return ThemeManager.getThemeDescriptor((String)themeName);
        }
        catch (ThemeException e) {
            throw new ThemeEditorException(e.getMessage(), e);
        }
    }

    public static String getSelectedElementId() {
        return SessionManager.getElementId();
    }

    public static Element getSelectedElement() {
        String id = Main.getSelectedElementId();
        if (id == null) {
            return null;
        }
        Element element = ThemeManager.getElementById((String)id);
        if (!(element instanceof Element)) {
            return null;
        }
        return element;
    }

    public static String getClipboardElement() {
        return SessionManager.getClipboardElementId();
    }

    public static String getClipboardPreset() {
        return SessionManager.getClipboardPresetId();
    }

    public static List<StyleLayer> getStyleLayersOfSelectedElement() {
        ArrayList<StyleLayer> layers = new ArrayList<StyleLayer>();
        Style style = Main.getStyleOfSelectedElement();
        if (style == null) {
            return layers;
        }
        Style selectedStyleLayer = Main.getSelectedStyleLayer();
        layers.add(new StyleLayer("This style", style.getUid(), style == selectedStyleLayer || selectedStyleLayer == null));
        for (Format ancestor : ThemeManager.listAncestorFormatsOf((Format)style)) {
            layers.add(new StyleLayer(ancestor.getName(), ancestor.getUid(), ancestor == selectedStyleLayer));
        }
        return layers;
    }

    public static boolean isSelectedElementAlwaysVisible() {
        Element selectedElement = Main.getSelectedElement();
        return Manager.getPerspectiveManager().isAlwaysVisible(selectedElement);
    }

    public static List<PerspectiveType> getPerspectives() {
        return PerspectiveManager.listPerspectives();
    }

    public static List<String> getPerspectivesOfSelectedElement() {
        Element selectedElement = Main.getSelectedElement();
        ArrayList<String> perspectives = new ArrayList<String>();
        for (PerspectiveType perspectiveType : Manager.getPerspectiveManager().getPerspectivesFor(selectedElement)) {
            perspectives.add(perspectiveType.name);
        }
        return perspectives;
    }

    public static String getStyleEditMode() {
        return SessionManager.getStyleEditMode();
    }

    public static List<String> getStyleSelectorsForSelectedElement() {
        String viewName = Main.getViewNameOfSelectedElement();
        Style style = Main.getStyleOfSelectedElement();
        Style selectedStyleLayer = Main.getSelectedStyleLayer();
        ArrayList<String> selectors = new ArrayList<String>();
        if (selectedStyleLayer != null) {
            style = selectedStyleLayer;
        }
        if (style != null) {
            if (style.getName() != null) {
                viewName = "*";
            }
            Set paths = style.getPathsForView(viewName);
            String current = Main.getSelectedStyleSelector();
            if (current != null && !paths.contains(current)) {
                selectors.add(current);
            }
            for (String path : paths) {
                selectors.add(path);
            }
        }
        return selectors;
    }

    public static List<StyleFieldProperty> getStylePropertiesForSelectedElement() {
        Style style = Main.getStyleOfSelectedElement();
        Style selectedStyleLayer = Main.getSelectedStyleLayer();
        if (selectedStyleLayer != null) {
            style = selectedStyleLayer;
        }
        ArrayList<StyleFieldProperty> fieldProperties = new ArrayList<StyleFieldProperty>();
        if (style == null) {
            return fieldProperties;
        }
        String path = Main.getSelectedStyleSelector();
        if (path == null) {
            return fieldProperties;
        }
        String viewName = Main.getViewNameOfSelectedElement();
        if (style.getName() != null) {
            viewName = "*";
        }
        Properties properties = style.getPropertiesFor(viewName, path);
        int idx = 0;
        Properties cssProperties = CSSUtils.getCssProperties();
        if (properties != null) {
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                String value = properties == null ? "" : properties.getProperty(name, "");
                String type = cssProperties.getProperty(name, "");
                String id = "p" + idx;
                fieldProperties.add(new StyleFieldProperty(name, value, type, id));
                ++idx;
            }
        }
        return fieldProperties;
    }

    public static Map<String, List<StyleFieldProperty>> getAvailableStylePropertiesForSelectedElement() {
        String viewName = Main.getViewNameOfSelectedElement();
        Style style = Main.getStyleOfSelectedElement();
        Style selectedStyleLayer = Main.getSelectedStyleLayer();
        if (selectedStyleLayer != null) {
            style = selectedStyleLayer;
        }
        LinkedHashMap<String, List<StyleFieldProperty>> styleFieldProperties = new LinkedHashMap<String, List<StyleFieldProperty>>();
        if (style == null) {
            return styleFieldProperties;
        }
        String path = Main.getSelectedStyleSelector();
        if (path == null) {
            return styleFieldProperties;
        }
        if (style.getName() != null) {
            viewName = "*";
        }
        Properties styleProperties = style.getPropertiesFor(viewName, path);
        Properties cssProperties = CSSUtils.getCssProperties();
        Properties cssStyleCategories = Utils.getCssStyleCategories();
        Enumeration<?> cssStyleCategoryNames = cssStyleCategories.propertyNames();
        int idx = 0;
        while (cssStyleCategoryNames.hasMoreElements()) {
            String cssStyleCategoryName = (String)cssStyleCategoryNames.nextElement();
            ArrayList<StyleFieldProperty> fieldProperties = new ArrayList<StyleFieldProperty>();
            for (String name : cssStyleCategories.getProperty(cssStyleCategoryName).split(",")) {
                String value = styleProperties == null ? "" : styleProperties.getProperty(name, "");
                String type = cssProperties.getProperty(name, "");
                String id = "s" + idx;
                fieldProperties.add(new StyleFieldProperty(name, value, type, id));
                ++idx;
            }
            styleFieldProperties.put(cssStyleCategoryName, fieldProperties);
        }
        return styleFieldProperties;
    }

    public static String getInheritedStyleNameOfSelectedElement() {
        Style style = Main.getStyleOfSelectedElement();
        Style ancestor = (Style)ThemeManager.getAncestorFormatOf((Format)style);
        if (ancestor != null) {
            return ancestor.getName();
        }
        return "";
    }

    public static String getSelectedStyleSelector() {
        return SessionManager.getStyleSelector();
    }

    public static Style getSelectedStyleLayer() {
        String selectedStyleLayerId = Main.getSelectedStyleLayerId();
        if (selectedStyleLayerId == null) {
            return null;
        }
        Format format = ThemeManager.getFormatById((String)selectedStyleLayerId);
        if (!(format instanceof Style)) {
            return null;
        }
        return (Style)format;
    }

    public static String getSelectedStyleLayerId() {
        return SessionManager.getStyleLayerId();
    }

    public static List<String> getSelectedCssCategories() {
        return SessionManager.getSelectedCssCategories();
    }

    public static String getSelectedNamedStyleId() {
        return SessionManager.getNamedStyleId();
    }

    public static Style getSelectedNamedStyle() {
        String selectedNamedStyleId = Main.getSelectedNamedStyleId();
        if (selectedNamedStyleId == null) {
            return null;
        }
        Format format = ThemeManager.getFormatById((String)selectedNamedStyleId);
        if (!(format instanceof Style)) {
            return null;
        }
        return (Style)format;
    }

    public static Style getStyleOfSelectedElement() {
        Element element = Main.getSelectedElement();
        if (element == null) {
            return null;
        }
        FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
        return (Style)ElementFormatter.getFormatByType((Object)element, (FormatType)styleType);
    }

    public static PaddingInfo getPaddingOfSelectedElement() {
        Element element = Main.getSelectedElement();
        String top = "";
        String bottom = "";
        String left = "";
        String right = "";
        if (element != null) {
            Layout layout = (Layout)ElementFormatter.getFormatFor((Element)element, (String)"layout");
            top = layout.getProperty("padding-top");
            bottom = layout.getProperty("padding-bottom");
            left = layout.getProperty("padding-left");
            right = layout.getProperty("padding-right");
        }
        return new PaddingInfo(top, bottom, left, right);
    }

    public static String getRenderedStylePropertiesForSelectedElement() {
        Style style = Main.getStyleOfSelectedElement();
        Style currentStyleLayer = Main.getSelectedStyleLayer();
        if (currentStyleLayer != null) {
            style = currentStyleLayer;
        }
        if (style == null) {
            return "";
        }
        ArrayList<String> viewNames = new ArrayList<String>();
        String viewName = Main.getViewNameOfSelectedElement();
        if (style.getName() != null) {
            viewName = "*";
        }
        viewNames.add(viewName);
        boolean IGNORE_VIEW_NAME = true;
        boolean IGNORE_CLASSNAME = true;
        boolean INDENT = true;
        return CSSUtils.styleToCss((Style)style, viewNames, (boolean)IGNORE_VIEW_NAME, (boolean)IGNORE_CLASSNAME, (boolean)INDENT);
    }

    public static String getRenderedPropertiesForNamedStyle(Style style) {
        if (style == null) {
            return "";
        }
        boolean IGNORE_VIEW_NAME = false;
        boolean IGNORE_CLASSNAME = true;
        boolean INDENT = true;
        return CSSUtils.styleToCss((Style)style, (Collection)style.getSelectorViewNames(), (boolean)IGNORE_VIEW_NAME, (boolean)IGNORE_CLASSNAME, (boolean)INDENT);
    }

    public static Widget getWidgetOfSelectedElement() {
        Element element = Main.getSelectedElement();
        if (element == null) {
            return null;
        }
        FormatType widgetType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "widget");
        return (Widget)ElementFormatter.getFormatByType((Object)element, (FormatType)widgetType);
    }

    public static String getViewNameOfSelectedElement() {
        Widget widget = Main.getWidgetOfSelectedElement();
        if (widget == null) {
            return "";
        }
        return widget.getName();
    }

    public static List<String> getViewNamesForSelectedElement(String applicationPath) {
        Element selectedElement = Main.getSelectedElement();
        String templateEngine = Main.getTemplateEngine(applicationPath);
        ArrayList<String> viewNames = new ArrayList<String>();
        if (selectedElement == null) {
            return viewNames;
        }
        if (!selectedElement.getElementType().getTypeName().equals("fragment")) {
            return viewNames;
        }
        FragmentType fragmentType = ((Fragment)selectedElement).getFragmentType();
        for (ViewType viewType : ThemeManager.getViewTypesForFragmentType((FragmentType)fragmentType)) {
            String viewName = viewType.getViewName();
            String viewTemplateEngine = viewType.getTemplateEngine();
            if ("*".equals(viewName) || !templateEngine.equals(viewTemplateEngine)) continue;
            viewNames.add(viewName);
        }
        return viewNames;
    }

    public static List<FieldProperty> getSelectedElementProperties() {
        Element selectedElement = Main.getSelectedElement();
        return Utils.getPropertiesOf(selectedElement);
    }

    public static List<String> getPresetGroupsForSelectedCategory() {
        return Main.getPresetGroups(Main.getSelectedStyleCategory());
    }

    public static List<String> getPresetGroups(String category) {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (PresetType preset : PresetManager.getGlobalPresets(null, (String)category)) {
            String group = preset.getGroup();
            if (!groupNames.contains(group)) {
                groups.add(group);
            }
            groupNames.add(group);
        }
        return groups;
    }

    public static List<PresetType> getGlobalPresets(String group) {
        return new ArrayList<PresetType>(PresetManager.getGlobalPresets((String)group, null));
    }

    public static List<PresetType> getCustomPresets(String themeName, String category) {
        if ("".equals(category)) {
            category = null;
        }
        return new ArrayList<PresetType>(PresetManager.getCustomPresets((String)themeName, (String)category));
    }

    public List<PresetType> getPresetsForSelectedGroup(String applicationPath, String name) {
        String category = Main.getSelectedStyleCategory();
        String group = Main.getSelectedPresetGroup();
        String themeName = Main.getCurrentThemeName(applicationPath, name);
        List presetTypes = group == null ? PresetManager.getCustomPresets((String)themeName, (String)category) : PresetManager.getGlobalPresets((String)group, (String)category);
        return new ArrayList<PresetType>(presetTypes);
    }

    public static String getPresetManagerMode() {
        return SessionManager.getPresetManagerMode();
    }

    public static String getStyleManagerMode() {
        return SessionManager.getStyleManagerMode();
    }

    public String resolveVariables(String themeName, String resourceBankName, List<ImageInfo> images, String value) {
        if (images == null) {
            return value;
        }
        String contextPath = VirtualHostHelper.getContextPathProperty();
        String basePath = this.ctx.getBasePath();
        value = value.replaceAll("\\$\\{basePath\\}", Matcher.quoteReplacement(basePath));
        value = PresetManager.resolvePresets((String)themeName, (String)value);
        for (ImageInfo image : images) {
            String path = image.getPath();
            value = value.replaceAll(Matcher.quoteReplacement(path), Matcher.quoteReplacement(String.format("%s/nxthemes-images/%s/%s", contextPath, resourceBankName, path.replace(" ", "%20"))));
        }
        return value;
    }

    public static List<String> getUnidentifiedPresetNames(String themeName) {
        return PresetManager.getUnidentifiedPresetNames((String)themeName);
    }

    public static String renderStyleView(Style style, String viewName) {
        ArrayList<String> viewNames = new ArrayList<String>();
        viewNames.add(viewName);
        return CSSUtils.styleToCss((Style)style, viewNames, (boolean)true, (boolean)true, (boolean)true);
    }

    public static List<String> getHardcodedColors(String themeName) {
        return Editor.getHardcodedColors(themeName);
    }

    public static List<String> getHardcodedImages(String themeName) {
        return Editor.getHardcodedImages(themeName);
    }

    public static String getSelectedPresetGroup() {
        return SessionManager.getPresetGroup();
    }

    public static String getSelectedPresetCategory() {
        return SessionManager.getPresetCategory();
    }

    public static String getSelectedBankCollection() {
        return SessionManager.getSelectedBankCollection();
    }

    public static String getSelectedStyleCategory() {
        return SessionManager.getStyleCategory();
    }

    public static String getSelectedFragmentType() {
        return SessionManager.getFragmentType();
    }

    public static String getSelectedFragmentView() {
        return SessionManager.getFragmentView();
    }

    public static String getSelectedFragmentStyle() {
        return SessionManager.getFragmentStyle();
    }

    public static String getTemplateEngine(String applicationPath) {
        return ThemeManager.getTemplateEngineName((String)applicationPath);
    }

    public static String getDefaultTheme(String applicationPath, String name) {
        String defaultTheme = ThemeManager.getDefaultTheme((String)applicationPath);
        if (defaultTheme == null || defaultTheme.equals("")) {
            String moduleName = WebEngine.getActiveContext().getModule().getName();
            defaultTheme = ThemeManager.getDefaultTheme((String[])new String[]{applicationPath, name, moduleName});
        }
        return defaultTheme;
    }

    public static String getCurrentPagePath(String applicationPath, String name) {
        String defaultTheme = Main.getDefaultTheme(applicationPath, name);
        String currentPagePath = WebEngine.getActiveContext().getCookie("nxthemes.theme");
        if (currentPagePath == null) {
            currentPagePath = defaultTheme;
        }
        return currentPagePath;
    }

    public static String getCurrentThemeName(String applicationPath, String name) {
        String defaultTheme = Main.getDefaultTheme(applicationPath, name);
        String currentPagePath = WebEngine.getActiveContext().getCookie("nxthemes.theme");
        if (currentPagePath == null) {
            return defaultTheme.split("/")[0];
        }
        return currentPagePath.split("/")[0];
    }

    public static List<PageInfo> getPages(String applicationPath, String name) {
        ThemeManager themeManager = Manager.getThemeManager();
        String currentPagePath = WebEngine.getActiveContext().getCookie("nxthemes.theme");
        String defaultTheme = Main.getDefaultTheme(applicationPath, name);
        String defaultPageName = defaultTheme.split("/")[1];
        ArrayList<PageInfo> pages = new ArrayList<PageInfo>();
        if (currentPagePath == null || !currentPagePath.contains("/")) {
            currentPagePath = defaultTheme;
        }
        String currentThemeName = currentPagePath.split("/")[0];
        String currentPageName = currentPagePath.split("/")[1];
        ThemeElement currentTheme = themeManager.getThemeByName(currentThemeName);
        if (currentTheme == null) {
            return pages;
        }
        boolean first = true;
        for (PageElement page : ThemeManager.getPagesOf((ThemeElement)currentTheme)) {
            String className;
            String pageName = page.getName();
            String link = String.format("%s/%s", currentThemeName, pageName);
            String string = className = pageName.equals(currentPageName) ? "selected" : "";
            if (defaultPageName.equals(pageName)) {
                className = className + " default";
            }
            if (first) {
                className = className + " first";
                first = false;
            }
            pages.add(new PageInfo(pageName, link, className));
        }
        return pages;
    }

    public static List<ThemeInfo> getThemes(String applicationPath, String name) {
        ArrayList<ThemeInfo> themes = new ArrayList<ThemeInfo>();
        String defaultTheme = Main.getDefaultTheme(applicationPath, name);
        String defaultPageName = defaultTheme.split("/")[1];
        String templateEngine = Main.getTemplateEngine(applicationPath);
        for (String themeName : ThemeManager.getThemeNames((String)templateEngine)) {
            String path = String.format("%s/%s", themeName, defaultPageName);
            Boolean selected = false;
            themes.add(new ThemeInfo(themeName, path, selected));
        }
        return themes;
    }

    public static ThemeManager getThemeManager() {
        return Manager.getThemeManager();
    }

    public static Style getThemeSkin(String themeName) {
        return Editor.getThemeSkin(themeName);
    }

    public static Set<ThemeInfo> getWorkspaceThemes(String path, String name) {
        String currentThemeName = Main.getCurrentThemeName(path, name);
        String templateEngine = Main.getTemplateEngine(path);
        Set<String> workspaceThemeNames = SessionManager.getWorkspaceThemeNames();
        LinkedHashSet<ThemeInfo> workspaceThemes = new LinkedHashSet<ThemeInfo>();
        Set compatibleThemes = ThemeManager.getThemeNames((String)templateEngine);
        if (!workspaceThemeNames.contains(currentThemeName)) {
            workspaceThemeNames.add(currentThemeName);
        }
        for (String themeName : workspaceThemeNames) {
            if (!compatibleThemes.contains(themeName)) continue;
            String pagePath = String.format("%s/default", themeName);
            workspaceThemes.add(new ThemeInfo(themeName, pagePath, themeName == currentThemeName));
        }
        return workspaceThemes;
    }

    public static void createFragmentPreview(String currentThemeName) {
        Editor.createFragmentPreview(currentThemeName);
    }

    public static SkinInfo getSkinInfo(String bankName, String skinName) {
        return Editor.getSkinInfo(bankName, skinName);
    }

    @POST
    @Path(value="select_edit_field")
    public void selectEditField(@FormParam(value="field_name") String fieldName) {
        SessionManager.setSelectedEditField(fieldName);
    }

    public static String getSelectedEditField() {
        return SessionManager.getSelectedEditField();
    }

    public static List<Style> listNamedStylesDirectlyInheritingFrom(Style style) {
        return Editor.listNamedStylesDirectlyInheritingFrom(style);
    }
}

