/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import groovyjarjarasm.asm.FieldVisitor;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.classgen.BytecodeInstruction;
import org.codehaus.groovy.classgen.BytecodeSequence;
import org.codehaus.groovy.classgen.ClassGenerator;
import org.codehaus.groovy.classgen.CompileStack;
import org.codehaus.groovy.classgen.DummyClassGenerator;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.MethodCaller;
import org.codehaus.groovy.classgen.MethodCallerMultiAdapter;
import org.codehaus.groovy.classgen.Variable;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.syntax.RuntimeParserException;
import org.codehaus.groovy.syntax.Token;

public class AsmClassGenerator
extends ClassGenerator {
    private final ClassVisitor cv;
    private MethodVisitor mv;
    private GeneratorContext context;
    private String sourceFile;
    private ClassNode classNode;
    private ClassNode outermostClass;
    private String internalClassName;
    private String internalBaseClassName;
    private CompileStack compileStack;
    private boolean outputReturn;
    private boolean leftHandExpression = false;
    static final MethodCallerMultiAdapter invokeMethodOnCurrent = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethodOnCurrent", true, false);
    static final MethodCallerMultiAdapter invokeMethodOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethodOnSuper", true, false);
    static final MethodCallerMultiAdapter invokeMethod = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethod", true, false);
    static final MethodCallerMultiAdapter invokeStaticMethod = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeStaticMethod", true, true);
    static final MethodCallerMultiAdapter invokeNew = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeNew", true, true);
    static final MethodCallerMultiAdapter setField = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setField", false, false);
    static final MethodCallerMultiAdapter getField = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getField", false, false);
    static final MethodCallerMultiAdapter setGroovyObjectField = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setGroovyObjectField", false, false);
    static final MethodCallerMultiAdapter getGroovyObjectField = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getGroovyObjectField", false, false);
    static final MethodCallerMultiAdapter setFieldOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setFieldOnSuper", false, false);
    static final MethodCallerMultiAdapter getFieldOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getFieldOnSuper", false, false);
    static final MethodCallerMultiAdapter setProperty = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setProperty", false, false);
    static final MethodCallerMultiAdapter getProperty = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getProperty", false, false);
    static final MethodCallerMultiAdapter setGroovyObjectProperty = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setGroovyObjectProperty", false, false);
    static final MethodCallerMultiAdapter getGroovyObjectProperty = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getGroovyObjectProperty", false, false);
    static final MethodCallerMultiAdapter setPropertyOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setPropertyOnSuper", false, false);
    static final MethodCallerMultiAdapter getPropertyOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getPropertyOnSuper", false, false);
    static final MethodCaller iteratorNextMethod = MethodCaller.newInterface(Iterator.class, "next");
    static final MethodCaller iteratorHasNextMethod = MethodCaller.newInterface(Iterator.class, "hasNext");
    static final MethodCaller assertFailedMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "assertFailed");
    static final MethodCaller isCaseMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "isCase");
    static final MethodCaller compareIdenticalMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareIdentical");
    static final MethodCaller compareEqualMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareEqual");
    static final MethodCaller compareNotEqualMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareNotEqual");
    static final MethodCaller compareToMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareTo");
    static final MethodCaller compareLessThanMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareLessThan");
    static final MethodCaller compareLessThanEqualMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareLessThanEqual");
    static final MethodCaller compareGreaterThanMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareGreaterThan");
    static final MethodCaller compareGreaterThanEqualMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareGreaterThanEqual");
    static final MethodCaller findRegexMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "findRegex");
    static final MethodCaller matchRegexMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "matchRegex");
    static final MethodCaller regexPattern = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "regexPattern");
    static final MethodCaller spreadMap = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "spreadMap");
    static final MethodCaller despreadList = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "despreadList");
    static final MethodCaller getMethodPointer = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "getMethodPointer");
    static final MethodCaller invokeClosureMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "invokeClosure");
    static final MethodCaller unaryPlus = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "unaryPlus");
    static final MethodCaller unaryMinus = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "unaryMinus");
    static final MethodCaller bitwiseNegate = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "bitwiseNegate");
    static final MethodCaller asTypeMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "asType");
    static final MethodCaller castToTypeMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "castToType");
    static final MethodCaller createListMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createList");
    static final MethodCaller createTupleMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createTuple");
    static final MethodCaller createMapMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createMap");
    static final MethodCaller createRangeMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createRange");
    static final MethodCaller createPojoWrapperMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createPojoWrapper");
    static final MethodCaller createGroovyObjectWrapperMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createGroovyObjectWrapper");
    static final MethodCaller selectConstructorAndTransformArguments = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "selectConstructorAndTransformArguments");
    private List exceptionBlocks = new ArrayList();
    private Set syntheticStaticFields = new HashSet();
    private boolean passingClosureParams;
    private ConstructorNode constructorNode;
    private MethodNode methodNode;
    private BytecodeHelper helper = new BytecodeHelper(null);
    public static final boolean CREATE_DEBUG_INFO = true;
    public static final boolean CREATE_LINE_NUMBER_INFO = true;
    private static final boolean MARK_START = true;
    public static final boolean ASM_DEBUG = false;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private ASTNode currentASTNode = null;
    private DummyClassGenerator dummyGen = null;
    private ClassWriter dummyClassWriter = null;
    private ClassNode interfaceClassLoadingClass;
    private boolean implicitThis = false;
    private Map genericParameterNames = null;
    private ClassNode rightHandType;

    public AsmClassGenerator(GeneratorContext context, ClassVisitor classVisitor, ClassLoader classLoader, String sourceFile) {
        super(classLoader);
        this.context = context;
        this.cv = classVisitor;
        this.sourceFile = sourceFile;
        this.dummyClassWriter = new ClassWriter(true);
        this.dummyGen = new DummyClassGenerator(context, this.dummyClassWriter, classLoader, sourceFile);
        this.compileStack = new CompileStack();
        this.genericParameterNames = new HashMap();
    }

    protected SourceUnit getSourceUnit() {
        return null;
    }

    public void visitClass(ClassNode classNode) {
        try {
            this.syntheticStaticFields.clear();
            this.classNode = classNode;
            this.outermostClass = null;
            this.internalClassName = BytecodeHelper.getClassInternalName(classNode);
            this.internalBaseClassName = BytecodeHelper.getClassInternalName(classNode.getSuperClass());
            this.cv.visit(this.getBytecodeVersion(), classNode.getModifiers(), this.internalClassName, BytecodeHelper.getGenericsSignature(classNode), this.internalBaseClassName, BytecodeHelper.getClassInternalNames(classNode.getInterfaces()));
            this.cv.visitSource(this.sourceFile, null);
            this.visitAnnotations(classNode, this.cv);
            if (classNode.isInterface()) {
                ClassNode owner = classNode;
                if (owner instanceof InnerClassNode) {
                    owner = owner.getOuterClass();
                }
                String outerClassName = owner.getName();
                String name = outerClassName + "$" + this.context.getNextInnerClassIdx();
                this.interfaceClassLoadingClass = new InnerClassNode(owner, name, 4128, ClassHelper.OBJECT_TYPE);
                super.visitClass(classNode);
                this.createInterfaceSyntheticStaticFields();
            } else {
                super.visitClass(classNode);
                if (!classNode.declaresInterface(ClassHelper.GENERATED_CLOSURE_Type)) {
                    this.createMopMethods();
                }
                this.createSyntheticStaticFields();
            }
            Iterator iter = this.innerClasses.iterator();
            while (iter.hasNext()) {
                ClassNode innerClass = (ClassNode)iter.next();
                String innerClassName = innerClass.getName();
                String innerClassInternalName = BytecodeHelper.getClassInternalName(innerClassName);
                int index = innerClassName.lastIndexOf(36);
                if (index >= 0) {
                    innerClassName = innerClassName.substring(index + 1);
                }
                String outerClassName = this.internalClassName;
                MethodNode enclosingMethod = innerClass.getEnclosingMethod();
                if (enclosingMethod != null) {
                    outerClassName = null;
                    innerClassName = null;
                }
                this.cv.visitInnerClass(innerClassInternalName, outerClassName, innerClassName, innerClass.getModifiers());
            }
            this.cv.visitEnd();
        }
        catch (GroovyRuntimeException e) {
            e.setModule(classNode.getModule());
            throw e;
        }
    }

    public void visitGenericType(GenericsType genericsType) {
        ClassNode type = genericsType.getType();
        this.genericParameterNames.put(type.getName(), genericsType);
    }

    private void createMopMethods() {
        this.visitMopMethodList(this.classNode.getMethods(), true);
        this.visitMopMethodList(this.classNode.getSuperClass().getAllDeclaredMethods(), false);
    }

    private String[] buildExceptions(ClassNode[] exceptions) {
        if (exceptions == null) {
            return null;
        }
        String[] ret = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            ret[i] = BytecodeHelper.getClassInternalName(exceptions[i]);
        }
        return ret;
    }

    private void visitMopMethodList(List methods, boolean isThis) {
        class Key {
            int hash = 0;
            String name;
            Parameter[] params;

            Key(String name, Parameter[] params) {
                this.name = name;
                this.params = params;
                this.hash = name.hashCode() << 2 + params.length;
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object obj) {
                Key other = (Key)obj;
                return other.name.equals(this.name) && AsmClassGenerator.this.equalParameterTypes(other.params, this.params);
            }
        }
        HashMap<Key, MethodNode> mops = new HashMap<Key, MethodNode>();
        LinkedList<MethodNode> mopCalls = new LinkedList<MethodNode>();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            String name;
            Key key;
            MethodNode mn = (MethodNode)iter.next();
            if ((mn.getModifiers() & 0x400) != 0 || isThis ^ (mn.getModifiers() & 5) == 0) continue;
            String methodName = mn.getName();
            if (AsmClassGenerator.isMopMethod(methodName)) {
                mops.put(new Key(methodName, mn.getParameters()), mn);
                continue;
            }
            if (methodName.startsWith("<") || mops.containsKey(key = new Key(name = AsmClassGenerator.getMopMethodName(mn, isThis), mn.getParameters()))) continue;
            mops.put(key, mn);
            mopCalls.add(mn);
        }
        this.generateMopCalls(mopCalls, isThis);
        mopCalls.clear();
        mops.clear();
    }

    private boolean equalParameterTypes(Parameter[] p1, Parameter[] p2) {
        if (p1.length != p2.length) {
            return false;
        }
        for (int i = 0; i < p1.length; ++i) {
            if (p1[i].getType().equals(p2[i].getType())) continue;
            return false;
        }
        return true;
    }

    private void generateMopCalls(LinkedList mopCalls, boolean useThis) {
        Iterator iter = mopCalls.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            String name = AsmClassGenerator.getMopMethodName(method, useThis);
            Parameter[] parameters = method.getParameters();
            String methodDescriptor = BytecodeHelper.getMethodDescriptor(method.getReturnType(), method.getParameters());
            this.mv = this.cv.visitMethod(0, name, methodDescriptor, null, null);
            this.mv.visitVarInsn(25, 0);
            BytecodeHelper helper = new BytecodeHelper(this.mv);
            int newRegister = 1;
            for (int i = 0; i < parameters.length; ++i) {
                ClassNode type = parameters[i].getType();
                helper.load(parameters[i].getType(), newRegister);
                ++newRegister;
                if (type != ClassHelper.double_TYPE && type != ClassHelper.long_TYPE) continue;
                ++newRegister;
            }
            this.mv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(method.getDeclaringClass()), method.getName(), methodDescriptor);
            helper.doReturn(method.getReturnType());
            this.mv.visitMaxs(0, 0);
            this.mv.visitEnd();
            this.classNode.addMethod(name, 0, method.getReturnType(), parameters, null, null);
        }
    }

    public static String getMopMethodName(MethodNode method, boolean useThis) {
        int distance = 0;
        for (ClassNode declaringNode = method.getDeclaringClass(); declaringNode != null; declaringNode = declaringNode.getSuperClass()) {
            ++distance;
        }
        return (useThis ? "this" : "super") + "$" + distance + "$" + method.getName();
    }

    public static boolean isMopMethod(String methodName) {
        return methodName.startsWith("this$") || methodName.startsWith("super$");
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        Parameter[] parameters = node.getParameters();
        String methodType = BytecodeHelper.getMethodDescriptor(node.getReturnType(), parameters);
        String signature = BytecodeHelper.getGenericsMethodSignature(node);
        int modifiers = node.getModifiers();
        if (this.isVargs(node.getParameters())) {
            modifiers |= 0x80;
        }
        this.mv = this.cv.visitMethod(modifiers, node.getName(), methodType, signature, this.buildExceptions(node.getExceptions()));
        this.visitAnnotations(node, this.mv);
        for (int i = 0; i < parameters.length; ++i) {
            this.visitParameterAnnotations(parameters[i], i, this.mv);
        }
        this.helper = new BytecodeHelper(this.mv);
        if (!node.isAbstract()) {
            Statement code = node.getCode();
            if (isConstructor && (code == null || !((ConstructorNode)node).firstStatementIsSpecialConstructorCall())) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(this.classNode.getSuperClass()), "<init>", "()V");
            }
            this.compileStack.init(node.getVariableScope(), parameters, this.mv, this.classNode);
            new ClassExpression(this.classNode).visit(this);
            this.mv.visitInsn(87);
            new ClassExpression(ClassHelper.METACLASS_TYPE).visit(this);
            this.mv.visitInsn(87);
            super.visitConstructorOrMethod(node, isConstructor);
            if (!this.outputReturn || node.isVoidMethod()) {
                this.mv.visitInsn(177);
            }
            this.compileStack.clear();
            Iterator iter = this.exceptionBlocks.iterator();
            while (iter.hasNext()) {
                Runnable runnable = (Runnable)iter.next();
                runnable.run();
            }
            this.exceptionBlocks.clear();
            this.mv.visitMaxs(0, 0);
        }
        this.mv.visitEnd();
    }

    private boolean isVargs(Parameter[] p) {
        if (p.length == 0) {
            return false;
        }
        ClassNode clazz = p[p.length - 1].getType();
        return clazz.isArray();
    }

    public void visitConstructor(ConstructorNode node) {
        this.constructorNode = node;
        this.methodNode = null;
        this.outputReturn = false;
        super.visitConstructor(node);
    }

    public void visitMethod(MethodNode node) {
        this.constructorNode = null;
        this.methodNode = node;
        this.outputReturn = false;
        super.visitMethod(node);
    }

    public void visitField(FieldNode fieldNode) {
        this.onLineNumber(fieldNode, "visitField: " + fieldNode.getName());
        ClassNode t = fieldNode.getType();
        String signature = BytecodeHelper.getGenericsBounds(t);
        FieldVisitor fv = this.cv.visitField(fieldNode.getModifiers(), fieldNode.getName(), BytecodeHelper.getTypeDescription(t), signature, null);
        this.visitAnnotations(fieldNode, fv);
        fv.visitEnd();
    }

    public void visitProperty(PropertyNode statement) {
        this.onLineNumber(statement, "visitProperty:" + statement.getField().getName());
        this.methodNode = null;
    }

    protected void visitStatement(Statement statement) {
        String name = statement.getStatementLabel();
        if (name != null) {
            Label label = this.compileStack.createLocalLabel(name);
            this.mv.visitLabel(label);
        }
    }

    public void visitBlockStatement(BlockStatement block) {
        this.onLineNumber(block, "visitBlockStatement");
        this.visitStatement(block);
        this.compileStack.pushVariableScope(block.getVariableScope());
        super.visitBlockStatement(block);
        this.compileStack.pop();
    }

    private void visitExpressionOrStatement(Object o) {
        if (o == EmptyExpression.INSTANCE) {
            return;
        }
        if (o instanceof Expression) {
            Expression expr = (Expression)o;
            this.visitAndAutoboxBoolean(expr);
            if (this.isPopRequired(expr)) {
                this.mv.visitInsn(87);
            }
        } else {
            ((Statement)o).visit(this);
        }
    }

    private void visitForLoopWithClosureList(ForStatement loop) {
        this.compileStack.pushLoop(loop.getVariableScope(), loop.getStatementLabel());
        ClosureListExpression clExpr = (ClosureListExpression)loop.getCollectionExpression();
        this.compileStack.pushVariableScope(clExpr.getVariableScope());
        List expressions = clExpr.getExpressions();
        int size = expressions.size();
        int condIndex = (size - 1) / 2;
        for (int i = 0; i < condIndex; ++i) {
            this.visitExpressionOrStatement(expressions.get(i));
        }
        Label continueLabel = this.compileStack.getContinueLabel();
        Label breakLabel = this.compileStack.getBreakLabel();
        Label cond = new Label();
        this.mv.visitLabel(cond);
        Expression condExpr = (Expression)expressions.get(condIndex);
        if (condExpr == EmptyExpression.INSTANCE) {
            this.mv.visitIntInsn(16, 0);
        } else if (this.isComparisonExpression(condExpr)) {
            condExpr.visit(this);
        } else {
            this.visitAndAutoboxBoolean(condExpr);
            this.helper.unbox(ClassHelper.boolean_TYPE);
        }
        this.mv.visitJumpInsn(153, breakLabel);
        loop.getLoopBlock().visit(this);
        this.mv.visitLabel(continueLabel);
        for (int i = condIndex + 1; i < size; ++i) {
            this.visitExpressionOrStatement(expressions.get(i));
        }
        this.mv.visitJumpInsn(167, cond);
        this.mv.visitLabel(breakLabel);
        this.compileStack.pop();
        this.compileStack.pop();
    }

    public void visitForLoop(ForStatement loop) {
        this.onLineNumber(loop, "visitForLoop");
        this.visitStatement(loop);
        Parameter loopVar = loop.getVariable();
        if (loopVar == ForStatement.FOR_LOOP_DUMMY) {
            this.visitForLoopWithClosureList(loop);
            return;
        }
        this.compileStack.pushLoop(loop.getVariableScope(), loop.getStatementLabel());
        Variable variable = this.compileStack.defineVariable(loop.getVariable(), false);
        MethodCallExpression iterator = new MethodCallExpression(loop.getCollectionExpression(), "iterator", (Expression)new ArgumentListExpression());
        iterator.visit(this);
        int iteratorIdx = this.compileStack.defineTemporaryVariable("iterator", ClassHelper.make(Iterator.class), true);
        Label continueLabel = this.compileStack.getContinueLabel();
        Label breakLabel = this.compileStack.getBreakLabel();
        this.mv.visitLabel(continueLabel);
        this.mv.visitVarInsn(25, iteratorIdx);
        iteratorHasNextMethod.call(this.mv);
        this.mv.visitJumpInsn(153, breakLabel);
        this.mv.visitVarInsn(25, iteratorIdx);
        iteratorNextMethod.call(this.mv);
        this.helper.storeVar(variable);
        loop.getLoopBlock().visit(this);
        this.mv.visitJumpInsn(167, continueLabel);
        this.mv.visitLabel(breakLabel);
        this.compileStack.pop();
    }

    public void visitWhileLoop(WhileStatement loop) {
        this.onLineNumber(loop, "visitWhileLoop");
        this.visitStatement(loop);
        this.compileStack.pushLoop(loop.getStatementLabel());
        Label continueLabel = this.compileStack.getContinueLabel();
        Label breakLabel = this.compileStack.getBreakLabel();
        this.mv.visitLabel(continueLabel);
        loop.getBooleanExpression().visit(this);
        this.mv.visitJumpInsn(153, breakLabel);
        loop.getLoopBlock().visit(this);
        this.mv.visitJumpInsn(167, continueLabel);
        this.mv.visitLabel(breakLabel);
        this.compileStack.pop();
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.onLineNumber(loop, "visitDoWhileLoop");
        this.visitStatement(loop);
        this.compileStack.pushLoop(loop.getStatementLabel());
        Label breakLabel = this.compileStack.getBreakLabel();
        Label continueLabel = this.compileStack.getContinueLabel();
        this.mv.visitLabel(continueLabel);
        loop.getLoopBlock().visit(this);
        loop.getBooleanExpression().visit(this);
        this.mv.visitJumpInsn(153, continueLabel);
        this.mv.visitLabel(breakLabel);
        this.compileStack.pop();
    }

    public void visitIfElse(IfStatement ifElse) {
        this.onLineNumber(ifElse, "visitIfElse");
        this.visitStatement(ifElse);
        ifElse.getBooleanExpression().visit(this);
        Label l0 = new Label();
        this.mv.visitJumpInsn(153, l0);
        this.compileStack.pushBooleanExpression();
        ifElse.getIfBlock().visit(this);
        this.compileStack.pop();
        Label l1 = new Label();
        this.mv.visitJumpInsn(167, l1);
        this.mv.visitLabel(l0);
        this.compileStack.pushBooleanExpression();
        ifElse.getElseBlock().visit(this);
        this.compileStack.pop();
        this.mv.visitLabel(l1);
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        this.onLineNumber(expression, "visitTernaryExpression");
        BooleanExpression boolPart = expression.getBooleanExpression();
        Expression truePart = expression.getTrueExpression();
        Expression falsePart = expression.getFalseExpression();
        if (expression instanceof ElvisOperatorExpression) {
            this.visitAndAutoboxBoolean(expression.getTrueExpression());
            boolPart = new BooleanExpression(new BytecodeExpression(){

                public void visit(GroovyCodeVisitor visitor) {
                    AsmClassGenerator.this.mv.visitInsn(89);
                }
            });
            truePart = BytecodeExpression.NOP;
            final Expression oldFalse = falsePart;
            falsePart = new BytecodeExpression(){

                public void visit(GroovyCodeVisitor visitor) {
                    AsmClassGenerator.this.mv.visitInsn(87);
                    AsmClassGenerator.this.visitAndAutoboxBoolean(oldFalse);
                }
            };
        }
        boolPart.visit(this);
        Label l0 = new Label();
        this.mv.visitJumpInsn(153, l0);
        this.compileStack.pushBooleanExpression();
        this.visitAndAutoboxBoolean(truePart);
        this.compileStack.pop();
        Label l1 = new Label();
        this.mv.visitJumpInsn(167, l1);
        this.mv.visitLabel(l0);
        this.compileStack.pushBooleanExpression();
        this.visitAndAutoboxBoolean(falsePart);
        this.compileStack.pop();
        this.mv.visitLabel(l1);
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.onLineNumber(statement, "visitAssertStatement");
        this.visitStatement(statement);
        BooleanExpression booleanExpression = statement.getBooleanExpression();
        booleanExpression.visit(this);
        Label l0 = new Label();
        this.mv.visitJumpInsn(153, l0);
        Label l1 = new Label();
        this.mv.visitJumpInsn(167, l1);
        this.mv.visitLabel(l0);
        String expressionText = booleanExpression.getText();
        ArrayList list = new ArrayList();
        this.addVariableNames(booleanExpression, list);
        if (list.isEmpty()) {
            this.mv.visitLdcInsn(expressionText);
        } else {
            boolean first = true;
            this.mv.visitTypeInsn(187, "java/lang/StringBuffer");
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(expressionText + ". Values: ");
            this.mv.visitMethodInsn(183, "java/lang/StringBuffer", "<init>", "(Ljava/lang/String;)V");
            int tempIndex = this.compileStack.defineTemporaryVariable("assert", true);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String text = name + " = ";
                if (first) {
                    first = false;
                } else {
                    text = ", " + text;
                }
                this.mv.visitVarInsn(25, tempIndex);
                this.mv.visitLdcInsn(text);
                this.mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
                this.mv.visitInsn(87);
                this.mv.visitVarInsn(25, tempIndex);
                new VariableExpression(name).visit(this);
                this.mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
                this.mv.visitInsn(87);
            }
            this.mv.visitVarInsn(25, tempIndex);
            this.compileStack.removeVar(tempIndex);
        }
        statement.getMessageExpression().visit(this);
        assertFailedMethod.call(this.mv);
        this.mv.visitLabel(l1);
    }

    private void addVariableNames(Expression expression, List list) {
        if (expression instanceof BooleanExpression) {
            BooleanExpression boolExp = (BooleanExpression)expression;
            this.addVariableNames(boolExp.getExpression(), list);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)expression;
            this.addVariableNames(binExp.getLeftExpression(), list);
            this.addVariableNames(binExp.getRightExpression(), list);
        } else if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            list.add(varExp.getName());
        }
    }

    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.onLineNumber(statement, "visitTryCatchFinally");
        this.visitStatement(statement);
        CatchStatement catchStatement = statement.getCatchStatement(0);
        Statement tryStatement = statement.getTryStatement();
        final Statement finallyStatement = statement.getFinallyStatement();
        int anyExceptionIndex = this.compileStack.defineTemporaryVariable("exception", false);
        if (!finallyStatement.isEmpty()) {
            this.compileStack.pushFinallyBlock(new Runnable(){

                public void run() {
                    AsmClassGenerator.this.compileStack.pushFinallyBlockVisit(this);
                    finallyStatement.visit(AsmClassGenerator.this);
                    AsmClassGenerator.this.compileStack.popFinallyBlockVisit(this);
                }
            });
        }
        final Label tryStart = new Label();
        this.mv.visitLabel(tryStart);
        tryStatement.visit(this);
        Label finallyStart = new Label();
        this.mv.visitJumpInsn(167, finallyStart);
        final Label tryEnd = new Label();
        this.mv.visitLabel(tryEnd);
        Iterator it = statement.getCatchStatements().iterator();
        while (it.hasNext()) {
            catchStatement = (CatchStatement)it.next();
            ClassNode exceptionType = catchStatement.getExceptionType();
            final Label catchStart = new Label();
            this.mv.visitLabel(catchStart);
            this.compileStack.defineVariable(catchStatement.getVariable(), true);
            catchStatement.visit(this);
            this.mv.visitJumpInsn(167, finallyStart);
            final String exceptionTypeInternalName = BytecodeHelper.getClassInternalName(exceptionType);
            this.exceptionBlocks.add(new Runnable(){

                public void run() {
                    AsmClassGenerator.this.mv.visitTryCatchBlock(tryStart, tryEnd, catchStart, exceptionTypeInternalName);
                }
            });
        }
        final Label endOfAllCatches = new Label();
        this.mv.visitLabel(endOfAllCatches);
        if (!finallyStatement.isEmpty()) {
            this.compileStack.popFinallyBlock();
        }
        this.mv.visitLabel(finallyStart);
        finallyStatement.visit(this);
        Label afterFinally = new Label();
        this.mv.visitJumpInsn(167, afterFinally);
        final Label catchAny = new Label();
        this.mv.visitLabel(catchAny);
        this.mv.visitVarInsn(58, anyExceptionIndex);
        finallyStatement.visit(this);
        this.mv.visitVarInsn(25, anyExceptionIndex);
        this.mv.visitInsn(191);
        this.mv.visitLabel(afterFinally);
        this.exceptionBlocks.add(new Runnable(){

            public void run() {
                AsmClassGenerator.this.mv.visitTryCatchBlock(tryStart, endOfAllCatches, catchAny, null);
            }
        });
    }

    public void visitSwitch(SwitchStatement statement) {
        int i;
        this.onLineNumber(statement, "visitSwitch");
        this.visitStatement(statement);
        statement.getExpression().visit(this);
        Label breakLabel = this.compileStack.pushSwitch();
        int switchVariableIndex = this.compileStack.defineTemporaryVariable("switch", true);
        List caseStatements = statement.getCaseStatements();
        int caseCount = caseStatements.size();
        Label[] labels = new Label[caseCount + 1];
        for (i = 0; i < caseCount; ++i) {
            labels[i] = new Label();
        }
        i = 0;
        Iterator iter = caseStatements.iterator();
        while (iter.hasNext()) {
            CaseStatement caseStatement = (CaseStatement)iter.next();
            this.visitCaseStatement(caseStatement, switchVariableIndex, labels[i], labels[i + 1]);
            ++i;
        }
        statement.getDefaultStatement().visit(this);
        this.mv.visitLabel(breakLabel);
        this.compileStack.pop();
    }

    public void visitCaseStatement(CaseStatement statement) {
    }

    public void visitCaseStatement(CaseStatement statement, int switchVariableIndex, Label thisLabel, Label nextLabel) {
        this.onLineNumber(statement, "visitCaseStatement");
        this.mv.visitVarInsn(25, switchVariableIndex);
        statement.getExpression().visit(this);
        isCaseMethod.call(this.mv);
        Label l0 = new Label();
        this.mv.visitJumpInsn(153, l0);
        this.mv.visitLabel(thisLabel);
        statement.getCode().visit(this);
        if (nextLabel != null) {
            this.mv.visitJumpInsn(167, nextLabel);
        }
        this.mv.visitLabel(l0);
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.onLineNumber(statement, "visitBreakStatement");
        this.visitStatement(statement);
        String name = statement.getLabel();
        Label breakLabel = this.compileStack.getNamedBreakLabel(name);
        this.compileStack.applyFinallyBlocks(breakLabel, true);
        this.mv.visitJumpInsn(167, breakLabel);
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.onLineNumber(statement, "visitContinueStatement");
        this.visitStatement(statement);
        String name = statement.getLabel();
        Label continueLabel = this.compileStack.getContinueLabel();
        if (name != null) {
            continueLabel = this.compileStack.getNamedContinueLabel(name);
        }
        this.compileStack.applyFinallyBlocks(continueLabel, false);
        this.mv.visitJumpInsn(167, continueLabel);
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.onLineNumber(statement, "visitSynchronizedStatement");
        this.visitStatement(statement);
        statement.getExpression().visit(this);
        final int index = this.compileStack.defineTemporaryVariable("synchronized", ClassHelper.Integer_TYPE, true);
        final Label synchronizedStart = new Label();
        Label synchronizedEnd = new Label();
        final Label catchAll = new Label();
        this.mv.visitVarInsn(25, index);
        this.mv.visitInsn(194);
        this.mv.visitLabel(synchronizedStart);
        Runnable finallyPart = new Runnable(){

            public void run() {
                AsmClassGenerator.this.mv.visitVarInsn(25, index);
                AsmClassGenerator.this.mv.visitInsn(195);
            }
        };
        this.compileStack.pushFinallyBlock(finallyPart);
        statement.getCode().visit(this);
        finallyPart.run();
        this.mv.visitJumpInsn(167, synchronizedEnd);
        this.mv.visitLabel(catchAll);
        finallyPart.run();
        this.mv.visitInsn(191);
        this.mv.visitLabel(synchronizedEnd);
        this.compileStack.popFinallyBlock();
        this.exceptionBlocks.add(new Runnable(){

            public void run() {
                AsmClassGenerator.this.mv.visitTryCatchBlock(synchronizedStart, catchAll, catchAll, null);
            }
        });
    }

    public void visitThrowStatement(ThrowStatement statement) {
        this.onLineNumber(statement, "visitThrowStatement");
        this.visitStatement(statement);
        statement.getExpression().visit(this);
        this.mv.visitTypeInsn(192, "java/lang/Throwable");
        this.mv.visitInsn(191);
    }

    public void visitReturnStatement(ReturnStatement statement) {
        ClassNode returnType;
        this.onLineNumber(statement, "visitReturnStatement");
        this.visitStatement(statement);
        if (this.methodNode != null) {
            returnType = this.methodNode.getReturnType();
        } else if (this.constructorNode != null) {
            returnType = this.constructorNode.getReturnType();
        } else {
            throw new GroovyBugError("I spotted a return that is neither in a method nor in a constructor... I can not handle that");
        }
        if (returnType == ClassHelper.VOID_TYPE) {
            if (statement != ReturnStatement.RETURN_NULL_OR_VOID) {
                this.throwException("Cannot use return statement with an expression on a method that returns void");
            }
            this.compileStack.applyFinallyBlocks();
            this.mv.visitInsn(177);
            this.outputReturn = true;
            return;
        }
        Expression expression = statement.getExpression();
        this.evaluateExpression(expression);
        if (returnType == ClassHelper.OBJECT_TYPE && expression.getType() != null && expression.getType() == ClassHelper.VOID_TYPE) {
            this.mv.visitInsn(1);
        } else {
            this.doConvertAndCast(returnType, expression, false, true, false);
        }
        if (this.compileStack.hasFinallyBlocks()) {
            int returnValueIdx = this.compileStack.defineTemporaryVariable("returnValue", ClassHelper.OBJECT_TYPE, true);
            this.compileStack.applyFinallyBlocks();
            this.helper.load(ClassHelper.OBJECT_TYPE, returnValueIdx);
        }
        this.helper.unbox(returnType);
        this.helper.doReturn(returnType);
        this.outputReturn = true;
    }

    protected void doConvertAndCast(ClassNode type, Expression expression, boolean ignoreAutoboxing, boolean forceCast, boolean coerce) {
        ClassNode expType = this.getExpressionType(expression);
        if (!ignoreAutoboxing && ClassHelper.isPrimitiveType(type)) {
            type = ClassHelper.getWrapper(type);
        }
        if (forceCast || type != null && !expType.isDerivedFrom(type) && !expType.implementsInterface(type)) {
            this.doConvertAndCast(type, coerce);
        }
    }

    protected void evaluateExpression(Expression expression) {
        this.visitAndAutoboxBoolean(expression);
        if (this.isPopRequired(expression)) {
            return;
        }
        Expression assignExpr = this.createReturnLHSExpression(expression);
        if (assignExpr != null) {
            this.leftHandExpression = false;
            assignExpr.visit(this);
        }
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.onLineNumber(statement, "visitExpressionStatement: " + statement.getExpression().getClass().getName());
        this.visitStatement(statement);
        Expression expression = statement.getExpression();
        this.visitAndAutoboxBoolean(expression);
        if (this.isPopRequired(expression)) {
            this.mv.visitInsn(87);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.onLineNumber(expression, "visitDeclarationExpression: \"" + expression.getVariableExpression().getName() + "\"");
        Expression rightExpression = expression.getRightExpression();
        VariableExpression vex = expression.getVariableExpression();
        ClassNode type = vex.getType();
        if (ClassHelper.isPrimitiveType(type)) {
            rightExpression.visit(this);
        } else if (type != ClassHelper.OBJECT_TYPE) {
            this.visitCastExpression(new CastExpression(type, rightExpression));
        } else {
            this.visitAndAutoboxBoolean(rightExpression);
        }
        this.compileStack.defineVariable(vex, true);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        this.onLineNumber(expression, "visitBinaryExpression: \"" + expression.getOperation().getText() + "\" ");
        switch (expression.getOperation().getType()) {
            case 100: {
                this.evaluateEqual(expression);
                break;
            }
            case 121: {
                this.evaluateBinaryExpression(compareIdenticalMethod, expression);
                break;
            }
            case 123: {
                this.evaluateBinaryExpression(compareEqualMethod, expression);
                break;
            }
            case 120: {
                this.evaluateBinaryExpression(compareNotEqualMethod, expression);
                break;
            }
            case 128: {
                this.evaluateCompareTo(expression);
                break;
            }
            case 126: {
                this.evaluateBinaryExpression(compareGreaterThanMethod, expression);
                break;
            }
            case 127: {
                this.evaluateBinaryExpression(compareGreaterThanEqualMethod, expression);
                break;
            }
            case 124: {
                this.evaluateBinaryExpression(compareLessThanMethod, expression);
                break;
            }
            case 125: {
                this.evaluateBinaryExpression(compareLessThanEqualMethod, expression);
                break;
            }
            case 164: {
                this.evaluateLogicalAndExpression(expression);
                break;
            }
            case 162: {
                this.evaluateLogicalOrExpression(expression);
                break;
            }
            case 341: {
                this.evaluateBinaryExpression("and", expression);
                break;
            }
            case 351: {
                this.evaluateBinaryExpressionWithAssignment("and", expression);
                break;
            }
            case 340: {
                this.evaluateBinaryExpression("or", expression);
                break;
            }
            case 350: {
                this.evaluateBinaryExpressionWithAssignment("or", expression);
                break;
            }
            case 342: {
                this.evaluateBinaryExpression("xor", expression);
                break;
            }
            case 352: {
                this.evaluateBinaryExpressionWithAssignment("xor", expression);
                break;
            }
            case 200: {
                this.evaluateBinaryExpression("plus", expression);
                break;
            }
            case 210: {
                this.evaluateBinaryExpressionWithAssignment("plus", expression);
                break;
            }
            case 201: {
                this.evaluateBinaryExpression("minus", expression);
                break;
            }
            case 211: {
                this.evaluateBinaryExpressionWithAssignment("minus", expression);
                break;
            }
            case 202: {
                this.evaluateBinaryExpression("multiply", expression);
                break;
            }
            case 212: {
                this.evaluateBinaryExpressionWithAssignment("multiply", expression);
                break;
            }
            case 203: {
                this.evaluateBinaryExpression("div", expression);
                break;
            }
            case 213: {
                this.evaluateBinaryExpressionWithAssignment("div", expression);
                break;
            }
            case 204: {
                this.evaluateBinaryExpression("intdiv", expression);
                break;
            }
            case 214: {
                this.evaluateBinaryExpressionWithAssignment("intdiv", expression);
                break;
            }
            case 205: {
                this.evaluateBinaryExpression("mod", expression);
                break;
            }
            case 215: {
                this.evaluateBinaryExpressionWithAssignment("mod", expression);
                break;
            }
            case 206: {
                this.evaluateBinaryExpression("power", expression);
                break;
            }
            case 216: {
                this.evaluateBinaryExpressionWithAssignment("power", expression);
                break;
            }
            case 280: {
                this.evaluateBinaryExpression("leftShift", expression);
                break;
            }
            case 285: {
                this.evaluateBinaryExpressionWithAssignment("leftShift", expression);
                break;
            }
            case 281: {
                this.evaluateBinaryExpression("rightShift", expression);
                break;
            }
            case 286: {
                this.evaluateBinaryExpressionWithAssignment("rightShift", expression);
                break;
            }
            case 282: {
                this.evaluateBinaryExpression("rightShiftUnsigned", expression);
                break;
            }
            case 287: {
                this.evaluateBinaryExpressionWithAssignment("rightShiftUnsigned", expression);
                break;
            }
            case 544: {
                this.evaluateInstanceof(expression);
                break;
            }
            case 90: {
                this.evaluateBinaryExpression(findRegexMethod, expression);
                break;
            }
            case 94: {
                this.evaluateBinaryExpression(matchRegexMethod, expression);
                break;
            }
            case 30: {
                if (this.leftHandExpression) {
                    this.throwException("Should not be called here. Possible reason: postfix operation on array.");
                    break;
                }
                this.evaluateBinaryExpression("getAt", expression);
                break;
            }
            case 573: {
                this.evaluateBinaryExpression(isCaseMethod, expression);
                break;
            }
            default: {
                this.throwException("Operation: " + expression.getOperation() + " not supported");
            }
        }
    }

    private void load(Expression exp) {
        boolean wasLeft = this.leftHandExpression;
        this.leftHandExpression = false;
        this.visitAndAutoboxBoolean(exp);
        this.leftHandExpression = wasLeft;
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        switch (expression.getOperation().getType()) {
            case 250: {
                this.evaluatePostfixMethod("next", expression.getExpression());
                break;
            }
            case 260: {
                this.evaluatePostfixMethod("previous", expression.getExpression());
            }
        }
    }

    private void throwException(String s) {
        throw new RuntimeParserException(s, this.currentASTNode);
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        switch (expression.getOperation().getType()) {
            case 250: {
                this.evaluatePrefixMethod("next", expression.getExpression());
                break;
            }
            case 260: {
                this.evaluatePrefixMethod("previous", expression.getExpression());
            }
        }
    }

    public void visitClosureExpression(ClosureExpression expression) {
        ClassNode innerClass = this.createClosureClass(expression);
        this.addInnerClass(innerClass);
        innerClass.addInterface(ClassHelper.GENERATED_CLOSURE_Type);
        String innerClassinternalName = BytecodeHelper.getClassInternalName(innerClass);
        this.passingClosureParams = true;
        List constructors = innerClass.getDeclaredConstructors();
        ConstructorNode node = (ConstructorNode)constructors.get(0);
        Parameter[] localVariableParams = node.getParameters();
        this.mv.visitTypeInsn(187, innerClassinternalName);
        this.mv.visitInsn(89);
        if (this.isStaticMethod() && !this.classNode.declaresInterface(ClassHelper.GENERATED_CLOSURE_Type)) {
            this.visitClassExpression(new ClassExpression(this.classNode));
            this.visitClassExpression(new ClassExpression(this.getOutermostClass()));
        } else {
            this.mv.visitVarInsn(25, 0);
            this.loadThis();
        }
        for (int i = 2; i < localVariableParams.length; ++i) {
            Parameter param = localVariableParams[i];
            String name = param.getName();
            if (!this.compileStack.containsVariable(name) && this.compileStack.getScope().isReferencedClassVariable(name)) {
                this.visitFieldExpression(new FieldExpression(this.classNode.getDeclaredField(name)));
                continue;
            }
            Variable v = this.compileStack.getVariable(name, this.classNode.getSuperClass() != ClassHelper.CLOSURE_TYPE);
            if (v == null) {
                FieldNode field = this.classNode.getDeclaredField(name);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.internalClassName, name, BytecodeHelper.getTypeDescription(field.getType()));
                param.setClosureSharedVariable(false);
                v = this.compileStack.defineVariable(param, true);
                param.setClosureSharedVariable(true);
                v.setHolder(true);
            }
            this.mv.visitVarInsn(25, v.getIndex());
        }
        this.passingClosureParams = false;
        this.mv.visitMethodInsn(183, innerClassinternalName, "<init>", BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, localVariableParams));
    }

    protected void loadThisOrOwner() {
        if (this.isInnerClass()) {
            this.visitFieldExpression(new FieldExpression(this.classNode.getDeclaredField("owner")));
        } else {
            this.loadThis();
        }
    }

    public void visitRegexExpression(RegexExpression expression) {
        expression.getRegex().visit(this);
        regexPattern.call(this.mv);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        Object value = expression.getValue();
        this.helper.loadConstant(value);
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        throw new GroovyBugError("SpreadExpression should not be visited here");
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        spreadMap.call(this.mv);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        this.loadDynamicName(expression.getMethodName());
        getMethodPointer.call(this.mv);
    }

    private void loadDynamicName(Expression name) {
        ConstantExpression ce;
        Object value;
        if (name instanceof ConstantExpression && (value = (ce = (ConstantExpression)name).getValue()) instanceof String) {
            this.helper.loadConstant(value);
            return;
        }
        new CastExpression(ClassHelper.STRING_TYPE, name).visit(this);
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        unaryMinus.call(this.mv);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        unaryPlus.call(this.mv);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        bitwiseNegate.call(this.mv);
    }

    public void visitCastExpression(CastExpression expression) {
        ClassNode type = expression.getType();
        this.visitAndAutoboxBoolean(expression.getExpression());
        ClassNode rht = this.rightHandType;
        this.rightHandType = expression.getExpression().getType();
        this.doConvertAndCast(type, expression.getExpression(), expression.isIgnoringAutoboxing(), false, expression.isCoerce());
        this.rightHandType = rht;
    }

    public void visitNotExpression(NotExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        if (!this.isComparisonExpression(subExpression) && !(subExpression instanceof BooleanExpression)) {
            this.helper.unbox(Boolean.TYPE);
        }
        this.helper.negateBoolean();
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        this.compileStack.pushBooleanExpression();
        expression.getExpression().visit(this);
        if (!this.isComparisonExpression(expression.getExpression())) {
            this.helper.unbox(Boolean.TYPE);
        }
        this.compileStack.pop();
    }

    private void makeInvokeMethodCall(MethodCallExpression call, boolean useSuper, MethodCallerMultiAdapter adapter) {
        Expression objectExpression = call.getObjectExpression();
        if (!this.isStaticMethod() && !this.isStaticContext() && AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
            objectExpression = new CastExpression(ClassHelper.make(GroovyObject.class), objectExpression);
        }
        CastExpression messageName = new CastExpression(ClassHelper.STRING_TYPE, call.getMethod());
        if (useSuper) {
            this.makeCall(new ClassExpression(this.getOutermostClass().getSuperClass()), objectExpression, messageName, call.getArguments(), adapter, call.isSafe(), call.isSpreadSafe(), false);
        } else {
            this.makeCall(objectExpression, messageName, call.getArguments(), adapter, call.isSafe(), call.isSpreadSafe(), call.isImplicitThis());
        }
    }

    private void makeCall(Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        ClassNode cn = this.classNode;
        if (this.isInClosure() && !implicitThis) {
            cn = this.getOutermostClass();
        }
        this.makeCall(new ClassExpression(cn), receiver, message, arguments, adapter, safe, spreadSafe, implicitThis);
    }

    private void makeCall(ClassExpression sender, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        boolean containsSpreadExpression;
        boolean lhs = this.leftHandExpression;
        this.leftHandExpression = false;
        sender.visit(this);
        boolean oldVal = this.implicitThis;
        this.implicitThis = implicitThis;
        this.visitAndAutoboxBoolean(receiver);
        this.implicitThis = oldVal;
        if (message != null) {
            message.visit(this);
        }
        int numberOfArguments = (containsSpreadExpression = AsmClassGenerator.containsSpreadExpression(arguments)) ? -1 : AsmClassGenerator.argumentSize(arguments);
        if (numberOfArguments > 0 || containsSpreadExpression) {
            ArgumentListExpression ae;
            if (arguments instanceof ArgumentListExpression) {
                ae = (ArgumentListExpression)arguments;
            } else if (arguments instanceof TupleExpression) {
                TupleExpression te = (TupleExpression)arguments;
                ae = new ArgumentListExpression(te.getExpressions());
            } else {
                ae = new ArgumentListExpression();
                ae.addExpression(arguments);
            }
            if (containsSpreadExpression) {
                this.despreadList(ae.getExpressions(), true);
            } else {
                ae.visit(this);
            }
        } else if (numberOfArguments > 0) {
            TupleExpression te = (TupleExpression)arguments;
            for (int i = 0; i < numberOfArguments; ++i) {
                Expression argument = te.getExpression(i);
                this.visitAndAutoboxBoolean(argument);
                if (!(argument instanceof CastExpression)) continue;
                this.loadWrapper(argument);
            }
        }
        adapter.call(this.mv, numberOfArguments, safe, spreadSafe);
        this.leftHandExpression = lhs;
    }

    private void despreadList(List expressions, boolean wrap) {
        ArrayList<ConstantExpression> spreadIndexes = new ArrayList<ConstantExpression>();
        ArrayList<Expression> spreadExpressions = new ArrayList<Expression>();
        ArrayList normalArguments = new ArrayList();
        for (int i = 0; i < expressions.size(); ++i) {
            Object expr = expressions.get(i);
            if (!(expr instanceof SpreadExpression)) {
                normalArguments.add(expr);
                continue;
            }
            spreadIndexes.add(new ConstantExpression(new Integer(i - spreadExpressions.size())));
            spreadExpressions.add(((SpreadExpression)expr).getExpression());
        }
        this.visitTupleExpression(new ArgumentListExpression(normalArguments), wrap);
        new TupleExpression(spreadExpressions).visit(this);
        new ArrayExpression(ClassHelper.int_TYPE, spreadIndexes, null).visit(this);
        despreadList.call(this.mv);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        this.onLineNumber(call, "visitMethodCallExpression: \"" + call.getMethod() + "\":");
        Expression arguments = call.getArguments();
        String methodName = call.getMethodAsString();
        boolean isSuperMethodCall = AsmClassGenerator.usesSuper(call);
        boolean isThisExpression = AsmClassGenerator.isThisExpression(call.getObjectExpression());
        if (methodName != null && isThisExpression && this.isFieldOrVariable(methodName) && !this.classNode.hasPossibleMethod(methodName, arguments)) {
            this.visitVariableExpression(new VariableExpression(methodName));
            if (arguments instanceof TupleExpression) {
                arguments.visit(this);
            } else {
                new TupleExpression(arguments).visit(this);
            }
            invokeClosureMethod.call(this.mv);
        } else {
            MethodCallerMultiAdapter adapter = invokeMethod;
            if (isThisExpression) {
                adapter = invokeMethodOnCurrent;
            }
            if (isSuperMethodCall) {
                adapter = invokeMethodOnSuper;
            }
            if (this.isStaticInvocation(call)) {
                adapter = invokeStaticMethod;
            }
            this.makeInvokeMethodCall(call, isSuperMethodCall, adapter);
        }
    }

    private boolean isStaticInvocation(MethodCallExpression call) {
        if (!AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
            return false;
        }
        if (this.isStaticMethod()) {
            return true;
        }
        return this.isStaticContext() && !call.isImplicitThis();
    }

    protected boolean emptyArguments(Expression arguments) {
        return AsmClassGenerator.argumentSize(arguments) == 0;
    }

    protected static boolean containsSpreadExpression(Expression arguments) {
        List args = null;
        if (arguments instanceof TupleExpression) {
            TupleExpression tupleExpression = (TupleExpression)arguments;
            args = tupleExpression.getExpressions();
        } else if (arguments instanceof ListExpression) {
            ListExpression le = (ListExpression)arguments;
            args = le.getExpressions();
        } else {
            return arguments instanceof SpreadExpression;
        }
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof SpreadExpression)) continue;
            return true;
        }
        return false;
    }

    protected static int argumentSize(Expression arguments) {
        if (arguments instanceof TupleExpression) {
            TupleExpression tupleExpression = (TupleExpression)arguments;
            int size = tupleExpression.getExpressions().size();
            return size;
        }
        return 1;
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        this.onLineNumber(call, "visitStaticMethodCallExpression: \"" + call.getMethod() + "\":");
        this.makeCall(new ClassExpression(call.getOwnerType()), new ConstantExpression(call.getMethod()), call.getArguments(), invokeStaticMethod, false, false, false);
    }

    private void addGeneratedClosureConstructorCall(ConstructorCallExpression call) {
        this.mv.visitVarInsn(25, 0);
        ClassNode callNode = this.classNode.getSuperClass();
        TupleExpression arguments = (TupleExpression)call.getArguments();
        if (arguments.getExpressions().size() != 2) {
            throw new GroovyBugError("expected 2 arguments for closure constructor super call, but got" + arguments.getExpressions().size());
        }
        arguments.getExpression(0).visit(this);
        arguments.getExpression(1).visit(this);
        Parameter p = new Parameter(ClassHelper.OBJECT_TYPE, "_p");
        String descriptor = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, new Parameter[]{p, p});
        this.mv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(callNode), "<init>", descriptor);
    }

    private void visitSpecialConstructorCall(ConstructorCallExpression call) {
        if (this.classNode.declaresInterface(ClassHelper.GENERATED_CLOSURE_Type)) {
            this.addGeneratedClosureConstructorCall(call);
            return;
        }
        ClassNode callNode = this.classNode;
        if (call.isSuperCall()) {
            callNode = callNode.getSuperClass();
        }
        List constructors = this.sortConstructors(call, callNode);
        call.getArguments().visit(this);
        this.mv.visitInsn(89);
        this.helper.pushConstant(constructors.size());
        this.visitClassExpression(new ClassExpression(callNode));
        selectConstructorAndTransformArguments.call(this.mv);
        this.mv.visitInsn(90);
        this.mv.visitInsn(4);
        this.mv.visitInsn(126);
        Label afterIf = new Label();
        this.mv.visitJumpInsn(153, afterIf);
        this.mv.visitInsn(3);
        this.mv.visitInsn(50);
        this.mv.visitTypeInsn(192, "[Ljava/lang/Object;");
        this.mv.visitLabel(afterIf);
        this.mv.visitInsn(95);
        if (this.constructorNode != null) {
            this.mv.visitVarInsn(25, 0);
        } else {
            this.mv.visitTypeInsn(187, BytecodeHelper.getClassInternalName(callNode));
        }
        this.mv.visitInsn(95);
        this.mv.visitIntInsn(16, 8);
        this.mv.visitInsn(122);
        Label[] targets = new Label[constructors.size()];
        int[] indices = new int[constructors.size()];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = new Label();
            indices[i] = i;
        }
        Label defaultLabel = new Label();
        Label afterSwitch = new Label();
        this.mv.visitLookupSwitchInsn(defaultLabel, indices, targets);
        for (int i = 0; i < targets.length; ++i) {
            this.mv.visitLabel(targets[i]);
            if (this.constructorNode != null) {
                this.mv.visitInsn(95);
                this.mv.visitInsn(90);
            } else {
                this.mv.visitInsn(90);
                this.mv.visitInsn(93);
                this.mv.visitInsn(87);
            }
            ConstructorNode cn = (ConstructorNode)constructors.get(i);
            String descriptor = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, cn.getParameters());
            Parameter[] parameters = cn.getParameters();
            for (int p = 0; p < parameters.length; ++p) {
                this.mv.visitInsn(89);
                this.helper.pushConstant(p);
                this.mv.visitInsn(50);
                ClassNode type = parameters[p].getType();
                if (ClassHelper.isPrimitiveType(type)) {
                    this.helper.unbox(type);
                } else {
                    this.helper.doCast(type);
                }
                this.helper.swapWithObject(type);
            }
            this.mv.visitInsn(87);
            this.mv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(callNode), "<init>", descriptor);
            this.mv.visitJumpInsn(167, afterSwitch);
        }
        this.mv.visitLabel(defaultLabel);
        this.mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn("illegal constructor number");
        this.mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        this.mv.visitInsn(191);
        this.mv.visitLabel(afterSwitch);
        if (this.constructorNode == null) {
            this.mv.visitInsn(95);
        }
        this.mv.visitInsn(87);
    }

    private List sortConstructors(ConstructorCallExpression call, ClassNode callNode) {
        ArrayList constructors = new ArrayList(callNode.getDeclaredConstructors());
        Comparator comp = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ConstructorNode c0 = (ConstructorNode)arg0;
                ConstructorNode c1 = (ConstructorNode)arg1;
                AsmClassGenerator.this.helper;
                String descriptor0 = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, c0.getParameters());
                AsmClassGenerator.this.helper;
                String descriptor1 = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, c1.getParameters());
                return descriptor0.compareTo(descriptor1);
            }
        };
        Collections.sort(constructors, comp);
        return constructors;
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        TupleExpression tupleExpression;
        int size;
        this.onLineNumber(call, "visitConstructorCallExpression: \"" + call.getType().getName() + "\":");
        if (call.isSpecialCall()) {
            this.visitSpecialConstructorCall(call);
            return;
        }
        Expression arguments = call.getArguments();
        if (arguments instanceof TupleExpression && (size = (tupleExpression = (TupleExpression)arguments).getExpressions().size()) == 0) {
            arguments = MethodCallExpression.NO_ARGUMENTS;
        }
        ClassExpression receiverClass = new ClassExpression(call.getType());
        this.makeCall(receiverClass, null, arguments, invokeNew, false, false, false);
    }

    private static String makeFieldClassName(ClassNode type) {
        String internalName = BytecodeHelper.getClassInternalName(type);
        StringBuffer ret = new StringBuffer(internalName.length());
        for (int i = 0; i < internalName.length(); ++i) {
            char c = internalName.charAt(i);
            if (c == '/') {
                ret.append('$');
                continue;
            }
            if (c == ';') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    private static String getStaticFieldName(ClassNode type) {
        ClassNode componentType = type;
        String prefix = "";
        while (componentType.isArray()) {
            prefix = prefix + "$";
            componentType = componentType.getComponentType();
        }
        if (prefix.length() != 0) {
            prefix = "array" + prefix;
        }
        String name = prefix + "class$" + AsmClassGenerator.makeFieldClassName(componentType);
        return name;
    }

    private void visitAttributeOrProperty(PropertyExpression expression, MethodCallerMultiAdapter adapter) {
        Expression objectExpression = expression.getObjectExpression();
        if (AsmClassGenerator.isThisOrSuper(objectExpression)) {
            String name = expression.getPropertyAsString();
            if (name != null) {
                FieldNode field = null;
                field = AsmClassGenerator.isSuperExpression(objectExpression) ? this.classNode.getSuperClass().getDeclaredField(name) : this.classNode.getDeclaredField(name);
                if (field != null) {
                    this.visitFieldExpression(new FieldExpression(field));
                    return;
                }
            }
            if (AsmClassGenerator.isSuperExpression(objectExpression)) {
                String prefix = this.leftHandExpression ? "set" : "get";
                String propName = prefix + MetaClassHelper.capitalize(name);
                this.visitMethodCallExpression(new MethodCallExpression(objectExpression, propName, MethodCallExpression.NO_ARGUMENTS));
                return;
            }
        }
        this.makeCall(objectExpression, new CastExpression(ClassHelper.STRING_TYPE, expression.getProperty()), MethodCallExpression.NO_ARGUMENTS, adapter, expression.isSafe(), expression.isSpreadSafe(), expression.isImplicitThis());
    }

    private boolean isStaticContext() {
        if (!this.isInClosure()) {
            return false;
        }
        if (this.constructorNode != null) {
            return false;
        }
        return this.classNode.isStaticClass() || this.methodNode.isStatic();
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        MethodCallerMultiAdapter adapter;
        Expression objectExpression = expression.getObjectExpression();
        if (this.leftHandExpression) {
            adapter = setProperty;
            if (this.isGroovyObject(objectExpression)) {
                adapter = setGroovyObjectProperty;
            }
            if (this.isStaticContext() && AsmClassGenerator.isThisOrSuper(objectExpression)) {
                adapter = setProperty;
            }
        } else {
            adapter = getProperty;
            if (this.isGroovyObject(objectExpression)) {
                adapter = getGroovyObjectProperty;
            }
            if (this.isStaticContext() && AsmClassGenerator.isThisOrSuper(objectExpression)) {
                adapter = getProperty;
            }
        }
        this.visitAttributeOrProperty(expression, adapter);
    }

    public void visitAttributeExpression(AttributeExpression expression) {
        MethodCallerMultiAdapter adapter;
        Expression objectExpression = expression.getObjectExpression();
        if (this.leftHandExpression) {
            adapter = setField;
            if (this.isGroovyObject(objectExpression)) {
                adapter = setGroovyObjectField;
            }
            if (AsmClassGenerator.usesSuper(expression)) {
                adapter = setFieldOnSuper;
            }
        } else {
            adapter = getField;
            if (this.isGroovyObject(objectExpression)) {
                adapter = getGroovyObjectField;
            }
            if (AsmClassGenerator.usesSuper(expression)) {
                adapter = getFieldOnSuper;
            }
        }
        this.visitAttributeOrProperty(expression, adapter);
    }

    protected boolean isGroovyObject(Expression objectExpression) {
        return AsmClassGenerator.isThisExpression(objectExpression);
    }

    public void visitFieldExpression(FieldExpression expression) {
        FieldNode field = expression.getField();
        if (field.isStatic()) {
            if (this.leftHandExpression) {
                this.storeStaticField(expression);
            } else {
                this.loadStaticField(expression);
            }
        } else if (this.leftHandExpression) {
            this.storeThisInstanceField(expression);
        } else {
            this.loadInstanceField(expression);
        }
    }

    public void loadStaticField(FieldExpression fldExp) {
        String ownerName;
        FieldNode field = fldExp.getField();
        boolean holder = field.isHolder() && !this.isInClosureConstructor();
        ClassNode type = field.getType();
        String string = ownerName = field.getOwner().equals(this.classNode) ? this.internalClassName : BytecodeHelper.getClassInternalName(field.getOwner());
        if (holder) {
            this.mv.visitFieldInsn(178, ownerName, fldExp.getFieldName(), BytecodeHelper.getTypeDescription(type));
            this.mv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
        } else {
            this.mv.visitFieldInsn(178, ownerName, fldExp.getFieldName(), BytecodeHelper.getTypeDescription(type));
            if (ClassHelper.isPrimitiveType(type)) {
                this.helper.box(type);
            }
        }
    }

    public void loadInstanceField(FieldExpression fldExp) {
        FieldNode field = fldExp.getField();
        boolean holder = field.isHolder() && !this.isInClosureConstructor();
        ClassNode type = field.getType();
        String ownerName = field.getOwner().equals(this.classNode) ? this.internalClassName : BytecodeHelper.getClassInternalName(field.getOwner());
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, ownerName, fldExp.getFieldName(), BytecodeHelper.getTypeDescription(type));
        if (holder) {
            this.mv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
        } else if (ClassHelper.isPrimitiveType(type)) {
            this.helper.box(type);
        }
    }

    public void storeThisInstanceField(FieldExpression expression) {
        String ownerName;
        FieldNode field = expression.getField();
        boolean holder = field.isHolder() && !this.isInClosureConstructor();
        ClassNode type = field.getType();
        String string = ownerName = field.getOwner().equals(this.classNode) ? this.internalClassName : BytecodeHelper.getClassInternalName(field.getOwner());
        if (holder) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
        } else {
            if (this.isInClosureConstructor()) {
                this.helper.doCast(type);
            } else if (!ClassHelper.isPrimitiveType(type)) {
                this.doConvertAndCast(type);
            }
            this.mv.visitVarInsn(25, 0);
            this.mv.visitInsn(95);
            this.helper.unbox(type);
            this.helper.putField(field, ownerName);
        }
    }

    public void storeStaticField(FieldExpression expression) {
        String ownerName;
        FieldNode field = expression.getField();
        boolean holder = field.isHolder() && !this.isInClosureConstructor();
        ClassNode type = field.getType();
        String string = field.getOwner().equals(this.classNode) ? this.internalClassName : (ownerName = BytecodeHelper.getClassInternalName(field.getOwner()));
        if (holder) {
            this.mv.visitFieldInsn(178, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
        } else {
            this.helper.doCast(type);
            this.mv.visitFieldInsn(179, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
        }
    }

    protected void visitOuterFieldExpression(FieldExpression expression, ClassNode outerClassNode, int steps, boolean first) {
        FieldNode field = expression.getField();
        boolean isStatic = field.isStatic();
        int tempIdx = this.compileStack.defineTemporaryVariable(field, this.leftHandExpression && first);
        if (steps > 1 || !isStatic) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.internalClassName, "owner", BytecodeHelper.getTypeDescription(outerClassNode));
        }
        if (steps == 1) {
            int opcode = this.leftHandExpression ? (isStatic ? 179 : 181) : (isStatic ? 178 : 180);
            String ownerName = BytecodeHelper.getClassInternalName(outerClassNode);
            if (this.leftHandExpression) {
                boolean holder;
                this.mv.visitVarInsn(25, tempIdx);
                boolean bl = holder = field.isHolder() && !this.isInClosureConstructor();
                if (!holder) {
                    this.doConvertAndCast(field.getType());
                }
            }
            this.mv.visitFieldInsn(opcode, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(field.getType()));
            if (!this.leftHandExpression && ClassHelper.isPrimitiveType(field.getType())) {
                this.helper.box(field.getType());
            }
        } else {
            this.visitOuterFieldExpression(expression, outerClassNode.getOuterClass(), steps - 1, false);
        }
    }

    public void visitVariableExpression(VariableExpression expression) {
        String variableName = expression.getName();
        ClassNode classNode = this.classNode;
        if (this.isInClosure()) {
            classNode = this.getOutermostClass();
        }
        if (variableName.equals("this")) {
            if (this.isStaticMethod() || !this.implicitThis && this.isStaticContext()) {
                this.visitClassExpression(new ClassExpression(classNode));
            } else {
                this.loadThis();
            }
            return;
        }
        if (variableName.equals("super")) {
            if (this.isStaticMethod()) {
                this.visitClassExpression(new ClassExpression(classNode.getSuperClass()));
            } else {
                this.loadThis();
            }
            return;
        }
        Variable variable = this.compileStack.getVariable(variableName, false);
        VariableScope scope = this.compileStack.getScope();
        if (variable == null) {
            this.processClassVariable(variableName);
        } else {
            this.processStackVariable(variable);
        }
    }

    private void loadThis() {
        this.mv.visitVarInsn(25, 0);
        if (!this.implicitThis && this.isInClosure()) {
            this.mv.visitMethodInsn(182, "groovy/lang/Closure", "getThisObject", "()Ljava/lang/Object;");
        }
    }

    protected void processStackVariable(Variable variable) {
        if (this.leftHandExpression) {
            this.helper.storeVar(variable);
        } else {
            this.helper.loadVar(variable);
        }
    }

    protected void processClassVariable(String name) {
        if (this.passingClosureParams && this.isInScriptBody()) {
            this.mv.visitTypeInsn(187, "org/codehaus/groovy/runtime/ScriptReference");
            this.mv.visitInsn(89);
            this.loadThisOrOwner();
            this.mv.visitLdcInsn(name);
            this.mv.visitMethodInsn(183, "org/codehaus/groovy/runtime/ScriptReference", "<init>", "(Lgroovy/lang/Script;Ljava/lang/String;)V");
        } else {
            PropertyExpression pexp = new PropertyExpression((Expression)VariableExpression.THIS_EXPRESSION, name);
            pexp.setImplicitThis(true);
            this.visitPropertyExpression(pexp);
        }
    }

    protected void processFieldAccess(String name, FieldNode field, int steps) {
        FieldExpression expression = new FieldExpression(field);
        if (steps == 0) {
            this.visitFieldExpression(expression);
        } else {
            this.visitOuterFieldExpression(expression, this.classNode.getOuterClass(), steps, true);
        }
    }

    protected boolean isInScriptBody() {
        if (this.classNode.isScriptBody()) {
            return true;
        }
        return this.classNode.isScript() && this.methodNode != null && this.methodNode.getName().equals("run");
    }

    protected boolean isPopRequired(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            return expression.getType() != ClassHelper.VOID_TYPE;
        }
        if (expression instanceof DeclarationExpression) {
            return false;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)expression;
            binExp.getOperation().getType();
        }
        if (expression instanceof ConstructorCallExpression) {
            ConstructorCallExpression cce = (ConstructorCallExpression)expression;
            return !cce.isSpecialCall();
        }
        return true;
    }

    protected void createInterfaceSyntheticStaticFields() {
        if (this.syntheticStaticFields.isEmpty()) {
            return;
        }
        this.addInnerClass(this.interfaceClassLoadingClass);
        Iterator iter = this.syntheticStaticFields.iterator();
        while (iter.hasNext()) {
            String staticFieldName = (String)iter.next();
            this.interfaceClassLoadingClass.addField(staticFieldName, 4104, ClassHelper.CLASS_Type, null);
        }
    }

    protected void createSyntheticStaticFields() {
        Iterator iter = this.syntheticStaticFields.iterator();
        while (iter.hasNext()) {
            String staticFieldName = (String)iter.next();
            FieldNode fn = this.classNode.getDeclaredField(staticFieldName);
            if (fn != null) {
                boolean modifiers;
                boolean type = fn.getType() == ClassHelper.CLASS_Type;
                boolean bl = modifiers = fn.getModifiers() == 4104;
                if (type && modifiers) continue;
                String text = "";
                if (!type) {
                    text = " with wrong type: " + fn.getType() + " (java.lang.Class needed)";
                }
                if (!modifiers) {
                    text = " with wrong modifiers: " + fn.getModifiers() + " (" + 4104 + " needed)";
                }
                this.throwException("tried to set a static syntethic field " + staticFieldName + " in " + this.classNode.getName() + " for class resolving, but found alreeady a node of that" + " name " + text);
                continue;
            }
            this.cv.visitField(4104, staticFieldName, "Ljava/lang/Class;", null, null);
        }
        this.mv = this.cv.visitMethod(4104, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", null, null);
        Label l0 = new Label();
        this.mv.visitLabel(l0);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        Label l1 = new Label();
        this.mv.visitLabel(l1);
        this.mv.visitInsn(176);
        Label l2 = new Label();
        this.mv.visitLabel(l2);
        this.mv.visitVarInsn(58, 1);
        this.mv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(182, "java/lang/ClassNotFoundException", "getMessage", "()Ljava/lang/String;");
        this.mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V");
        this.mv.visitInsn(191);
        this.mv.visitTryCatchBlock(l0, l2, l2, "java/lang/ClassNotFoundException");
        this.mv.visitMaxs(3, 2);
    }

    public void visitClassExpression(ClassExpression expression) {
        ClassNode type = expression.getType();
        if (ClassHelper.isPrimitiveType(type)) {
            ClassNode objectType = ClassHelper.getWrapper(type);
            this.mv.visitFieldInsn(178, BytecodeHelper.getClassInternalName(objectType), "TYPE", "Ljava/lang/Class;");
        } else {
            String staticFieldName;
            if (type.equals(this.classNode)) {
                staticFieldName = "class$0";
                if (this.compileStack.getCurrentClassIndex() != -1) {
                    this.mv.visitVarInsn(25, this.compileStack.getCurrentClassIndex());
                    return;
                }
            } else if (type.equals(ClassHelper.METACLASS_TYPE)) {
                staticFieldName = AsmClassGenerator.getStaticFieldName(type);
                if (this.compileStack.getCurrentMetaClassIndex() != -1) {
                    this.mv.visitVarInsn(25, this.compileStack.getCurrentMetaClassIndex());
                    return;
                }
            } else {
                staticFieldName = AsmClassGenerator.getStaticFieldName(type);
            }
            this.syntheticStaticFields.add(staticFieldName);
            String internalClassName = this.internalClassName;
            if (this.classNode.isInterface()) {
                internalClassName = BytecodeHelper.getClassInternalName(this.interfaceClassLoadingClass);
            }
            this.mv.visitFieldInsn(178, internalClassName, staticFieldName, "Ljava/lang/Class;");
            Label l0 = new Label();
            this.mv.visitJumpInsn(199, l0);
            this.mv.visitLdcInsn(BytecodeHelper.getClassLoadingTypeDescription(type));
            this.mv.visitMethodInsn(184, internalClassName, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
            this.mv.visitInsn(89);
            this.mv.visitFieldInsn(179, internalClassName, staticFieldName, "Ljava/lang/Class;");
            Label l1 = new Label();
            this.mv.visitJumpInsn(167, l1);
            this.mv.visitLabel(l0);
            this.mv.visitFieldInsn(178, internalClassName, staticFieldName, "Ljava/lang/Class;");
            this.mv.visitLabel(l1);
            if (type.equals(this.classNode)) {
                this.mv.visitInsn(89);
                int index = this.compileStack.defineTemporaryVariable("class$0", ClassHelper.CLASS_Type, true);
                this.compileStack.setCurrentClassIndex(index);
            } else if (type.equals(ClassHelper.METACLASS_TYPE)) {
                this.mv.visitInsn(89);
                int index = this.compileStack.defineTemporaryVariable("meta$class$0", ClassHelper.CLASS_Type, true);
                this.compileStack.setCurrentMetaClassIndex(index);
            }
        }
    }

    public void visitRangeExpression(RangeExpression expression) {
        expression.getFrom().visit(this);
        expression.getTo().visit(this);
        this.helper.pushConstant(expression.isInclusive());
        createRangeMethod.call(this.mv);
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        throw new GroovyBugError("MapEntryExpression should not be visited here");
    }

    public void visitMapExpression(MapExpression expression) {
        List entries = expression.getMapEntryExpressions();
        int size = entries.size();
        this.helper.pushConstant(size * 2);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            MapEntryExpression entry = (MapEntryExpression)object;
            this.mv.visitInsn(89);
            this.helper.pushConstant(i++);
            this.visitAndAutoboxBoolean(entry.getKeyExpression());
            this.mv.visitInsn(83);
            this.mv.visitInsn(89);
            this.helper.pushConstant(i++);
            this.visitAndAutoboxBoolean(entry.getValueExpression());
            this.mv.visitInsn(83);
        }
        createMapMethod.call(this.mv);
    }

    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        if (AsmClassGenerator.containsSpreadExpression(ale)) {
            this.despreadList(ale.getExpressions(), true);
        } else {
            this.visitTupleExpression(ale, true);
        }
    }

    public void visitTupleExpression(TupleExpression expression) {
        this.visitTupleExpression(expression, false);
    }

    private void visitTupleExpression(TupleExpression expression, boolean useWrapper) {
        int size = expression.getExpressions().size();
        this.helper.pushConstant(size);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < size; ++i) {
            this.mv.visitInsn(89);
            this.helper.pushConstant(i);
            Expression argument = expression.getExpression(i);
            this.visitAndAutoboxBoolean(argument);
            if (useWrapper && argument instanceof CastExpression) {
                this.loadWrapper(argument);
            }
            this.mv.visitInsn(83);
        }
    }

    private void loadWrapper(Expression argument) {
        ClassNode goalClass = argument.getType();
        this.visitClassExpression(new ClassExpression(goalClass));
        if (goalClass.isDerivedFromGroovyObject()) {
            createGroovyObjectWrapperMethod.call(this.mv);
        } else {
            createPojoWrapperMethod.call(this.mv);
        }
    }

    public void visitArrayExpression(ArrayExpression expression) {
        ClassNode elementType = expression.getElementType();
        String arrayTypeName = BytecodeHelper.getClassInternalName(elementType);
        List sizeExpression = expression.getSizeExpression();
        int size = 0;
        int dimensions = 0;
        if (sizeExpression != null) {
            Expression element;
            Iterator iter = sizeExpression.iterator();
            while (iter.hasNext() && (element = (Expression)iter.next()) != ConstantExpression.EMTPY_EXPRESSION) {
                ++dimensions;
                this.visitAndAutoboxBoolean(element);
                this.helper.unbox(Integer.TYPE);
            }
        } else {
            size = expression.getExpressions().size();
            this.helper.pushConstant(size);
        }
        int storeIns = 83;
        if (sizeExpression != null) {
            arrayTypeName = BytecodeHelper.getTypeDescription(expression.getType());
            this.mv.visitMultiANewArrayInsn(arrayTypeName, dimensions);
        } else if (ClassHelper.isPrimitiveType(elementType)) {
            int primType = 0;
            if (elementType == ClassHelper.boolean_TYPE) {
                primType = 4;
                storeIns = 84;
            } else if (elementType == ClassHelper.char_TYPE) {
                primType = 5;
                storeIns = 85;
            } else if (elementType == ClassHelper.float_TYPE) {
                primType = 6;
                storeIns = 81;
            } else if (elementType == ClassHelper.double_TYPE) {
                primType = 7;
                storeIns = 82;
            } else if (elementType == ClassHelper.byte_TYPE) {
                primType = 8;
                storeIns = 84;
            } else if (elementType == ClassHelper.short_TYPE) {
                primType = 9;
                storeIns = 86;
            } else if (elementType == ClassHelper.int_TYPE) {
                primType = 10;
                storeIns = 79;
            } else if (elementType == ClassHelper.long_TYPE) {
                primType = 11;
                storeIns = 80;
            }
            this.mv.visitIntInsn(188, primType);
        } else {
            this.mv.visitTypeInsn(189, arrayTypeName);
        }
        for (int i = 0; i < size; ++i) {
            this.mv.visitInsn(89);
            this.helper.pushConstant(i);
            Expression elementExpression = expression.getExpression(i);
            if (elementExpression == null) {
                ConstantExpression.NULL.visit(this);
            } else if (!elementType.equals(elementExpression.getType())) {
                this.visitCastExpression(new CastExpression(elementType, elementExpression, true));
            } else {
                this.visitAndAutoboxBoolean(elementExpression);
            }
            this.mv.visitInsn(storeIns);
        }
        if (sizeExpression == null && ClassHelper.isPrimitiveType(elementType)) {
            int par = this.compileStack.defineTemporaryVariable("par", true);
            this.mv.visitVarInsn(25, par);
        }
    }

    public void visitClosureListExpression(ClosureListExpression expression) {
        this.compileStack.pushVariableScope(expression.getVariableScope());
        List expressions = expression.getExpressions();
        final int size = expressions.size();
        LinkedList declarations = new LinkedList();
        for (int i = 0; i < size; ++i) {
            Object expr = expressions.get(i);
            if (!(expr instanceof DeclarationExpression)) continue;
            declarations.add(expr);
            DeclarationExpression de = (DeclarationExpression)expr;
            BinaryExpression be = new BinaryExpression(de.getLeftExpression(), de.getOperation(), de.getRightExpression());
            expressions.set(i, be);
            de.setRightExpression(ConstantExpression.NULL);
            this.visitDeclarationExpression(de);
        }
        LinkedList<Object> instructions = new LinkedList<Object>();
        BytecodeSequence seq = new BytecodeSequence(instructions);
        BlockStatement bs = new BlockStatement();
        bs.addStatement(seq);
        Parameter closureIndex = new Parameter(ClassHelper.int_TYPE, "__closureIndex");
        ClosureExpression ce = new ClosureExpression(new Parameter[]{closureIndex}, bs);
        ce.setVariableScope(expression.getVariableScope());
        instructions.add(ConstantExpression.NULL);
        final Label dflt = new Label();
        final Label tableEnd = new Label();
        final Label[] labels = new Label[size];
        instructions.add(new BytecodeInstruction(){

            public void visit(MethodVisitor mv) {
                mv.visitVarInsn(21, 1);
                mv.visitTableSwitchInsn(0, size - 1, dflt, labels);
            }
        });
        for (int i = 0; i < size; ++i) {
            final Label label = new Label();
            Object expr = expressions.get(i);
            final boolean isStatement = expr instanceof Statement;
            labels[i] = label;
            instructions.add(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitLabel(label);
                    if (!isStatement) {
                        mv.visitInsn(87);
                    }
                }
            });
            instructions.add(expr);
            instructions.add(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitJumpInsn(167, tableEnd);
                }
            });
        }
        instructions.add(new BytecodeInstruction(){

            public void visit(MethodVisitor mv) {
                mv.visitLabel(dflt);
            }
        });
        ConstantExpression text = new ConstantExpression("invalid index for closure");
        ConstructorCallExpression cce = new ConstructorCallExpression(ClassHelper.make(IllegalArgumentException.class), text);
        ThrowStatement ts = new ThrowStatement(cce);
        instructions.add(ts);
        instructions.add(new BytecodeInstruction(){

            public void visit(MethodVisitor mv) {
                mv.visitLabel(tableEnd);
                mv.visitInsn(176);
            }
        });
        this.visitClosureExpression(ce);
        this.helper.pushConstant(size);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int listArrayVar = this.compileStack.defineTemporaryVariable("_listOfClosures", true);
        for (int i = 0; i < size; ++i) {
            this.mv.visitTypeInsn(187, "org/codehaus/groovy/runtime/CurriedClosure");
            this.mv.visitInsn(92);
            this.mv.visitInsn(95);
            this.helper.pushConstant(i);
            this.mv.visitMethodInsn(183, "org/codehaus/groovy/runtime/CurriedClosure", "<init>", "(Lgroovy/lang/Closure;I)V");
            this.mv.visitVarInsn(25, listArrayVar);
            this.mv.visitInsn(95);
            this.helper.pushConstant(i);
            this.mv.visitInsn(95);
            this.mv.visitInsn(83);
        }
        this.mv.visitInsn(87);
        this.mv.visitVarInsn(25, listArrayVar);
        createListMethod.call(this.mv);
        this.compileStack.removeVar(listArrayVar);
        this.compileStack.pop();
    }

    public void visitBytecodeSequence(BytecodeSequence bytecodeSequence) {
        List instructions = bytecodeSequence.getInstructions();
        Iterator iterator = instructions.iterator();
        while (iterator.hasNext()) {
            Object part = iterator.next();
            if (part == EmptyExpression.INSTANCE) {
                this.mv.visitInsn(1);
                continue;
            }
            if (part instanceof Expression) {
                this.visitAndAutoboxBoolean((Expression)part);
                continue;
            }
            if (part instanceof Statement) {
                Statement stm = (Statement)part;
                stm.visit(this);
                this.mv.visitInsn(1);
                continue;
            }
            BytecodeInstruction runner = (BytecodeInstruction)part;
            runner.visit(this.mv);
        }
    }

    public void visitListExpression(ListExpression expression) {
        this.onLineNumber(expression, "ListExpression");
        int size = expression.getExpressions().size();
        boolean containsSpreadExpression = AsmClassGenerator.containsSpreadExpression(expression);
        if (!containsSpreadExpression) {
            this.helper.pushConstant(size);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            for (int i = 0; i < size; ++i) {
                this.mv.visitInsn(89);
                this.helper.pushConstant(i);
                this.visitAndAutoboxBoolean(expression.getExpression(i));
                this.mv.visitInsn(83);
            }
        } else {
            this.despreadList(expression.getExpressions(), false);
        }
        createListMethod.call(this.mv);
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.mv.visitTypeInsn(187, "org/codehaus/groovy/runtime/GStringImpl");
        this.mv.visitInsn(89);
        int size = expression.getValues().size();
        this.helper.pushConstant(size);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < size; ++i) {
            this.mv.visitInsn(89);
            this.helper.pushConstant(i);
            this.visitAndAutoboxBoolean(expression.getValue(i));
            this.mv.visitInsn(83);
        }
        List strings = expression.getStrings();
        size = strings.size();
        this.helper.pushConstant(size);
        this.mv.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < size; ++i) {
            this.mv.visitInsn(89);
            this.helper.pushConstant(i);
            this.mv.visitLdcInsn(((ConstantExpression)strings.get(i)).getValue());
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(183, "org/codehaus/groovy/runtime/GStringImpl", "<init>", "([Ljava/lang/Object;[Ljava/lang/String;)V");
    }

    public void visitAnnotations(AnnotatedNode node) {
    }

    private void visitAnnotations(AnnotatedNode targetNode, Object visitor) {
        Map annotionMap = targetNode.getAnnotations();
        if (annotionMap.isEmpty()) {
            return;
        }
        Iterator it = annotionMap.values().iterator();
        while (it.hasNext()) {
            AnnotationNode an = (AnnotationNode)it.next();
            if (an.isBuiltIn() || an.hasSourceRetention()) continue;
            AnnotationVisitor av = this.getAnnotationVisitor(targetNode, an, visitor);
            this.visitAnnotationAttributes(an, av);
            av.visitEnd();
        }
    }

    private void visitParameterAnnotations(Parameter parameter, int paramNumber, MethodVisitor mv) {
        Map annotionMap = parameter.getAnnotations();
        if (annotionMap.isEmpty()) {
            return;
        }
        Iterator it = annotionMap.values().iterator();
        while (it.hasNext()) {
            AnnotationNode an = (AnnotationNode)it.next();
            if (an.isBuiltIn() || an.hasSourceRetention()) continue;
            String annotationDescriptor = BytecodeHelper.getTypeDescription(an.getClassNode());
            AnnotationVisitor av = mv.visitParameterAnnotation(paramNumber, annotationDescriptor, an.hasRuntimeRetention());
            this.visitAnnotationAttributes(an, av);
            av.visitEnd();
        }
    }

    private AnnotationVisitor getAnnotationVisitor(AnnotatedNode targetNode, AnnotationNode an, Object visitor) {
        String annotationDescriptor = BytecodeHelper.getTypeDescription(an.getClassNode());
        if (targetNode instanceof MethodNode) {
            return ((MethodVisitor)visitor).visitAnnotation(annotationDescriptor, an.hasRuntimeRetention());
        }
        if (targetNode instanceof FieldNode) {
            return ((FieldVisitor)visitor).visitAnnotation(annotationDescriptor, an.hasRuntimeRetention());
        }
        if (targetNode instanceof ClassNode) {
            return ((ClassVisitor)visitor).visitAnnotation(annotationDescriptor, an.hasRuntimeRetention());
        }
        this.throwException("Cannot create an AnnotationVisitor. Please report Groovy bug");
        return null;
    }

    private void visitAnnotationAttributes(AnnotationNode an, AnnotationVisitor av) {
        Map.Entry entry;
        HashMap<String, Object> constantAttrs = new HashMap<String, Object>();
        HashMap<String, Expression> enumAttrs = new HashMap<String, Expression>();
        HashMap<String, Object> atAttrs = new HashMap<String, Object>();
        HashMap<String, Expression> arrayAttrs = new HashMap<String, Expression>();
        Iterator mIt = an.getMembers().keySet().iterator();
        while (mIt.hasNext()) {
            String name = (String)mIt.next();
            Expression expr = an.getMember(name);
            if (expr instanceof AnnotationConstantExpression) {
                atAttrs.put(name, ((AnnotationConstantExpression)expr).getValue());
                continue;
            }
            if (expr instanceof ConstantExpression) {
                constantAttrs.put(name, ((ConstantExpression)expr).getValue());
                continue;
            }
            if (expr instanceof ClassExpression) {
                constantAttrs.put(name, Type.getType(BytecodeHelper.getTypeDescription(expr.getType())));
                continue;
            }
            if (expr instanceof PropertyExpression) {
                enumAttrs.put(name, expr);
                continue;
            }
            if (!(expr instanceof ListExpression)) continue;
            arrayAttrs.put(name, expr);
        }
        Iterator it = constantAttrs.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            av.visit((String)entry.getKey(), entry.getValue());
        }
        it = enumAttrs.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            PropertyExpression propExp = (PropertyExpression)entry.getValue();
            av.visitEnum((String)entry.getKey(), BytecodeHelper.getTypeDescription(propExp.getObjectExpression().getType()), String.valueOf(((ConstantExpression)propExp.getProperty()).getValue()));
        }
        it = atAttrs.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            AnnotationNode atNode = (AnnotationNode)entry.getValue();
            AnnotationVisitor av2 = av.visitAnnotation((String)entry.getKey(), BytecodeHelper.getTypeDescription(atNode.getClassNode()));
            this.visitAnnotationAttributes(atNode, av2);
            av2.visitEnd();
        }
        this.visitArrayAttributes(an, arrayAttrs, av);
    }

    private void visitArrayAttributes(AnnotationNode an, Map arrayAttr, AnnotationVisitor av) {
        if (arrayAttr.isEmpty()) {
            return;
        }
        Iterator it = arrayAttr.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String attrName = (String)entry.getKey();
            ListExpression listExpr = (ListExpression)entry.getValue();
            AnnotationVisitor av2 = av.visitArray(attrName);
            List values = listExpr.getExpressions();
            if (!values.isEmpty()) {
                Expression expr = (Expression)values.get(0);
                int arrayElementType = -1;
                if (expr instanceof AnnotationConstantExpression) {
                    arrayElementType = 1;
                } else if (expr instanceof ConstantExpression) {
                    arrayElementType = 2;
                } else if (expr instanceof ClassExpression) {
                    arrayElementType = 3;
                } else if (expr instanceof PropertyExpression) {
                    arrayElementType = 4;
                }
                Iterator exprIt = listExpr.getExpressions().iterator();
                while (exprIt.hasNext()) {
                    switch (arrayElementType) {
                        case 1: {
                            AnnotationNode atAttr = (AnnotationNode)((AnnotationConstantExpression)exprIt.next()).getValue();
                            AnnotationVisitor av3 = av2.visitAnnotation(null, BytecodeHelper.getTypeDescription(atAttr.getClassNode()));
                            this.visitAnnotationAttributes(atAttr, av3);
                            av3.visitEnd();
                            break;
                        }
                        case 2: {
                            av2.visit(null, ((ConstantExpression)exprIt.next()).getValue());
                            break;
                        }
                        case 3: {
                            av2.visit(null, Type.getType(BytecodeHelper.getTypeDescription(((Expression)exprIt.next()).getType())));
                            break;
                        }
                        case 4: {
                            PropertyExpression propExpr = (PropertyExpression)exprIt.next();
                            av2.visitEnum(null, BytecodeHelper.getTypeDescription(propExpr.getObjectExpression().getType()), String.valueOf(((ConstantExpression)propExpr.getProperty()).getValue()));
                        }
                    }
                }
            }
            av2.visitEnd();
        }
    }

    protected boolean addInnerClass(ClassNode innerClass) {
        innerClass.setModule(this.classNode.getModule());
        return this.innerClasses.add(innerClass);
    }

    protected ClassNode createClosureClass(ClosureExpression expression) {
        ClassNode outerClass = this.getOutermostClass();
        String name = outerClass.getName() + "$" + this.context.getNextClosureInnerName(outerClass, this.classNode, this.methodNode);
        boolean staticMethodOrInStaticClass = this.isStaticMethod() || this.classNode.isStaticClass();
        Parameter[] parameters = expression.getParameters();
        if (parameters == null) {
            parameters = Parameter.EMPTY_ARRAY;
        } else if (parameters.length == 0) {
            parameters = new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "it", ConstantExpression.NULL)};
        }
        Parameter[] localVariableParams = this.getClosureSharedVariables(expression);
        this.removeInitialValues(localVariableParams);
        InnerClassNode answer = new InnerClassNode(outerClass, name, 0, ClassHelper.CLOSURE_TYPE);
        answer.setEnclosingMethod(this.methodNode);
        answer.setSynthetic(true);
        if (staticMethodOrInStaticClass) {
            answer.setStaticClass(true);
        }
        if (this.isInScriptBody()) {
            answer.setScriptBody(true);
        }
        MethodNode method = answer.addMethod("doCall", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, expression.getCode());
        method.setSourcePosition(expression);
        VariableScope varScope = expression.getVariableScope();
        if (varScope == null) {
            throw new RuntimeException("Must have a VariableScope by now! for expression: " + expression + " class: " + name);
        }
        method.setVariableScope(varScope.copy());
        if (parameters.length > 1 || parameters.length == 1 && parameters[0].getType() != null && parameters[0].getType() != ClassHelper.OBJECT_TYPE) {
            MethodNode call = answer.addMethod("call", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, new ReturnStatement(new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "doCall", (Expression)new ArgumentListExpression(parameters))));
            call.setSourcePosition(expression);
        }
        BlockStatement block = new BlockStatement();
        block.setSourcePosition(expression);
        VariableExpression outer = new VariableExpression("_outerInstance");
        outer.setSourcePosition(expression);
        block.getVariableScope().putReferencedLocalVariable(outer);
        VariableExpression thisObject = new VariableExpression("_thisObject");
        thisObject.setSourcePosition(expression);
        block.getVariableScope().putReferencedLocalVariable(thisObject);
        TupleExpression conArgs = new TupleExpression(outer, thisObject);
        block.addStatement(new ExpressionStatement(new ConstructorCallExpression(ClassNode.SUPER, conArgs)));
        for (int i = 0; i < localVariableParams.length; ++i) {
            Parameter param = localVariableParams[i];
            String paramName = param.getName();
            VariableExpression initialValue = null;
            ClassNode type = param.getType();
            FieldNode paramField = null;
            initialValue = new VariableExpression(paramName);
            ClassNode realType = type;
            type = ClassHelper.makeReference();
            param.setType(ClassHelper.makeReference());
            paramField = answer.addField(paramName, 2, type, initialValue);
            paramField.setHolder(true);
            String methodName = Verifier.capitalize(paramName);
            FieldExpression fieldExp = new FieldExpression(paramField);
            answer.addMethod("get" + methodName, 1, realType, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, new ReturnStatement(fieldExp));
        }
        Parameter[] params = new Parameter[2 + localVariableParams.length];
        params[0] = new Parameter(ClassHelper.OBJECT_TYPE, "_outerInstance");
        params[1] = new Parameter(ClassHelper.OBJECT_TYPE, "_thisObject");
        System.arraycopy(localVariableParams, 0, params, 2, localVariableParams.length);
        ConstructorNode sn = answer.addConstructor(1, params, ClassNode.EMPTY_ARRAY, block);
        sn.setSourcePosition(expression);
        return answer;
    }

    private void removeInitialValues(Parameter[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].hasInitialExpression()) continue;
            params[i] = new Parameter(params[i].getType(), params[i].getName());
        }
    }

    protected Parameter[] getClosureSharedVariables(ClosureExpression ce) {
        VariableScope scope = ce.getVariableScope();
        Parameter[] ret = new Parameter[scope.getReferencedLocalVariablesCount()];
        int index = 0;
        Iterator iter = scope.getReferencedLocalVariablesIterator();
        while (iter.hasNext()) {
            Parameter p;
            org.codehaus.groovy.ast.Variable element = (org.codehaus.groovy.ast.Variable)iter.next();
            ret[index] = p = new Parameter(element.getType(), element.getName());
            ++index;
        }
        return ret;
    }

    protected ClassNode getOutermostClass() {
        if (this.outermostClass == null) {
            this.outermostClass = this.classNode;
            while (this.outermostClass instanceof InnerClassNode) {
                this.outermostClass = this.outermostClass.getOuterClass();
            }
        }
        return this.outermostClass;
    }

    protected void doConvertAndCast(ClassNode type) {
        this.doConvertAndCast(type, false);
    }

    protected void doConvertAndCast(ClassNode type, boolean coerce) {
        if (type == ClassHelper.OBJECT_TYPE) {
            return;
        }
        if (!(this.rightHandType != null && this.rightHandType.isDerivedFrom(type) && this.rightHandType.implementsInterface(type) || !this.isValidTypeForCast(type))) {
            this.visitClassExpression(new ClassExpression(type));
            if (coerce) {
                asTypeMethod.call(this.mv);
            } else {
                castToTypeMethod.call(this.mv);
            }
        }
        this.helper.doCast(type);
    }

    protected void evaluateLogicalOrExpression(BinaryExpression expression) {
        this.visitBooleanExpression(new BooleanExpression(expression.getLeftExpression()));
        Label l0 = new Label();
        Label l2 = new Label();
        this.mv.visitJumpInsn(153, l0);
        this.mv.visitLabel(l2);
        this.visitConstantExpression(ConstantExpression.TRUE);
        Label l1 = new Label();
        this.mv.visitJumpInsn(167, l1);
        this.mv.visitLabel(l0);
        this.visitBooleanExpression(new BooleanExpression(expression.getRightExpression()));
        this.mv.visitJumpInsn(154, l2);
        this.visitConstantExpression(ConstantExpression.FALSE);
        this.mv.visitLabel(l1);
    }

    protected void evaluateLogicalAndExpression(BinaryExpression expression) {
        this.visitBooleanExpression(new BooleanExpression(expression.getLeftExpression()));
        Label l0 = new Label();
        this.mv.visitJumpInsn(153, l0);
        this.visitBooleanExpression(new BooleanExpression(expression.getRightExpression()));
        this.mv.visitJumpInsn(153, l0);
        this.visitConstantExpression(ConstantExpression.TRUE);
        Label l1 = new Label();
        this.mv.visitJumpInsn(167, l1);
        this.mv.visitLabel(l0);
        this.visitConstantExpression(ConstantExpression.FALSE);
        this.mv.visitLabel(l1);
    }

    protected void evaluateBinaryExpression(String method, BinaryExpression expression) {
        this.makeCall(expression.getLeftExpression(), new ConstantExpression(method), new ArgumentListExpression(expression.getRightExpression()), invokeMethod, false, false, false);
    }

    protected void evaluateCompareTo(BinaryExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        leftExpression.visit(this);
        if (this.isComparisonExpression(leftExpression)) {
            this.helper.boxBoolean();
        }
        Expression rightExpression = expression.getRightExpression();
        rightExpression.visit(this);
        if (this.isComparisonExpression(rightExpression)) {
            this.helper.boxBoolean();
        }
        compareToMethod.call(this.mv);
    }

    protected void evaluateBinaryExpressionWithAssignment(String method, BinaryExpression expression) {
        BinaryExpression leftBinExpr;
        Expression leftExpression = expression.getLeftExpression();
        if (leftExpression instanceof BinaryExpression && (leftBinExpr = (BinaryExpression)leftExpression).getOperation().getType() == 30) {
            this.visitAndAutoboxBoolean(leftBinExpr.getLeftExpression());
            final int objVar = this.compileStack.defineTemporaryVariable("$object", true);
            BytecodeExpression objectExpression = new BytecodeExpression(){

                public void visit(GroovyCodeVisitor visitor) {
                    AsmClassGenerator.this.mv.visitVarInsn(25, objVar);
                }
            };
            this.visitAndAutoboxBoolean(leftBinExpr.getRightExpression());
            final int indexVar = this.compileStack.defineTemporaryVariable("$index", true);
            BytecodeExpression indexExpression = new BytecodeExpression(){

                public void visit(GroovyCodeVisitor visitor) {
                    AsmClassGenerator.this.mv.visitVarInsn(25, indexVar);
                }
            };
            BinaryExpression leftExpr = new BinaryExpression(objectExpression, Token.newSymbol(30, -1, -1), indexExpression);
            leftExpr.setSourcePosition(leftExpression);
            MethodCallExpression methodCall = new MethodCallExpression((Expression)leftExpr, method, (Expression)new ArgumentListExpression(expression.getRightExpression()));
            methodCall.visit(this);
            final int resultVar = this.compileStack.defineTemporaryVariable("$result", true);
            BytecodeExpression resultExpression = new BytecodeExpression(){

                public void visit(GroovyCodeVisitor visitor) {
                    AsmClassGenerator.this.mv.visitVarInsn(25, resultVar);
                }
            };
            this.visitMethodCallExpression(new MethodCallExpression((Expression)objectExpression, "putAt", (Expression)new ArgumentListExpression(new Expression[]{indexExpression, resultExpression})));
            this.mv.visitInsn(87);
            this.mv.visitVarInsn(25, resultVar);
            this.compileStack.removeVar(resultVar);
            this.compileStack.removeVar(indexVar);
            this.compileStack.removeVar(objVar);
            return;
        }
        this.evaluateBinaryExpression(method, expression);
        this.mv.visitInsn(89);
        this.leftHandExpression = true;
        this.evaluateExpression(leftExpression);
        this.leftHandExpression = false;
    }

    private void evaluateBinaryExpression(MethodCaller compareMethod, BinaryExpression expression) {
        Expression leftExp = expression.getLeftExpression();
        Expression rightExp = expression.getRightExpression();
        this.load(leftExp);
        this.load(rightExp);
        compareMethod.call(this.mv);
    }

    protected void evaluateEqual(BinaryExpression expression) {
        BinaryExpression leftBinExpr;
        Expression leftExpression = expression.getLeftExpression();
        if (leftExpression instanceof BinaryExpression && (leftBinExpr = (BinaryExpression)leftExpression).getOperation().getType() == 30) {
            Expression right = expression.getRightExpression();
            this.visitAndAutoboxBoolean(right);
            final int rhsVar = this.compileStack.defineTemporaryVariable("$rhs", right.getType(), true);
            BytecodeExpression rhsExpr = new BytecodeExpression(){

                public void visit(GroovyCodeVisitor visitor) {
                    AsmClassGenerator.this.mv.visitVarInsn(25, rhsVar);
                }
            };
            this.visitMethodCallExpression(new MethodCallExpression(leftBinExpr.getLeftExpression(), "putAt", (Expression)new ArgumentListExpression(new Expression[]{leftBinExpr.getRightExpression(), rhsExpr})));
            this.mv.visitInsn(87);
            this.mv.visitVarInsn(25, rhsVar);
            this.compileStack.removeVar(rhsVar);
            return;
        }
        Expression rightExpression = expression.getRightExpression();
        ClassNode type = this.getLHSType(leftExpression);
        if (ClassHelper.isPrimitiveType(type)) {
            this.visitAndAutoboxBoolean(rightExpression);
        } else if (!rightExpression.getType().isDerivedFrom(type)) {
            this.visitCastExpression(new CastExpression(type, rightExpression));
        } else {
            this.visitAndAutoboxBoolean(rightExpression);
        }
        this.mv.visitInsn(89);
        this.leftHandExpression = true;
        this.rightHandType = rightExpression.getType();
        leftExpression.visit(this);
        this.rightHandType = null;
        this.leftHandExpression = false;
    }

    protected ClassNode getLHSType(Expression leftExpression) {
        FieldExpression fieldExp;
        ClassNode type;
        if (leftExpression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)leftExpression;
            ClassNode type2 = varExp.getType();
            if (this.isValidTypeForCast(type2)) {
                return type2;
            }
            String variableName = varExp.getName();
            Variable variable = this.compileStack.getVariable(variableName, false);
            if (variable != null) {
                if (variable.isHolder()) {
                    return type2;
                }
                if (variable.isProperty()) {
                    return variable.getType();
                }
                type2 = variable.getType();
                if (this.isValidTypeForCast(type2)) {
                    return type2;
                }
            } else {
                FieldNode field = this.classNode.getDeclaredField(variableName);
                if (field == null) {
                    field = this.classNode.getOuterField(variableName);
                }
                if (field != null) {
                    type2 = field.getType();
                    if (!field.isHolder() && this.isValidTypeForCast(type2)) {
                        return type2;
                    }
                }
            }
        } else if (leftExpression instanceof FieldExpression && this.isValidTypeForCast(type = (fieldExp = (FieldExpression)leftExpression).getType())) {
            return type;
        }
        return ClassHelper.DYNAMIC_TYPE;
    }

    protected boolean isValidTypeForCast(ClassNode type) {
        return type != ClassHelper.DYNAMIC_TYPE && type != ClassHelper.REFERENCE_TYPE;
    }

    protected void visitAndAutoboxBoolean(Expression expression) {
        expression.visit(this);
        if (this.isComparisonExpression(expression)) {
            this.helper.boxBoolean();
        }
    }

    private void execMethodAndStoreForSubscriptOperator(String method, Expression expression) {
        this.makeCall(expression, new ConstantExpression(method), MethodCallExpression.NO_ARGUMENTS, invokeMethod, false, false, false);
        boolean setResult = true;
        if (expression instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expression;
            if (be.getOperation().getType() == 30) {
                this.mv.visitInsn(89);
                final int resultIdx = this.compileStack.defineTemporaryVariable("postfix_" + method, true);
                BytecodeExpression result = new BytecodeExpression(){

                    public void visit(GroovyCodeVisitor visitor) {
                        AsmClassGenerator.this.mv.visitVarInsn(25, resultIdx);
                    }
                };
                ArgumentListExpression args = new ArgumentListExpression();
                args.addExpression(be.getRightExpression());
                args.addExpression(result);
                this.makeCall(be.getLeftExpression(), new ConstantExpression("putAt"), args, invokeMethod, false, false, false);
                this.mv.visitInsn(87);
                setResult = false;
            }
        } else if (expression instanceof ConstantExpression) {
            setResult = false;
        }
        if (setResult) {
            if (expression instanceof VariableExpression || expression instanceof FieldExpression || expression instanceof PropertyExpression) {
                this.mv.visitInsn(89);
            }
            this.leftHandExpression = true;
            expression.visit(this);
            this.leftHandExpression = false;
        }
    }

    protected void evaluatePrefixMethod(String method, Expression expression) {
        this.execMethodAndStoreForSubscriptOperator(method, expression);
    }

    protected void evaluatePostfixMethod(String method, Expression expression) {
        expression.visit(this);
        int tempIdx = this.compileStack.defineTemporaryVariable("postfix_" + method, true);
        this.execMethodAndStoreForSubscriptOperator(method, expression);
        this.mv.visitInsn(87);
        this.mv.visitVarInsn(25, tempIdx);
        this.compileStack.removeVar(tempIdx);
    }

    protected void evaluateInstanceof(BinaryExpression expression) {
        this.visitAndAutoboxBoolean(expression.getLeftExpression());
        Expression rightExp = expression.getRightExpression();
        ClassNode classType = ClassHelper.DYNAMIC_TYPE;
        if (!(rightExp instanceof ClassExpression)) {
            throw new RuntimeException("Right hand side of the instanceof keyword must be a class name, not: " + rightExp);
        }
        ClassExpression classExp = (ClassExpression)rightExp;
        classType = classExp.getType();
        String classInternalName = BytecodeHelper.getClassInternalName(classType);
        this.mv.visitTypeInsn(193, classInternalName);
    }

    protected boolean argumentsUseStack(Expression arguments) {
        return arguments instanceof TupleExpression || arguments instanceof ClosureExpression;
    }

    protected boolean isNonStaticField(Expression expression) {
        PropertyExpression fieldExp;
        String possibleField;
        FieldNode field = null;
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            field = this.classNode.getDeclaredField(varExp.getName());
        } else if (expression instanceof FieldExpression) {
            FieldExpression fieldExp2 = (FieldExpression)expression;
            field = this.classNode.getDeclaredField(fieldExp2.getFieldName());
        } else if (expression.getClass() == PropertyExpression.class && (possibleField = (fieldExp = (PropertyExpression)expression).getPropertyAsString()) != null) {
            field = this.classNode.getDeclaredField(possibleField);
        }
        return field != null && !field.isStatic();
    }

    private static boolean isThisExpression(Expression expression) {
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            return varExp.getName().equals("this");
        }
        return false;
    }

    private static boolean isSuperExpression(Expression expression) {
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            return varExp.getName().equals("super");
        }
        return false;
    }

    private static boolean isThisOrSuper(Expression expression) {
        return AsmClassGenerator.isThisExpression(expression) || AsmClassGenerator.isSuperExpression(expression);
    }

    protected Expression createReturnLHSExpression(Expression expression) {
        BinaryExpression binExpr;
        if (expression instanceof BinaryExpression && (binExpr = (BinaryExpression)expression).getOperation().isA(1100)) {
            return this.createReusableExpression(binExpr.getLeftExpression());
        }
        return null;
    }

    protected Expression createReusableExpression(Expression expression) {
        ExpressionTransformer transformer = new ExpressionTransformer(){

            public Expression transform(Expression expression) {
                if (expression instanceof PostfixExpression) {
                    PostfixExpression postfixExp = (PostfixExpression)expression;
                    return postfixExp.getExpression();
                }
                if (expression instanceof PrefixExpression) {
                    PrefixExpression prefixExp = (PrefixExpression)expression;
                    return prefixExp.getExpression();
                }
                return expression;
            }
        };
        return transformer.transform(expression.transformExpression(transformer));
    }

    protected boolean isComparisonExpression(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)expression;
            switch (binExpr.getOperation().getType()) {
                case 94: 
                case 120: 
                case 121: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 544: 
                case 573: {
                    return true;
                }
            }
        } else if (expression instanceof BooleanExpression) {
            return true;
        }
        return false;
    }

    protected void onLineNumber(ASTNode statement, String message) {
        int line = statement.getLineNumber();
        int col = statement.getColumnNumber();
        this.currentASTNode = statement;
        boolean createEntry = true;
        if (line >= 0) {
            this.columnNumber = col;
            createEntry = this.lineNumber != line;
            this.lineNumber = line;
        }
        if (line >= 0 && this.mv != null && createEntry) {
            Label l = new Label();
            this.mv.visitLabel(l);
            this.mv.visitLineNumber(line, l);
        }
    }

    private boolean isInnerClass() {
        return this.classNode instanceof InnerClassNode;
    }

    protected boolean isFieldOrVariable(String name) {
        return this.compileStack.containsVariable(name) || this.classNode.getDeclaredField(name) != null;
    }

    protected ClassNode getExpressionType(Expression expression) {
        if (this.isComparisonExpression(expression)) {
            return ClassHelper.boolean_TYPE;
        }
        if (expression instanceof VariableExpression) {
            org.codehaus.groovy.ast.Variable var;
            if (expression == VariableExpression.THIS_EXPRESSION) {
                return this.classNode;
            }
            if (expression == VariableExpression.SUPER_EXPRESSION) {
                return this.classNode.getSuperClass();
            }
            VariableExpression varExpr = (VariableExpression)expression;
            Variable variable = this.compileStack.getVariable(varExpr.getName(), false);
            if (variable != null && !variable.isHolder()) {
                ClassNode type = variable.getType();
                if (!variable.isDynamicTyped()) {
                    return type;
                }
            }
            if (variable == null && (var = this.compileStack.getScope().getReferencedClassVariable(varExpr.getName())) != null && !var.isDynamicTyped()) {
                return var.getType();
            }
        }
        return expression.getType();
    }

    protected boolean isInClosureConstructor() {
        return this.constructorNode != null && this.classNode.getOuterClass() != null && this.classNode.getSuperClass() == ClassHelper.CLOSURE_TYPE;
    }

    protected boolean isInClosure() {
        return this.classNode.getOuterClass() != null && this.classNode.getSuperClass() == ClassHelper.CLOSURE_TYPE;
    }

    protected boolean isStaticMethod() {
        return this.methodNode != null && this.methodNode.isStatic();
    }

    protected CompileUnit getCompileUnit() {
        CompileUnit answer = this.classNode.getCompileUnit();
        if (answer == null) {
            answer = this.context.getCompileUnit();
        }
        return answer;
    }

    protected boolean isHolderVariable(Expression expression) {
        if (expression instanceof FieldExpression) {
            FieldExpression fieldExp = (FieldExpression)expression;
            return fieldExp.getField().isHolder();
        }
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            Variable variable = this.compileStack.getVariable(varExp.getName(), false);
            if (variable != null) {
                return variable.isHolder();
            }
            FieldNode field = this.classNode.getDeclaredField(varExp.getName());
            if (field != null) {
                return field.isHolder();
            }
        }
        return false;
    }

    public static boolean usesSuper(MethodCallExpression call) {
        Expression expression = call.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            String variable = varExp.getName();
            return variable.equals("super");
        }
        return false;
    }

    public static boolean usesSuper(PropertyExpression pe) {
        Expression expression = pe.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            String variable = varExp.getName();
            return variable.equals("super");
        }
        return false;
    }

    protected int getBytecodeVersion() {
        if (!this.classNode.isUsingGenerics() && !this.classNode.isAnnotated()) {
            return 47;
        }
        String target = this.getCompileUnit().getConfig().getTargetBytecode();
        return "1.5".equals(target) ? 49 : 47;
    }
}

