/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ui.ejb;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.PostActivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.directory.api.ui.DirectoryUI;
import org.nuxeo.ecm.directory.api.ui.DirectoryUIManager;
import org.nuxeo.ecm.directory.ui.ejb.DirectoryUIManagerLocal;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Local(value={DirectoryUIManagerLocal.class})
@Remote(value={DirectoryUIManager.class})
public class DirectoryUIManagerBean
implements DirectoryUIManagerLocal {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DirectoryUIManagerBean.class);
    private transient DirectoryUIManager service;

    @PostActivate
    @PostConstruct
    public void initialize() {
        try {
            this.service = (DirectoryUIManager)Framework.getLocalService(DirectoryUIManager.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not get distribution service", (Throwable)e);
        }
    }

    @Remove
    public void remove() {
        this.service = null;
    }

    @Override
    public DirectoryUI getDirectoryInfo(String directoryName) throws ClientException {
        return this.service.getDirectoryInfo(directoryName);
    }

    @Override
    public List<String> getDirectoryNames() throws ClientException {
        return this.service.getDirectoryNames();
    }
}

