/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;

public class Template {
    protected final Resource resource;
    protected Map<String, Object> args;
    protected ScriptFile script;
    protected WebContext ctx;

    protected Template(WebContext ctx, Resource resource, ScriptFile script) {
        this.ctx = ctx;
        this.resource = resource;
        this.script = script;
        if (this.ctx == null && this.resource != null) {
            this.ctx = this.resource.getContext();
        }
    }

    public Template(WebContext ctx, String fileName) {
        this(ctx, null, null);
        this.resolve(fileName);
    }

    public Template(Resource resource, String fileName) {
        this(resource.getContext(), resource, null);
        this.resolve(fileName);
    }

    public Template(WebContext ctx, ScriptFile script) {
        this(ctx, null, script);
    }

    public Template(Resource resource, ScriptFile script) {
        this(resource.getContext(), resource, script);
    }

    public Template arg(String key, Object value) {
        if (this.args == null) {
            this.args = new HashMap<String, Object>();
        }
        this.args.put(key, value);
        return this;
    }

    public Template args(Map<String, Object> args) {
        this.args = args;
        return this;
    }

    public Map<String, Object> args() {
        return this.args;
    }

    public Resource resource() {
        return this.resource;
    }

    protected void resolve(String fileName) {
        this.script = this.resource != null ? this.resource.getType().getView(this.ctx.getModule(), fileName) : this.ctx.getModule().getFile(fileName);
    }

    public ScriptFile script() {
        return this.script;
    }

    public void render(OutputStream out) throws WebException {
        OutputStreamWriter w;
        try {
            w = new OutputStreamWriter(out, "UTF-8");
            this.ctx.render(this.script(), this.args, (Writer)w);
        }
        catch (Exception e) {
            throw WebException.wrap("Failed to write response", e);
        }
        try {
            ((Writer)w).flush();
        }
        catch (Exception e) {
            throw WebException.wrap("Failed to flush response", e);
        }
    }

    public String render() {
        StringWriter w = new StringWriter();
        try {
            this.ctx.render(this.script(), this.args, (Writer)w);
        }
        catch (Exception e) {
            throw WebException.wrap("Failed to write response", e);
        }
        try {
            w.flush();
        }
        catch (Exception e) {
            throw WebException.wrap("Failed to flush response", e);
        }
        return w.getBuffer().toString();
    }
}

