/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.javasimon.Simon;
import org.javasimon.utils.AbstractDataCollector;
import org.javasimon.utils.Replacer;

public final class GoogleChartGenerator {
    private static final String URL_START = "http://chart.apis.google.com/chart?chs=600x300";
    private static final String TYPE_BAR = "&cht=bvg&chbh=32,10,60&chco=4d89f9,c6d9fd&chxt=x,x,y";
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static final List<Replacer> REPLACERS = new LinkedList<Replacer>();
    private static final int TEN_BASE = 10;

    private GoogleChartGenerator() {
        throw new UnsupportedOperationException();
    }

    public static String barChart(AbstractDataCollector collector, String title, double divisor, String unit) {
        double x;
        StringBuilder result = new StringBuilder(URL_START).append(TYPE_BAR);
        result.append("&chtt=").append(GoogleChartGenerator.encode(title));
        StringBuilder x0 = new StringBuilder("&chxl=0:");
        StringBuilder x1 = new StringBuilder("|1:");
        StringBuilder data = new StringBuilder("&chd=t:");
        double max = 0.0;
        boolean first = true;
        for (Simon simon : collector.getSimons()) {
            if (first) {
                first = false;
            } else {
                data.append(',');
            }
            List<Double> values = collector.valuesFor(simon);
            double lastValue = values.get(values.size() - 1) / divisor;
            x0.append('|').append(GoogleChartGenerator.encode(simon.getName()));
            String formattedValue = NUMBER_FORMAT.format(lastValue);
            x1.append('|').append(formattedValue).append("+").append(unit);
            if (lastValue > max) {
                max = lastValue;
            }
            data.append(formattedValue);
        }
        double division = Math.pow(10.0, Math.floor(Math.log10(max)));
        StringBuilder x2 = new StringBuilder("|2:");
        for (x = 0.0; x < max + division; x += division) {
            x2.append('|').append(Double.valueOf(x).longValue());
        }
        result.append("&chxr=2,0,").append(Double.valueOf(x - division).longValue());
        result.append("&chds=0,").append(Double.valueOf(x - division).longValue());
        result.append((CharSequence)x0).append((CharSequence)x1).append((CharSequence)x2).append((CharSequence)data);
        result.append("&.png");
        return result.toString();
    }

    private static String encode(String s) {
        for (Replacer replacer : REPLACERS) {
            s = replacer.process(s);
        }
        return s;
    }

    static {
        REPLACERS.add(new Replacer("\\+", "%2b"));
        REPLACERS.add(new Replacer(" ", "+"));
        REPLACERS.add(new Replacer("&", "%26"));
    }
}

