/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageSelection;
import org.nuxeo.ecm.platform.query.api.PageSelections;

public abstract class AbstractPageProvider<T>
implements PageProvider<T> {
    private static final Log log = LogFactory.getLog(AbstractPageProvider.class);
    private static final long serialVersionUID = 1L;
    protected String name;
    protected long offset = 0L;
    protected long pageSize = 0L;
    protected long maxPageSize = 100L;
    protected long resultsCount = -1L;
    protected int currentEntryIndex = 0;
    protected List<SortInfo> sortInfos;
    protected boolean sortable = false;
    protected List<T> selectedEntries;
    protected PageSelections<T> currentSelectPage;
    protected Map<String, Serializable> properties;
    protected Object[] parameters;
    protected DocumentModel searchDocumentModel;
    protected String errorMessage;
    protected Throwable error;
    protected PageProviderDefinition definition;

    @Override
    public abstract List<T> getCurrentPage();

    protected void pageChanged() {
        this.currentEntryIndex = 0;
        this.currentSelectPage = null;
    }

    @Override
    public void firstPage() {
        if (this.pageSize == 0L) {
            return;
        }
        if (this.offset != 0L) {
            this.offset = 0L;
            this.pageChanged();
        }
    }

    public void rewind() {
        this.firstPage();
    }

    @Override
    public long getCurrentPageIndex() {
        if (this.pageSize == 0L) {
            return 0L;
        }
        return this.offset / this.pageSize;
    }

    @Override
    public long getCurrentPageOffset() {
        return this.offset;
    }

    @Override
    public long getCurrentPageSize() {
        List<T> currentItems = this.getCurrentPage();
        if (currentItems != null) {
            return currentItems.size();
        }
        return 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getNumberOfPages() {
        if (this.pageSize == 0L) {
            return 1L;
        }
        return (int)(1L + (this.getResultsCount() - 1L) / this.pageSize);
    }

    @Override
    public List<T> setCurrentPage(long page) {
        long oldOffset = this.offset;
        this.offset = page * this.pageSize;
        this.pageChanged();
        List<T> res = this.getCurrentPage();
        if (page >= this.getNumberOfPages()) {
            log.warn((Object)String.format("Provider '%s' does not have a page with number '%s': go back to old page", this.getName(), page));
            this.offset = oldOffset;
            this.pageChanged();
            res = this.getCurrentPage();
        }
        return res;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(long pageSize) {
        if (this.pageSize != pageSize) {
            this.pageSize = pageSize;
            this.offset = 0L;
            this.refresh();
        }
    }

    @Override
    public List<SortInfo> getSortInfos() {
        ArrayList<SortInfo> res = new ArrayList<SortInfo>();
        if (this.sortInfos != null) {
            res.addAll(this.sortInfos);
        }
        return res;
    }

    @Override
    public SortInfo getSortInfo() {
        if (this.sortInfos != null && !this.sortInfos.isEmpty()) {
            return this.sortInfos.get(0);
        }
        return null;
    }

    protected boolean sortInfoChanged(List<SortInfo> oldSortInfos, List<SortInfo> newSortInfos) {
        if (oldSortInfos == null && newSortInfos == null) {
            return false;
        }
        if (oldSortInfos == null) {
            oldSortInfos = Collections.emptyList();
        } else if (newSortInfos == null) {
            newSortInfos = Collections.emptyList();
        }
        if (oldSortInfos.size() != newSortInfos.size()) {
            return true;
        }
        for (int i = 0; i < oldSortInfos.size(); ++i) {
            SortInfo oldSort = (SortInfo)oldSortInfos.get(i);
            SortInfo newSort = (SortInfo)newSortInfos.get(i);
            if (oldSort == null && newSort == null) continue;
            if (oldSort != null || newSort != null) {
                return true;
            }
            if (oldSort.equals((Object)newSort)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSortInfos(List<SortInfo> sortInfo) {
        if (this.sortInfoChanged(this.sortInfos, sortInfo)) {
            this.sortInfos = sortInfo;
            this.refresh();
        }
    }

    @Override
    public void setSortInfo(SortInfo sortInfo) {
        ArrayList<SortInfo> newSortInfos = new ArrayList<SortInfo>();
        if (sortInfo != null) {
            newSortInfos.add(sortInfo);
        }
        this.setSortInfos(newSortInfos);
    }

    @Override
    public void setSortInfo(String sortColumn, boolean sortAscending, boolean removeOtherSortInfos) {
        if (removeOtherSortInfos) {
            SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
            this.setSortInfo(sortInfo);
        } else if (this.getSortInfoIndex(sortColumn, sortAscending) == -1) {
            if (this.getSortInfoIndex(sortColumn, !sortAscending) != -1) {
                ArrayList<SortInfo> newSortInfos = new ArrayList<SortInfo>();
                for (SortInfo sortInfo : this.getSortInfos()) {
                    if (sortColumn.equals(sortInfo.getSortColumn())) {
                        newSortInfos.add(new SortInfo(sortColumn, sortAscending));
                        continue;
                    }
                    newSortInfos.add(sortInfo);
                }
                this.setSortInfos(newSortInfos);
            } else {
                this.addSortInfo(sortColumn, sortAscending);
            }
        }
    }

    @Override
    public void addSortInfo(String sortColumn, boolean sortAscending) {
        SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
        List<SortInfo> sortInfos = this.getSortInfos();
        if (sortInfos == null) {
            this.setSortInfo(sortInfo);
        } else {
            sortInfos.add(sortInfo);
            this.setSortInfos(sortInfos);
        }
    }

    @Override
    public int getSortInfoIndex(String sortColumn, boolean sortAscending) {
        List<SortInfo> sortInfos = this.getSortInfos();
        if (sortInfos == null || sortInfos.isEmpty()) {
            return -1;
        }
        SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
        return sortInfos.indexOf(sortInfo);
    }

    @Override
    public boolean isNextPageAvailable() {
        if (this.pageSize == 0L) {
            return false;
        }
        return this.getResultsCount() > this.pageSize + this.offset;
    }

    @Override
    public boolean isPreviousPageAvailable() {
        return this.offset > 0L;
    }

    @Override
    public void lastPage() {
        if (this.pageSize == 0L) {
            return;
        }
        this.offset = this.getResultsCount() % this.pageSize == 0L ? this.getResultsCount() - this.pageSize : (long)((int)(this.getResultsCount() - this.getResultsCount() % this.pageSize));
        this.pageChanged();
    }

    public void last() {
        this.lastPage();
    }

    @Override
    public void nextPage() {
        if (this.pageSize == 0L) {
            return;
        }
        this.offset += this.pageSize;
        this.pageChanged();
    }

    public void next() {
        this.nextPage();
    }

    @Override
    public void previousPage() {
        if (this.pageSize == 0L) {
            return;
        }
        if (this.offset >= this.pageSize) {
            this.offset -= this.pageSize;
            this.pageChanged();
        }
    }

    public void previous() {
        this.previousPage();
    }

    @Override
    public void refresh() {
        this.resultsCount = -1L;
        this.currentSelectPage = null;
        this.errorMessage = null;
        this.error = null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCurrentPageStatus() {
        long total = this.getNumberOfPages();
        long current = this.getCurrentPageIndex() + 1L;
        if (total == -1L) {
            return String.format("%d", current);
        }
        return String.format("%d/%d", current, total);
    }

    @Override
    public boolean isNextEntryAvailable() {
        if (this.pageSize == 0L) {
            return (long)this.currentEntryIndex < this.getResultsCount() - 1L;
        }
        return (long)this.currentEntryIndex < this.getResultsCount() % this.pageSize - 1L || this.isNextPageAvailable();
    }

    @Override
    public boolean isPreviousEntryAvailable() {
        return this.currentEntryIndex != 0 || this.isPreviousPageAvailable();
    }

    @Override
    public void nextEntry() {
        if (this.pageSize == 0L && (long)this.currentEntryIndex < this.getResultsCount() || (long)this.currentEntryIndex < this.getCurrentPageSize() - 1L) {
            ++this.currentEntryIndex;
            return;
        }
        if (!this.isNextPageAvailable()) {
            return;
        }
        this.nextPage();
        List<T> currentPage = this.getCurrentPage();
        this.currentEntryIndex = currentPage == null || currentPage.isEmpty() ? 0 : 0;
    }

    @Override
    public void previousEntry() {
        if (this.currentEntryIndex > 0) {
            --this.currentEntryIndex;
            return;
        }
        if (!this.isPreviousPageAvailable()) {
            return;
        }
        this.previousPage();
        List<T> currentPage = this.getCurrentPage();
        this.currentEntryIndex = currentPage == null || currentPage.isEmpty() ? 0 : new Long(this.getPageSize() - 1L).intValue();
    }

    @Override
    public T getCurrentEntry() {
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            return null;
        }
        return currentPage.get(this.currentEntryIndex);
    }

    @Override
    public void setCurrentEntry(T entry) throws ClientException {
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            throw new ClientException(String.format("Entry '%s' not found in current page", entry));
        }
        int i = currentPage.indexOf(entry);
        if (i == -1) {
            throw new ClientException(String.format("Entry '%s' not found in current page", entry));
        }
        this.currentEntryIndex = i;
    }

    @Override
    public void setCurrentEntryIndex(long index) throws ClientException {
        int intIndex = new Long(index).intValue();
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            throw new ClientException(String.format("Index %s not found in current page", new Integer(intIndex)));
        }
        if (index >= (long)currentPage.size()) {
            throw new ClientException(String.format("Index %s not found in current page", new Integer(intIndex)));
        }
        this.currentEntryIndex = intIndex;
    }

    @Override
    public long getResultsCount() {
        return this.resultsCount;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return new HashMap<String, Serializable>(this.properties);
    }

    @Override
    public void setProperties(Map<String, Serializable> properties) {
        this.properties = properties;
    }

    @Override
    public void setResultsCount(long resultsCount) {
        this.resultsCount = resultsCount;
    }

    @Override
    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public PageSelections<T> getCurrentSelectPage() {
        if (this.currentSelectPage == null) {
            ArrayList entries = new ArrayList();
            List<T> currentPage = this.getCurrentPage();
            this.currentSelectPage = new PageSelections();
            this.currentSelectPage.setName(this.name);
            if (currentPage != null && !currentPage.isEmpty()) {
                if (this.selectedEntries == null || this.selectedEntries.isEmpty()) {
                    for (int i = 0; i < currentPage.size(); ++i) {
                        entries.add(new PageSelection<T>(currentPage.get(i), false));
                    }
                } else {
                    boolean allSelected = true;
                    for (int i = 0; i < currentPage.size(); ++i) {
                        T entry = currentPage.get(i);
                        Boolean selected = this.selectedEntries.contains(entry);
                        if (!Boolean.TRUE.equals(selected)) {
                            allSelected = false;
                        }
                        entries.add(new PageSelection<T>(entry, selected));
                    }
                    if (allSelected) {
                        this.currentSelectPage.setSelected(true);
                    }
                }
            }
            this.currentSelectPage.setEntries(entries);
        }
        return this.currentSelectPage;
    }

    @Override
    public void setSelectedEntries(List<T> entries) {
        this.selectedEntries = entries;
        this.currentSelectPage = null;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public DocumentModel getSearchDocumentModel() {
        return this.searchDocumentModel;
    }

    protected boolean searchDocumentModelChanged(DocumentModel oldDoc, DocumentModel newDoc) {
        if (oldDoc == null && newDoc == null) {
            return false;
        }
        if (oldDoc == null || newDoc == null) {
            return true;
        }
        return true;
    }

    @Override
    public void setSearchDocumentModel(DocumentModel searchDocumentModel) {
        if (this.searchDocumentModelChanged(this.searchDocumentModel, searchDocumentModel)) {
            this.refresh();
        }
        this.searchDocumentModel = searchDocumentModel;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public PageProviderDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(PageProviderDefinition providerDefinition) {
        this.definition = providerDefinition;
    }

    @Override
    public long getMaxPageSize() {
        return this.maxPageSize;
    }

    @Override
    public void setMaxPageSize(long maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public long getMinMaxPageSize() {
        long pageSize = this.getPageSize();
        long maxPageSize = this.getMaxPageSize();
        if (pageSize <= 0L && maxPageSize > 0L) {
            return maxPageSize;
        }
        if (maxPageSize < pageSize) {
            return maxPageSize;
        }
        return pageSize;
    }
}

