/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.nxql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;

public class CoreQueryAndFetchPageProvider
extends AbstractPageProvider<Map<String, Serializable>>
implements PageProvider<Map<String, Serializable>> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CoreQueryDocumentPageProvider.class);
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String CHECK_QUERY_CACHE_PROPERTY = "checkQueryCache";
    protected String query;
    protected List<Map<String, Serializable>> currentItems;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Serializable>> getCurrentPage() {
        this.checkQueryCache();
        if (this.currentItems == null) {
            this.errorMessage = null;
            this.error = null;
            if (this.query == null) {
                this.buildQuery();
            }
            if (this.query == null) {
                throw new ClientRuntimeException(String.format("Cannot perform null query: check provider '%s'", this.getName()));
            }
            this.currentItems = new ArrayList<Map<String, Serializable>>();
            Map<String, Serializable> props = this.getProperties();
            CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
            if (coreSession == null) {
                throw new ClientRuntimeException("cannot find core session");
            }
            IterableQueryResult result = null;
            try {
                long minMaxPageSize = this.getMinMaxPageSize();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Perform query for provider '%s': '%s' with pageSize=%s, offset=%s", this.getName(), this.query, minMaxPageSize, this.offset));
                }
                result = coreSession.queryAndFetch(this.query, "NXQL", new Object[0]);
                this.resultsCount = result.size();
                if (this.offset < this.resultsCount) {
                    result.skipTo(this.offset);
                }
                Iterator it = result.iterator();
                int pos = 0;
                while (it.hasNext() && (long)pos < minMaxPageSize) {
                    ++pos;
                    Map item = (Map)it.next();
                    this.currentItems.add(item);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Performed query for provider '%s': got %s hits", this.getName(), this.resultsCount));
                }
            }
            catch (ClientException e) {
                this.errorMessage = e.getMessage();
                this.error = e;
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        return this.currentItems;
    }

    protected void buildQuery() {
        try {
            String newQuery;
            PageProviderDefinition def = this.getDefinition();
            String originalQuery = def.getPattern();
            SortInfo[] sortArray = null;
            if (this.sortInfos != null) {
                sortArray = this.sortInfos.toArray(new SortInfo[0]);
            }
            if (!(newQuery = NXQLQueryBuilder.getQuery(originalQuery, this.getParameters(), def.getQuotePatternParameters(), def.getEscapePatternParameters(), sortArray)).equals(this.query)) {
                this.refresh();
                this.query = newQuery;
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public PageSelections<Map<String, Serializable>> getCurrentSelectPage() {
        this.checkQueryCache();
        return super.getCurrentSelectPage();
    }

    protected void checkQueryCache() {
        Map<String, Serializable> props = this.getProperties();
        if (props.containsKey(CHECK_QUERY_CACHE_PROPERTY) && Boolean.TRUE.equals(Boolean.valueOf((String)((Object)props.get(CHECK_QUERY_CACHE_PROPERTY))))) {
            this.buildQuery();
        }
    }

    public String getCurrentQuery() {
        return this.query;
    }

    @Override
    protected void pageChanged() {
        super.pageChanged();
        this.currentItems = null;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.query = null;
        this.currentItems = null;
    }
}

