/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.helper;

import java.text.DecimalFormat;

public class DoubleConverter {
    private static final char NEGATIVE_PREFIX = '-';
    private static final char POSITIVE_PREFIX = '0';
    private static final Double MAX_ALLOWED = 9.9999999999999E13;
    private static final Double MIN_ALLOWED = -1.0E14;
    private static final String FORMAT = "000000000000000.00";

    private DoubleConverter() {
    }

    public static String format(Object value) {
        char prefix;
        Double i = (Double)value;
        if (i < MIN_ALLOWED || i > MAX_ALLOWED) {
            throw new IllegalArgumentException("out of allowed range");
        }
        if (i < 0.0) {
            prefix = '-';
            i = MAX_ALLOWED + i + 1.0;
        } else {
            prefix = '0';
        }
        DecimalFormat fmt = new DecimalFormat(FORMAT);
        return prefix + fmt.format(i);
    }
}

