/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionRecoveryManager;
import org.apache.jackrabbit.core.persistence.bundle.util.StringIndex;

public class DbNameIndex
implements StringIndex {
    static final String CVS_ID = "$URL: http://svn.eu.apache.org/repos/asf/jackrabbit/tags/jackrabbit-core-1.4.5/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/DbNameIndex.java $ $Rev: 577297 $ $Date: 2007-09-19 16:07:50 +0300 (Wed, 19 Sep 2007) $";
    protected ConnectionRecoveryManager connectionManager;
    protected String nameSelectSQL;
    protected String indexSelectSQL;
    protected String nameInsertSQL;
    private final HashMap string2Index = new HashMap();
    private final HashMap index2String = new HashMap();

    public DbNameIndex(ConnectionRecoveryManager conMgr, String schemaObjectPrefix) throws SQLException {
        this.connectionManager = conMgr;
        this.init(schemaObjectPrefix);
    }

    protected void init(String schemaObjectPrefix) throws SQLException {
        this.nameSelectSQL = "select NAME from " + schemaObjectPrefix + "NAMES where ID = ?";
        this.indexSelectSQL = "select ID from " + schemaObjectPrefix + "NAMES where NAME = ?";
        this.nameInsertSQL = "insert into " + schemaObjectPrefix + "NAMES (NAME) values (?)";
    }

    public void close() {
    }

    public int stringToIndex(String string) {
        Integer index = (Integer)this.string2Index.get(string);
        if (index == null) {
            String dbString = string.length() == 0 ? " " : string;
            int idx = this.getIndex(dbString);
            if (idx == -1) {
                idx = this.insertString(dbString);
            }
            index = new Integer(idx);
            this.string2Index.put(string, index);
            this.index2String.put(index, string);
            return idx;
        }
        return index;
    }

    public String indexToString(int idx) {
        Integer index = new Integer(idx);
        String s = (String)this.index2String.get(index);
        if (s == null) {
            s = this.getString(idx);
            if (s == null) {
                throw new IllegalStateException("String empty???");
            }
            if (s.equals(" ")) {
                s = "";
            }
            this.index2String.put(index, s);
            this.string2Index.put(s, index);
        }
        return s;
    }

    protected int insertString(String string) {
        ResultSet rs;
        block5: {
            rs = null;
            PreparedStatement stmt = this.connectionManager.executeStmt(this.nameInsertSQL, new Object[]{string}, true, 0);
            rs = stmt.getGeneratedKeys();
            if (rs.next()) break block5;
            int n = -1;
            this.closeResultSet(rs);
            return n;
        }
        try {
            int n = rs.getInt(1);
            this.closeResultSet(rs);
            return n;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Unable to insert index: " + e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    protected int getIndex(String string) {
        ResultSet rs;
        block5: {
            rs = null;
            PreparedStatement stmt = this.connectionManager.executeStmt(this.indexSelectSQL, new Object[]{string});
            rs = stmt.getResultSet();
            if (rs.next()) break block5;
            int n = -1;
            this.closeResultSet(rs);
            return n;
        }
        try {
            int n = rs.getInt(1);
            this.closeResultSet(rs);
            return n;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Unable to read index: " + e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    protected String getString(int index) {
        ResultSet rs;
        block5: {
            rs = null;
            PreparedStatement stmt = this.connectionManager.executeStmt(this.nameSelectSQL, new Object[]{new Integer(index)});
            rs = stmt.getResultSet();
            if (rs.next()) break block5;
            String string = null;
            this.closeResultSet(rs);
            return string;
        }
        try {
            String string = rs.getString(1);
            this.closeResultSet(rs);
            return string;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Unable to read name: " + e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

