/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexingQueueStore;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexingQueue {
    private static final Logger log = LoggerFactory.getLogger((Class)IndexingQueue.class);
    private final IndexingQueueStore queueStore;
    private final Map pendingDocuments = new HashMap();
    private volatile boolean initialized = false;

    IndexingQueue(IndexingQueueStore queueStore) {
        this.queueStore = queueStore;
    }

    void initialize(MultiIndex index) {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        String[] uuids = this.queueStore.getPending();
        for (int i = 0; i < uuids.length; ++i) {
            try {
                UUID uuid = UUID.fromString((String)uuids[i]);
                Document doc = index.createDocument(new NodeId(uuid));
                this.pendingDocuments.put(uuids[i], doc);
                continue;
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid UUID in indexing queue store: " + uuids[i]);
                continue;
            }
            catch (RepositoryException e) {
                log.debug("Node with uuid {} does not exist anymore", (Object)uuids[i]);
                try {
                    this.queueStore.removeUUID(uuids[i]);
                    continue;
                }
                catch (IOException ex) {
                    log.warn("Unable to remove node {} from indexing queue", (Object)uuids[i], (Object)ex);
                }
            }
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document[] getFinishedDocuments() {
        this.checkInitialized();
        ArrayList finished = new ArrayList();
        IndexingQueue indexingQueue = this;
        synchronized (indexingQueue) {
            finished.addAll(this.pendingDocuments.values());
        }
        Iterator it = finished.iterator();
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            if (Util.isDocumentReady(doc)) continue;
            it.remove();
        }
        return finished.toArray(new Document[finished.size()]);
    }

    public synchronized Document removeDocument(String uuid) throws IOException {
        this.checkInitialized();
        Document doc = (Document)this.pendingDocuments.remove(uuid);
        if (doc != null) {
            this.queueStore.removeUUID(uuid);
            log.debug("removed node {}. New size of indexing queue: {}", (Object)uuid, (Object)new Integer(this.pendingDocuments.size()));
        }
        return doc;
    }

    public synchronized Document addDocument(Document doc) throws IOException {
        this.checkInitialized();
        String uuid = doc.get(FieldNames.UUID);
        Document existing = this.pendingDocuments.put(uuid, doc);
        log.debug("added node {}. New size of indexing queue: {}", (Object)uuid, (Object)new Integer(this.pendingDocuments.size()));
        if (existing == null) {
            this.queueStore.addUUID(uuid);
        }
        return existing;
    }

    public synchronized void close() throws IOException {
        this.checkInitialized();
        Iterator it = this.pendingDocuments.values().iterator();
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            Util.disposeDocument(doc);
            it.remove();
        }
        this.queueStore.close();
    }

    public synchronized void commit() throws IOException {
        this.checkInitialized();
        this.queueStore.commit();
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }
}

