/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BLOBInDataStore
extends BLOBFileValue {
    private final DataStore store;
    private final DataIdentifier identifier;
    private static final String PREFIX = "dataStore:";
    private static Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    private BLOBInDataStore(DataStore store, DataIdentifier identifier) {
        if (!$assertionsDisabled && store == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && identifier == null) {
            throw new AssertionError();
        }
        this.store = store;
        this.identifier = identifier;
    }

    public void delete(boolean pruneEmptyParentDirs) {
    }

    public void discard() {
    }

    public boolean isImmutable() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BLOBInDataStore) || obj == null) {
            return false;
        }
        BLOBInDataStore other = (BLOBInDataStore)obj;
        return this.store == other.store && this.identifier.equals(other.identifier);
    }

    public int hashCode() {
        return 0;
    }

    public long getLength() {
        try {
            return this.getDataRecord().getLength();
        }
        catch (DataStoreException e) {
            log.warn("getLength for " + this.identifier + " failed", (Throwable)((Object)e));
            return -1L;
        }
    }

    public InputStream getStream() throws RepositoryException {
        return this.getDataRecord().getStream();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(20);
        buff.append(PREFIX);
        buff.append(this.identifier.toString());
        return buff.toString();
    }

    static BLOBInDataStore getInstance(DataStore store, String s) {
        String id = s.substring(PREFIX.length());
        DataIdentifier identifier = new DataIdentifier(id);
        return new BLOBInDataStore(store, identifier);
    }

    static BLOBInDataStore getInstance(DataStore store, InputStream in) throws DataStoreException {
        DataRecord rec = store.addRecord(in);
        DataIdentifier identifier = rec.getIdentifier();
        return new BLOBInDataStore(store, identifier);
    }

    static boolean isInstance(String s) {
        return s.startsWith(PREFIX);
    }

    private DataRecord getDataRecord() throws DataStoreException {
        return this.store.getRecord(this.identifier);
    }

    static {
        $assertionsDisabled = !BLOBInDataStore.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger((Class)BLOBInDataStore.class);
    }
}

