/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;

public interface RowMapper {
    public List<? extends RowId> read(Collection<RowId> var1) throws StorageException;

    public void write(RowBatch var1) throws StorageException;

    public Row readSimpleRow(RowId var1) throws StorageException;

    public Serializable[] readCollectionRowArray(RowId var1) throws StorageException;

    public Row readChildHierRow(Serializable var1, String var2, boolean var3) throws StorageException;

    public List<Row> readChildHierRows(Serializable var1, boolean var2) throws StorageException;

    public List<Row> getVersionRows(Serializable var1) throws StorageException;

    public List<Row> getProxyRows(Serializable var1, boolean var2, Serializable var3) throws StorageException;

    public CopyHierarchyResult copyHierarchy(IdWithTypes var1, Serializable var2, String var3, Row var4) throws StorageException;

    public Invalidations.InvalidationsPair receiveInvalidations() throws StorageException;

    public void sendInvalidations(Invalidations var1) throws StorageException;

    public void clearCache();

    public void rollback(Xid var1) throws XAException;

    public boolean isClusterReconnecting();

    public static final class CopyHierarchyResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Serializable copyId;
        public final Invalidations invalidations;

        public CopyHierarchyResult(Serializable copyId, Invalidations invalidations) {
            this.copyId = copyId;
            this.invalidations = invalidations;
        }
    }

    public static final class IdWithTypes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Serializable id;
        public final String primaryType;
        public final String[] mixinTypes;

        public IdWithTypes(Serializable id, String primaryType, String[] mixinTypes) {
            this.id = id;
            this.primaryType = primaryType;
            this.mixinTypes = mixinTypes;
        }

        public IdWithTypes(Node node) {
            this.id = node.getId();
            this.primaryType = node.getPrimaryType();
            this.mixinTypes = node.getMixinTypes();
        }
    }

    public static class RowBatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final List<Row> creates = new LinkedList<Row>();
        public final Set<RowUpdate> updates = new HashSet<RowUpdate>();
        public final Set<RowId> deletes = new HashSet<RowId>();

        public boolean isEmpty() {
            return this.creates.isEmpty() && this.updates.isEmpty() && this.deletes.isEmpty();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(creates=" + this.creates + ", updates=" + this.updates + ", deletes=" + this.deletes + ')';
        }
    }

    public static final class RowUpdate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Row row;
        public final Collection<String> keys;

        public RowUpdate(Row row, Collection<String> keys) {
            this.row = row;
            this.keys = keys;
        }

        public int hashCode() {
            return this.row.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof RowUpdate) {
                return this.equal((RowUpdate)other);
            }
            return false;
        }

        private boolean equal(RowUpdate other) {
            return other.row.equals(this.row);
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.row + ", keys=" + this.keys + ')';
        }
    }
}

