/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Dimension;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.renderkit.html.BaseGradient;
import org.richfaces.renderkit.html.images.GradientType;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class BaseControlBackgroundImage
extends BaseGradient {
    private static final Dimension DIMENSION = new Dimension(1, 1);

    public BaseControlBackgroundImage(String baseColor, String gradientColor, int width) {
        super(width, -1, baseColor, gradientColor);
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        Data data2 = (Data)data;
        if (data != null) {
            return new Dimension(super.getDimensions((FacesContext)facesContext, (Object)data).width, data2.getHeight());
        }
        return DIMENSION;
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        Data data = (Data)this.restoreData(resourceContext);
        if (data != null) {
            return new Dimension(super.getDimensions((ResourceContext)resourceContext).width, data.getHeight());
        }
        return DIMENSION;
    }

    protected final Integer getHeight(FacesContext context, String heightParamName) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String height = (String)skin.getParameter(context, heightParamName);
        if (height == null || height.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            height = (String)skin.getParameter(context, heightParamName);
        }
        if (height != null && height.length() != 0) {
            return HtmlDimensions.decode(height).intValue();
        }
        return 16;
    }

    protected Integer getHeight(FacesContext context) {
        return this.getHeight(context, "generalSizeFont");
    }

    public boolean isCacheable() {
        return true;
    }

    protected BaseGradient.Data createData() {
        return new Data();
    }

    protected void saveData(FacesContext context, BaseGradient.Data data, Object parameterData) {
        super.saveData(context, data, parameterData);
        Data d = (Data)data;
        d.setGradientType(GradientType.PLAIN);
        d.setHeight(this.getHeight(context));
    }

    protected void restoreData(BaseGradient.Data data, Zipper2 zipper2) {
        if (zipper2.hasMore()) {
            ((Data)data).setHeight(zipper2.nextInt());
            super.restoreData(data, zipper2);
        }
    }

    protected static class Data
    extends BaseGradient.Data {
        private static final long serialVersionUID = -1499766195614003931L;
        private Integer height;

        protected Data() {
        }

        public byte[] toByteArray() {
            byte[] bs = super.toByteArray();
            byte[] result = new byte[(bs != null ? bs.length : 0) + 4];
            new Zipper2(result).addInt(this.height).addBytes(bs);
            return result;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }
    }
}

