/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ws;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.api.ws.DocumentLoader;
import org.nuxeo.ecm.platform.api.ws.DocumentProperty;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSession;

public class DocumentStateLoader
implements DocumentLoader {
    protected static final Log log = LogFactory.getLog(DocumentStateLoader.class);

    @Override
    public void fillProperties(DocumentModel doc, List<DocumentProperty> props, WSRemotingSession rs) throws ClientException {
        CoreSession repo = rs.getDocumentManager();
        DocumentRef ref = doc.getRef();
        DocumentModel.DocumentModelRefresh dmr = repo.refreshDocument(ref, 1, null);
        for (Field f : dmr.getClass().getDeclaredFields()) {
            String fn = f.getName();
            try {
                Object fv = f.get(dmr);
                if (fv == null) continue;
                DocumentProperty prop = new DocumentProperty(fn, fv.toString());
                props.add(prop);
            }
            catch (Exception e) {
                log.error((Object)("Cannot fetch value for " + ref + ":" + fn), (Throwable)e);
            }
        }
    }
}

