/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingHttpServletResponse;
import org.nuxeo.ecm.webengine.PathDescriptor;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.DefaultContext;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.impl.AbstractWebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WebEngineFilter
implements Filter {
    public static final String TX_AUTO = "org.nuxeo.webengine.tx.auto";
    public static final String STATEFULL = "org.nuxeo.webengine.session.stateful";
    protected WebEngine engine;
    protected boolean isAutoTxEnabled;
    protected boolean isStatefull;
    protected static Log log = LogFactory.getLog(WebEngineFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initIfNeeded();
    }

    protected void initIfNeeded() {
        if (this.engine != null || Framework.getRuntime() == null) {
            return;
        }
        this.engine = (WebEngine)Framework.getLocalService(WebEngine.class);
        String v = Framework.getProperty((String)TX_AUTO, (String)"true");
        this.isAutoTxEnabled = Boolean.parseBoolean(v);
        v = Framework.getProperty((String)STATEFULL, (String)"false");
        this.isStatefull = Boolean.parseBoolean(v);
    }

    public void destroy() {
        this.engine = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.initIfNeeded();
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            PathDescriptor pd = this.engine.getRequestConfiguration().getMatchingConfiguration(req);
            Config config = new Config(req, pd, this.isAutoTxEnabled, this.isStatefull);
            AbstractWebContext ctx = this.initRequest(config, req, resp);
            if (config.txStarted) {
                resp = new BufferingHttpServletResponse(resp);
            }
            try {
                this.preRequest(req, resp);
                chain.doFilter(request, (ServletResponse)resp);
                this.postRequest(req, resp);
            }
            catch (Throwable e) {
                TransactionHelper.setTransactionRollbackOnly();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new ServletException(e);
            }
            finally {
                try {
                    this.cleanup(config, ctx, req, resp);
                }
                finally {
                    if (config.txStarted) {
                        ((BufferingHttpServletResponse)resp).stopBuffering();
                    }
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void preRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (null == request.getCharacterEncoding()) {
            request.setCharacterEncoding("UTF-8");
        }
    }

    public void postRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (null != request.getAttribute("org.nuxeo.webengine.DisableAutoHeaders")) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
            response.addHeader("Cache-Control", "must-revalidate");
            response.addHeader("Expires", "0");
            response.setDateHeader("Expires", 0L);
        }
    }

    public AbstractWebContext initRequest(Config config, HttpServletRequest request, HttpServletResponse response) {
        this.initTx(config, request);
        DefaultContext ctx = new DefaultContext(request);
        request.setAttribute(WebContext.class.getName(), (Object)ctx);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Config config, AbstractWebContext ctx, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.closeTx(config, request);
        }
        finally {
            request.removeAttribute(WebContext.class.getName());
        }
    }

    public void initTx(Config config, HttpServletRequest req) {
        if (!config.isStatic && config.autoTx && !TransactionHelper.isTransactionActive()) {
            config.txStarted = TransactionHelper.startTransaction();
        }
    }

    public void closeTx(Config config, HttpServletRequest req) {
        if (config.txStarted) {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    static class Config {
        boolean autoTx;
        boolean stateful;
        boolean txStarted;
        boolean locked;
        boolean isStatic;
        String pathInfo;

        public Config(HttpServletRequest req, PathDescriptor pd, boolean autoTx, boolean stateful) {
            String spath;
            if (pd == null) {
                this.autoTx = autoTx;
                this.stateful = stateful;
            } else {
                this.autoTx = pd.isAutoTx(autoTx);
                this.stateful = pd.isStateful(stateful);
            }
            this.pathInfo = req.getPathInfo();
            if (this.pathInfo == null || this.pathInfo.length() == 0) {
                this.pathInfo = "/";
            }
            this.isStatic = (spath = req.getServletPath()).contains("/skin") || this.pathInfo.contains("/skin/");
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("WebEngineFilter&Confi:");
            sb.append("\nPath Info:");
            sb.append(this.pathInfo);
            sb.append("\nAuto TX:");
            sb.append(this.autoTx);
            sb.append("\nStateful:");
            sb.append(this.stateful);
            sb.append("\nStatic:");
            sb.append(this.isStatic);
            return sb.toString();
        }
    }
}

