/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.FieldDescriptor;
import org.nuxeo.ecm.platform.types.FieldWidget;
import org.nuxeo.ecm.platform.types.TypeService;
import org.nuxeo.ecm.platform.ui.web.directory.VocabularyEntry;
import org.nuxeo.ecm.platform.ui.web.directory.VocabularyEntryList;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.search.FieldGroupDescriptor;
import org.nuxeo.ecm.webapp.search.FieldHelper;
import org.nuxeo.ecm.webapp.search.SearchColumns;
import org.nuxeo.ecm.webapp.search.SearchUIConfigService;
import org.nuxeo.ecm.webapp.search.SearchUIConfigServiceHelper;
import org.nuxeo.runtime.api.Framework;

@Name(value="searchColumns")
@Scope(value=ScopeType.CONVERSATION)
public class SearchColumnsBean
extends InputController
implements SearchColumns,
Serializable {
    private static final long serialVersionUID = -2462881843957407025L;
    private static final Log log = LogFactory.getLog(SearchColumnsBean.class);
    private static final String RESULT_FIELD_GROUPS = "resultFieldGroups";
    private static final String SEARCH_RESULTS_TYPE = "search_results";
    private static final String SEARCH_RESULT_COLUMNS = "resultColumns";
    private String newField;
    private Map<String, FieldWidget> fieldMap;
    private List<FieldWidget> resultColumns;
    private VocabularyEntryList fieldGroupEntries;
    private VocabularyEntryList fieldEntries;
    @RequestParameter(value="removeField")
    private String removeFieldName;
    private String fieldRef1;
    private String fieldRef2;
    private List<FieldWidget> defaultResultColumns;
    private String sortColumn;
    private boolean sortAscending;

    @Override
    @Create
    public void init() {
        log.debug((Object)"Initializing...");
        this.fieldMap = SearchColumnsBean.buildFieldMap();
        this.buildVocabularyEntries();
    }

    @Override
    public void destroy() {
        log.debug((Object)"Destroy...");
    }

    @PrePassivate
    public void saveState() {
        log.debug((Object)"PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.debug((Object)"PostActivate");
    }

    public String changeSearch() {
        return null;
    }

    @Override
    public String getNewField() {
        return this.newField;
    }

    @Override
    public void setNewField(String newField) {
        this.newField = newField;
    }

    @Override
    public String addField() {
        String ref = this.newField.substring(this.newField.indexOf("/") + 1);
        FieldWidget uiField = this.fieldMap.get(ref = ref.replace("/", ":"));
        if (uiField == null) {
            return null;
        }
        if (this.resultColumns.contains(uiField)) {
            FacesContext context = FacesContext.getCurrentInstance();
            String translatedText = SearchColumnsBean.translate(context, "label.search.column_already_added");
            FacesMessage msg = new FacesMessage(translatedText);
            context.addMessage("searchForm:resultNewField", msg);
            return null;
        }
        this.resultColumns.add(uiField);
        this.newField = null;
        return null;
    }

    protected static String translate(FacesContext context, String label) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }

    @Override
    public String removeField() {
        FieldWidget uiField = this.fieldMap.get(this.removeFieldName);
        this.resultColumns.remove(uiField);
        return null;
    }

    private void buildVocabularyEntries() {
        SearchUIConfigService service = SearchUIConfigServiceHelper.getConfigService();
        List<FieldGroupDescriptor> fields = service.getFieldGroups(RESULT_FIELD_GROUPS);
        this.fieldGroupEntries = new VocabularyEntryList("fieldGroups");
        this.fieldEntries = new VocabularyEntryList("fieldValues");
        for (FieldGroupDescriptor fieldGroupDescriptor : fields) {
            String groupLabel = fieldGroupDescriptor.getLabel();
            String groupName = fieldGroupDescriptor.getName();
            if (groupLabel == null) {
                groupLabel = "label.schema." + groupName;
                log.debug((Object)String.format("no label for fieldGroup %s, using %s", groupName, groupLabel));
            }
            VocabularyEntry fieldGroupEntry = new VocabularyEntry(groupName, groupLabel);
            this.fieldGroupEntries.add(fieldGroupEntry);
            for (FieldDescriptor fieldDescriptor : fieldGroupDescriptor.getFields()) {
                String ref = fieldDescriptor.getSchema() + ":" + fieldDescriptor.getName();
                FieldWidget fieldWidget = this.fieldMap.get(ref);
                if (fieldWidget == null) {
                    log.debug((Object)("field not found: " + ref));
                    continue;
                }
                String fieldLabel = fieldWidget.getLabel();
                String fieldRef = fieldWidget.getFullName();
                VocabularyEntry fieldEntry = new VocabularyEntry(fieldRef, fieldLabel, groupName);
                this.fieldEntries.add(fieldEntry);
            }
        }
    }

    @Override
    public VocabularyEntryList getFieldGroupEntries() {
        return this.fieldGroupEntries;
    }

    @Override
    public VocabularyEntryList getFieldEntries() {
        return this.fieldEntries;
    }

    @Override
    public String reset() {
        this.resultColumns = this.getDefaultResultColumns();
        return null;
    }

    private void swapResultColumns(String fieldRef1, String fieldRef2) throws ClientException {
        if (fieldRef1 == null || fieldRef2 == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        int beginIndex = "fieldRef:".length();
        String ref1 = fieldRef1.substring(beginIndex);
        String ref2 = fieldRef2.substring(beginIndex);
        int index = 0;
        int pos1 = -1;
        int pos2 = -1;
        for (FieldWidget field : this.resultColumns) {
            if (field.getFullName().equals(ref1)) {
                pos1 = index;
            }
            if (field.getFullName().equals(ref2)) {
                pos2 = index;
            }
            ++index;
        }
        if (pos1 == -1 || pos2 == -1) {
            throw new ClientException("field not found");
        }
        Collections.swap(this.resultColumns, pos1, pos2);
    }

    @Override
    public String getFieldRef1() {
        return this.fieldRef1;
    }

    @Override
    public void setFieldRef1(String fieldRef1) {
        this.fieldRef1 = fieldRef1;
    }

    @Override
    public String getFieldRef2() {
        return this.fieldRef2;
    }

    @Override
    public void setFieldRef2(String fieldRef2) {
        this.fieldRef2 = fieldRef2;
    }

    @Override
    public String swapColumns() throws ClientException {
        this.swapResultColumns(this.fieldRef1, this.fieldRef2);
        return null;
    }

    @Override
    @Begin(join=true)
    public List<FieldWidget> getResultColumns() {
        if (this.resultColumns == null) {
            this.resultColumns = this.getDefaultResultColumns();
        }
        return this.resultColumns;
    }

    @Override
    @Begin(join=true)
    public void setResultColumns(List<FieldWidget> resultColumns) {
        this.resultColumns = resultColumns;
    }

    @Override
    public Map<String, FieldWidget> getFieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = SearchColumnsBean.buildFieldMap();
        }
        return this.fieldMap;
    }

    @Override
    public List<FieldWidget> getDefaultResultColumns() {
        if (this.defaultResultColumns == null) {
            SearchUIConfigService service = SearchUIConfigServiceHelper.getConfigService();
            this.defaultResultColumns = new ArrayList<FieldWidget>();
            List<FieldDescriptor> fields = service.getResultColumns(SEARCH_RESULT_COLUMNS);
            for (FieldDescriptor desc : fields) {
                String fullName = desc.getSchema() + ":" + desc.getName();
                this.defaultResultColumns.add(this.fieldMap.get(fullName));
            }
        }
        return new ArrayList<FieldWidget>(this.defaultResultColumns);
    }

    @Override
    public void setDefaultResultColumnList(String[] resultColumnList) {
        this.defaultResultColumns = new ArrayList<FieldWidget>();
        for (String fullName : resultColumnList) {
            this.defaultResultColumns.add(this.fieldMap.get(fullName));
        }
    }

    private static Map<String, FieldWidget> buildFieldMap() {
        FieldWidget[] fieldWidgets;
        HashMap<String, FieldWidget> fieldMap = new HashMap<String, FieldWidget>();
        TypeService typeService = (TypeService)Framework.getRuntime().getComponent(TypeService.ID);
        for (FieldWidget fieldWidget : fieldWidgets = typeService.getTypeRegistry().getType(SEARCH_RESULTS_TYPE).getLayout()) {
            String fullName = fieldWidget.getFullName();
            String prefixedName = FieldHelper.getPrefixedName(fullName);
            if (prefixedName == null) {
                log.debug((Object)("field not found: " + fullName));
                continue;
            }
            fieldWidget.setPrefixedName(prefixedName);
            fieldMap.put(fieldWidget.getFullName(), fieldWidget);
        }
        return fieldMap;
    }

    @Override
    public String getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    @Override
    public boolean getSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }
}

