/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.cache;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.ui.web.cache.LRUCachingMap;

public class SimpleCacheHolder<T extends Serializable>
implements Serializable {
    public static final int DEFAULT_SIZE = 20;
    private static final long serialVersionUID = 1L;
    protected final Map<String, T> cacheMap;

    public SimpleCacheHolder() {
        this(20);
    }

    public SimpleCacheHolder(int maxSize) {
        this.cacheMap = new LRUCachingMap<String, T>(maxSize);
    }

    protected String getKey(DocumentRef docRef, String key) {
        if (docRef == null) {
            if (key == null) {
                return "default";
            }
            return key;
        }
        if (key == null) {
            return docRef.toString();
        }
        return docRef.toString() + "-" + key;
    }

    protected String getKey(DocumentModel doc, String key) {
        Calendar modified;
        DocumentRef docRef = doc.getRef();
        try {
            modified = (Calendar)doc.getProperty("dublincore", "modified");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        if (key == null) {
            if (modified != null) {
                key = modified.toString();
            }
        } else {
            key = key + "-" + key;
        }
        return this.getKey(docRef, key);
    }

    protected void doAdd(String key, T value) {
        this.cacheMap.put(key, value);
    }

    public void addToCache(String key, T value) {
        this.doAdd(key, value);
    }

    public void addToCache(DocumentRef docRef, String key, T value) {
        this.doAdd(this.getKey(docRef, key), value);
    }

    public void addToCache(DocumentModel doc, String key, T value) {
        this.doAdd(this.getKey(doc, key), value);
    }

    protected T doGet(String key) {
        return (T)((Serializable)this.cacheMap.get(key));
    }

    public T getFromCache(String key) {
        return this.doGet(key);
    }

    public T getFromCache(DocumentRef docRef, String key) {
        return this.doGet(this.getKey(docRef, key));
    }

    public T getFromCache(DocumentModel doc, String key) {
        return this.doGet(this.getKey(doc, key));
    }

    protected void doRemove(String key) {
        this.cacheMap.remove(key);
    }

    public void removeFromCache(DocumentRef docRef, String key) {
        this.doRemove(this.getKey(docRef, key));
    }

    public void removeFromCache(DocumentModel doc, String key) {
        this.doRemove(this.getKey(doc, key));
    }

    public void removeFromCache(String key) {
        this.doRemove(key);
    }
}

