/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Name(value="restHelper")
@Scope(value=ScopeType.EVENT)
public class RestHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    protected DocumentView docView;
    protected String baseURL = "";
    @In(create=true)
    protected transient LocaleSelector localeSelector;

    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public String initContextFromRestRequest(DocumentView docView) throws ClientException {
        DocumentLocation docLoc;
        String serverName;
        String outcome = null;
        if (docView != null && (serverName = (docLoc = docView.getDocumentLocation()).getServerName()) != null) {
            DocumentRef docRef = docLoc.getDocRef();
            RepositoryLocation repoLoc = new RepositoryLocation(serverName);
            if (docRef != null) {
                if (docView.getParameter("mainTabId") == null && !this.webActions.hasCurrentTabId("MAIN_TABS")) {
                    this.webActions.setCurrentTabId("MAIN_TABS", "documents", new String[0]);
                }
                outcome = this.navigationContext.navigateTo(repoLoc, docRef);
            } else {
                this.navigationContext.setCurrentServerLocation(repoLoc);
            }
        }
        return outcome;
    }

    public void setDocumentView(DocumentView docView) {
        this.docView = docView;
    }

    public DocumentView getNewDocumentView(String mainTabId) {
        DocumentViewImpl docView = null;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            DocumentLocationImpl docLoc = new DocumentLocationImpl(currentDocument);
            TypeInfo typeInfo = (TypeInfo)currentDocument.getAdapter(TypeInfo.class);
            HashMap<String, String> params = new HashMap<String, String>();
            if (currentDocument.isVersion()) {
                params.put("version", "true");
            }
            if (!StringUtils.isEmpty((String)mainTabId)) {
                params.put("mainTabId", "MAIN_TABS:" + mainTabId);
            }
            docView = new DocumentViewImpl((DocumentLocation)docLoc, typeInfo.getDefaultView(), params);
        }
        return docView;
    }

    public DocumentView getNewDocumentView() {
        return this.getNewDocumentView("documents");
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public static Manager getConversationManager() {
        if (Contexts.isEventContextActive()) {
            return Manager.instance();
        }
        return null;
    }

    protected static String addConversationRequestParameters(String url, Manager conversationManager, String conversationId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(conversationManager.getConversationIdParameter(), conversationId);
        return conversationManager.encodeParameters(url, params);
    }

    public static String addCurrentConversationParameters(String url) {
        Manager conversationManager = RestHelper.getConversationManager();
        if (conversationManager == null) {
            return url;
        }
        return conversationManager.encodeConversationId(url);
    }

    public static String addMainConversationParameters(String url) {
        Manager conversationManager = RestHelper.getConversationManager();
        if (conversationManager == null) {
            return url;
        }
        String conversationId = conversationManager.isNestedConversation() ? conversationManager.getParentConversationId() : conversationManager.getCurrentConversationId();
        return RestHelper.addConversationRequestParameters(url, conversationManager, conversationId);
    }

    public String getDocumentUrl(DocumentModel doc) {
        return DocumentModelFunctions.documentUrl(doc);
    }

    public String getDocumentUrl(DocumentModel doc, String viewId, boolean newConversation) {
        return DocumentModelFunctions.documentUrl(null, doc, viewId, null, newConversation, null);
    }

    public String getDocumentUrl(String patternName, DocumentModel doc, String viewId, Map<String, String> parameters, boolean newConversation) {
        return DocumentModelFunctions.documentUrl(patternName, doc, viewId, parameters, newConversation, null);
    }

    @Factory(value="baseURL", scope=ScopeType.CONVERSATION)
    public String getBaseURL() {
        if (this.baseURL.equals("")) {
            this.baseURL = BaseURL.getBaseURL();
        }
        return this.baseURL;
    }

    @Factory(value="contextPath", scope=ScopeType.CONVERSATION)
    public String getContextPath() {
        return BaseURL.getContextPath();
    }

    public String doPrint(String defaultTheme) throws IOException {
        return this.doPrint(this.navigationContext.getCurrentDocument(), defaultTheme);
    }

    public String doPrint(DocumentModel doc, String defaultTheme) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        HttpServletResponse response = RestHelper.getHttpServletResponse();
        if (response != null) {
            RestHelper.handleRedirect(response, this.getPrintUrl(doc, defaultTheme));
        }
        return null;
    }

    public String getPrintUrl(String defaultTheme) {
        return this.getPrintUrl(this.navigationContext.getCurrentDocument(), defaultTheme);
    }

    public String getPrintUrl(DocumentModel doc, String defaultTheme) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int separatorIndex = defaultTheme.indexOf("/");
        if (separatorIndex != -1) {
            defaultTheme = defaultTheme.substring(0, separatorIndex);
            StringBuilder sb = new StringBuilder();
            sb.append(defaultTheme);
            sb.append("/print");
            parameters.put("theme", sb.toString());
        }
        return DocumentModelFunctions.documentUrl(null, doc, null, parameters, false, null);
    }

    public static HttpServletResponse getHttpServletResponse() {
        ServletResponse response = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            response = (ServletResponse)facesContext.getExternalContext().getResponse();
        }
        if (response != null && response instanceof HttpServletResponse) {
            return (HttpServletResponse)response;
        }
        return null;
    }

    public static HttpServletRequest getHttpServletRequest() {
        ServletRequest request = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            request = (ServletRequest)facesContext.getExternalContext().getRequest();
        }
        if (request != null && request instanceof HttpServletRequest) {
            return (HttpServletRequest)request;
        }
        return null;
    }

    public static void handleRedirect(HttpServletResponse response, String url) throws IOException {
        response.resetBuffer();
        response.sendRedirect(url);
        response.flushBuffer();
        RestHelper.getHttpServletRequest().setAttribute("nuxeo.disable.redirect.wrapper", (Object)Boolean.TRUE);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public String getLocaleString() {
        return this.localeSelector.getLocaleString();
    }

    public void setLocaleString(String localeString) {
        if (localeString != null && !localeString.trim().isEmpty()) {
            this.localeSelector.setLocaleString(localeString);
        }
    }
}

