/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.impl.browser.TypeCache;
import org.apache.chemistry.opencmis.server.impl.browser.json.JSONConverter;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class ObjectService {
    private static final int BUFFER_SIZE = 65536;

    private ObjectService() {
    }

    public static void createDocument(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.openmis.browserbinding.objectId");
        VersioningState versioningState = HttpUtils.getEnumParameter(request, "versioningState", VersioningState.class);
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        ControlParser cp = new ControlParser(request);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        String newObjectId = service.createDocument(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, BrowserBindingUtils.createContentStream(request), versioningState, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, newObjectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        ObjectData object = objectInfo.getObject();
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        JSONObject jsonObject = JSONConverter.convert(object, typeCache);
        response.setStatus(201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createFolder(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.openmis.browserbinding.objectId");
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        ControlParser cp = new ControlParser(request);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        String newObjectId = service.createFolder(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, newObjectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        ObjectData object = objectInfo.getObject();
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        JSONObject jsonObject = JSONConverter.convert(object, typeCache);
        response.setStatus(201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.openmis.browserbinding.objectId");
        ReturnVersion returnVersion = HttpUtils.getEnumParameter(request, "returnVersion", ReturnVersion.class);
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includePolicyIds = HttpUtils.getBooleanParameter(request, "includePolicyIds");
        Boolean includeAcl = HttpUtils.getBooleanParameter(request, "includeACL");
        ObjectData object = null;
        object = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getObjectOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null) : service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert(object, typeCache);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int b;
        BigInteger length;
        BigInteger offset;
        String streamId;
        String objectId = (String)context.get("org.apache.chemistry.openmis.browserbinding.objectId");
        ContentStream content = service.getContentStream(repositoryId, objectId, streamId = HttpUtils.getStringParameter(request, "streamId"), offset = context.getOffset(), length = context.getLength(), null);
        if (content == null || content.getStream() == null) {
            throw new CmisRuntimeException("Content stream is null!");
        }
        String contentType = content.getMimeType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        if (offset == null && length == null) {
            response.setStatus(200);
        } else {
            response.setStatus(206);
        }
        response.setContentType(contentType);
        BufferedInputStream in = new BufferedInputStream(content.getStream(), 65536);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        byte[] buffer = new byte[65536];
        while ((b = ((InputStream)in).read(buffer)) > -1) {
            ((OutputStream)out).write(buffer, 0, b);
        }
        ((InputStream)in).close();
        ((OutputStream)out).flush();
    }
}

