/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.webengine.PathDescriptor;

public class RequestConfiguration {
    protected Set<PathDescriptor> paths = Collections.synchronizedSet(new HashSet());
    protected volatile PathDescriptor[] cache;

    public void addPathDescriptor(PathDescriptor path) {
        path.createMatcher();
        this.paths.add(path);
        this.cache = null;
    }

    public void removePathDescriptor(PathDescriptor path) {
        this.paths.remove(path);
        this.cache = null;
    }

    public PathDescriptor[] getPaths() {
        Object[] result = this.cache;
        if (result == null) {
            result = this.paths.toArray(new PathDescriptor[this.paths.size()]);
            Arrays.sort(result);
            this.cache = result;
        }
        return result;
    }

    public PathDescriptor getMatchingConfiguration(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || pathInfo.length() == 0) {
            pathInfo = "/";
        }
        for (PathDescriptor pd : this.getPaths()) {
            if (!pd.match(pathInfo)) continue;
            return pd;
        }
        return null;
    }
}

